/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.misc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class RingBuffer<E>
implements Serializable {
    private static final long serialVersionUID = 5015372387740172285L;
    private Object[] buffer;
    private int ptrt;
    private int ptrb;

    public RingBuffer(int size) {
        this.buffer = new Object[size];
        this.ptrt = 0;
        this.ptrb = -1;
    }

    private void incb() {
        this.ptrb = this.ptrb < this.buffer.length ? this.ptrb + 1 : 1;
    }

    private void inct() {
        this.ptrt = this.ptrt < this.buffer.length ? this.ptrt + 1 : 1;
    }

    private void dect() {
        this.ptrt = this.ptrt > 0 ? this.ptrt - 1 : this.buffer.length - 1;
    }

    private int index(int c) {
        return (this.ptrb + c) % this.buffer.length;
    }

    public boolean add(Object c) {
        if (this.ptrb < 0) {
            this.ptrb = 0;
        } else if (this.ptrt % this.buffer.length == this.ptrb % this.buffer.length) {
            this.incb();
        }
        this.buffer[this.ptrt < this.buffer.length ? this.ptrt : 0] = c;
        this.inct();
        return this.size() < this.buffer.length;
    }

    public E remove() {
        if (this.ptrb < 0) {
            throw new NoSuchElementException();
        }
        this.dect();
        Object res = this.buffer[this.ptrt];
        if (this.ptrb == this.ptrt) {
            this.ptrb = -1;
        }
        return (E)res;
    }

    public int size() {
        if (this.ptrb < 0) {
            return 0;
        }
        return this.ptrt <= this.ptrb ? this.ptrt + this.buffer.length - this.ptrb : this.ptrt - this.ptrb;
    }

    public E get(int c) {
        if (c >= this.buffer.length) {
            throw new IndexOutOfBoundsException("" + c);
        }
        if (c >= this.size()) {
            throw new NoSuchElementException();
        }
        return (E)this.buffer[this.index(c)];
    }

    public boolean isEmpty() {
        return this.ptrb < 0;
    }

    public void clear() {
        this.ptrt = 0;
        this.ptrb = -1;
    }

    public List<E> toList() {
        ArrayList<Object> l = new ArrayList<Object>();
        int e = this.ptrb < this.ptrt ? this.ptrt : this.ptrt + this.buffer.length;
        int i = this.ptrb;
        while (i < e) {
            l.add(this.buffer[i % this.buffer.length]);
            ++i;
        }
        return l;
    }
}

