/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.translate;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.morilib.automata.DFAState;
import net.morilib.nina.DFABuilder;
import net.morilib.nina.NinaState;
import net.morilib.nina.translate.AbstractNinaTranslator;
import net.morilib.nina.translate.NinaTranslator;
import net.morilib.nina.translate.ReplaceAction;
import net.morilib.nina.translate.sh.ReplaceStrangeChar;
import net.morilib.range.Interval;

public class NinaTranslatorJava
extends AbstractNinaTranslator {
    private static final Pattern RET_CONST = Pattern.compile("return +([A-Za-z][A-Za-z0-9]*\\.)*[A-Z][A-Z0-9]*;");
    private static final Pattern E_CONST = Pattern.compile("([A-Za-z][A-Za-z0-9]*\\.)*[A-Z][A-Z0-9]*");

    private String tostr(int c) {
        String x = c == 92 ? "'\\\\'" : (c == 10 ? "'\\n'" : (c == 39 ? "'\\''" : (Character.isISOControl(c) ? Integer.toString(c) : (c < 65535 ? String.format("'%c'", Character.valueOf((char)c)) : Integer.toString(c)))));
        return x;
    }

    private void printintv(PrintStream out, Interval v, boolean els) {
        String s = v.isInfimumClosed() ? ">=" : ">";
        String t = v.isSupremumClosed() ? "<=" : "<";
        String a = els ? "\t\t\t} else if" : "\t\t\tif";
        int c = (Integer)v.getInfimumBound();
        int d = (Integer)v.getSupremumBound();
        String x = this.tostr(c);
        String y = this.tostr(d);
        if (v.isClosed() && c == d) {
            out.format("%s($c == %s) {\n", a, x);
        } else {
            out.format("%s($c %s %s && $c %s %s) {\n", a, s, x, t, y);
        }
    }

    private void printobj(PrintStream out, Object o, boolean els) {
        String a = els ? "\t\t\t} else if" : "\t\t\tif";
        out.format("%s($c.equals(\"%s\")) {\n", a, o.toString());
    }

    private void printclass(PrintStream out, Object o, boolean els) {
        String a;
        String string = a = els ? "\t\t\t} else if" : "\t\t\tif";
        if (o instanceof Character) {
            char c = ((Character)o).charValue();
            String s = c == '\\' || c == '\'' ? String.format("Character.valueOf('\\%c')", Character.valueOf(c)) : String.format("Character.valueOf('%c')", Character.valueOf(c));
            out.format("%s(%s.equals($c)) {\n", a, s);
        } else {
            String s = o.toString();
            if (E_CONST.matcher(s).matches()) {
                out.format("%s(%s.equals($c)) {\n", a, s);
            } else {
                out.format("%s($c instanceof %s) {\n", a, s);
            }
        }
    }

    private String outln(boolean els, PrintStream out) {
        if (els) {
            out.println("\t\t\t} else {");
            return "\t";
        }
        return "";
    }

    private boolean putend(String s, PrintStream out, DFAState<Object, ?, Void> dfa, boolean els) {
        DFABuilder.DBS b;
        if (dfa instanceof DFABuilder.DBS && (b = ((DFABuilder.DBS)dfa).getEnd()) != null) {
            if (els) {
                out.printf("\t\t\t} else if(%s) {\n", s);
            } else {
                out.printf("\t\t\tif(%s) {\n", s);
            }
            Object o = ((DFABuilder.DBS)dfa).getMealyEnd();
            if (o != null) {
                out.format("\t\t\t\t%s\n", o.toString());
            }
            out.format("\t\t\t\tSTATE = %d;\n", this.getStateNo(b));
            out.format("\t\t\t\treturn 1;\n", new Object[0]);
            els = true;
        }
        return els;
    }

    private boolean putuseredges(PrintStream out, DFAState<Object, ?, Void> dfa, boolean els) {
        Set<String> k;
        if (dfa instanceof DFABuilder.DBS && (k = ((DFABuilder.DBS)dfa).getUserEdges()) != null) {
            for (String x : k) {
                DFABuilder.DBS b = ((DFABuilder.DBS)dfa).getUserEdge(x);
                Object o = ((DFABuilder.DBS)dfa).getUserMealyEdge(x);
                if (els) {
                    out.printf("\t\t\t} else if(__g && (%s)) {\n", x);
                } else {
                    out.printf("\t\t\tif(__g && (%s)) {\n", x);
                }
                if (o != null) {
                    out.format("\t\t\t\t%s\n", o.toString());
                }
                out.format("\t\t\t\tSTATE = %d;\n", this.getStateNo(b));
                out.format("\t\t\t\treturn 1;\n", new Object[0]);
                els = true;
            }
        }
        return els;
    }

    private boolean putothers(PrintStream out, DFAState<Object, ?, Void> dfa, boolean els) {
        boolean el2 = true;
        if (dfa instanceof DFABuilder.DBS) {
            DFABuilder.DBS a = (DFABuilder.DBS)dfa;
            DFABuilder.DBS b = a.getOthers();
            if (b != null) {
                String s = this.outln(els, out);
                Object o = a.getMealyOthers();
                if (o != null) {
                    out.format("%s\t\t\t%s\n", s, o.toString());
                }
                out.format("%s\t\t\tSTATE = %d;\n", s, this.getStateNo(b));
                out.format("%s\t\t\treturn 1;\n", s);
                el2 = false;
            } else {
                b = a.getRecursive();
                if (b != null) {
                    String s = this.outln(els, out);
                    String t = ReplaceStrangeChar.replace(a.getRecursiveName());
                    out.format("%s\t\t\t__stkpush(%d, ENGINE_%s);\n", s, this.getStateNo(b), t);
                    out.format("%s\t\t\tSTATE = 0;\n", s);
                    out.format("%s\t\t\treturn -1;\n", s);
                    el2 = false;
                }
            }
        }
        return el2;
    }

    private void printState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        boolean els = false;
        boolean el2 = true;
        int sn = this.getStateNo(dfa);
        out.format("\t\tcase %d:\n", sn);
        for (Interval v : dfa.getAlphabetRanges()) {
            Object o;
            this.printintv(out, v, els);
            int c = (Integer)v.getInfimumBound();
            if (v.isInfimumOpen()) {
                ++c;
            }
            if ((o = dfa.getLabelInt(c)) != null) {
                out.format("\t\t\t\t%s\n", o.toString());
            }
            DFAState<Object, ?, Void> d = dfa.goInt(c);
            out.format("\t\t\t\tSTATE = %d;\n", this.getStateNo(d));
            out.println("\t\t\t\treturn 1;");
            els = true;
        }
        els = this.putend("$c < 0", out, dfa, els);
        els = this.putuseredges(out, dfa, els);
        el2 = this.putothers(out, dfa, els);
        if (els) {
            out.println("\t\t\t}");
        }
        if (el2) {
            out.println("\t\t\treturn 0;");
        }
    }

    private void printObjectState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        boolean els = false;
        boolean el2 = true;
        int sn = this.getStateNo(dfa);
        out.format("\t\tcase %d:\n", sn);
        for (Object p : dfa.getAlphabets()) {
            this.printobj(out, p, els);
            Object o = dfa.getLabel(p);
            if (o != null) {
                out.format("\t\t\t\t%s\n", o.toString());
            }
            DFAState<Object, ?, Void> d = dfa.go(p);
            out.format("\t\t\t\tSTATE = %d;\n", this.getStateNo(d));
            out.println("\t\t\t\treturn 1;");
            els = true;
        }
        els = this.putend("$c == null", out, dfa, els);
        els = this.putuseredges(out, dfa, els);
        el2 = this.putothers(out, dfa, els);
        if (els) {
            out.println("\t\t\t}");
        }
        if (el2) {
            out.println("\t\t\treturn 0;");
        }
    }

    private void printClassState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        boolean els = false;
        boolean el2 = true;
        int sn = this.getStateNo(dfa);
        out.format("\t\tcase %d:\n", sn);
        for (Object p : dfa.getAlphabets()) {
            this.printclass(out, p, els);
            Object o = dfa.getLabel(p);
            if (o != null) {
                out.format("\t\t\t\t%s\n", o.toString());
            }
            DFAState<Object, ?, Void> d = dfa.go(p);
            out.format("\t\t\t\tSTATE = %d;\n", this.getStateNo(d));
            out.println("\t\t\t\treturn 1;");
            els = true;
        }
        els = this.putend("$c == null", out, dfa, els);
        els = this.putuseredges(out, dfa, els);
        el2 = this.putothers(out, dfa, els);
        if (els) {
            out.println("\t\t\t}");
        }
        if (el2) {
            out.println("\t\t\treturn 0;");
        }
    }

    private boolean isProcessed(DFAState<Object, ?, Void> state) {
        return this.containsState(state);
    }

    private int getDeadStateNo() {
        Object s = this.builder.getDeadState();
        return this.containsState(s) ? this.stateNo(s) : -1;
    }

    private int getStateNoByLabel(String l) {
        Object s = this.builder.getStateByLabel(l);
        return this.containsState(s) ? this.stateNo(s) : -1;
    }

    @Override
    public void printStates(PrintStream out) {
        this.getStateNo(this.dfa.getInitialState());
        while (!this.isStackEmpty()) {
            this.printState(out, this.popStack());
        }
        for (String t : this.builder.getLabels()) {
            DFAState s = (DFAState)this.builder.getStateByLabel(t);
            if (s == null || this.isProcessed(s)) continue;
            this.getStateNo(s);
            while (!this.isStackEmpty()) {
                this.printState(out, this.popStack());
            }
        }
    }

    @Override
    public void printObjectStates(PrintStream out) {
        this.getStateNo(this.dfa.getInitialState());
        while (!this.isStackEmpty()) {
            this.printObjectState(out, this.popStack());
        }
        for (String t : this.builder.getLabels()) {
            DFAState s = (DFAState)this.builder.getStateByLabel(t);
            if (s == null || this.isProcessed(s)) continue;
            this.getStateNo(s);
            while (!this.isStackEmpty()) {
                this.printObjectState(out, this.popStack());
            }
        }
    }

    @Override
    public void printClassStates(PrintStream out) {
        this.getStateNo(this.dfa.getInitialState());
        while (!this.isStackEmpty()) {
            this.printClassState(out, this.popStack());
        }
        for (String t : this.builder.getLabels()) {
            DFAState s = (DFAState)this.builder.getStateByLabel(t);
            if (s == null || this.isProcessed(s)) continue;
            this.getStateNo(s);
            while (!this.isStackEmpty()) {
                this.printClassState(out, this.popStack());
            }
        }
    }

    @Override
    public void printAcceptStates(PrintStream out) {
        String d = "\t\treturn (";
        if (this.acceptsSize() == 0) {
            out.println("\t\treturn false;");
        } else {
            for (Integer i : this.acceptsIterable()) {
                out.print(d);
                out.format("STATE == %d", i);
                d = " ||\n\t\t\t\t";
            }
            out.println(");");
        }
    }

    @Override
    public void printAcceptToken(PrintStream out) {
        int m = -1;
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            if (!s.isAccepted()) continue;
            String p = null;
            out.format("\t\tcase %d:\n", this.stateNo(s));
            for (Object a : s.getAccepted()) {
                int q;
                if (a == null || !(a instanceof NinaState) || (q = ((NinaState)a).getPriority()) < 0 || q <= m) continue;
                m = q;
            }
            for (Object a : s.getAccepted()) {
                NinaState n;
                String x;
                if (a == null || !(a instanceof NinaState) || (x = (n = (NinaState)a).getLabel()) == null || (x = x.trim()).equals("")) continue;
                if (m >= 0) {
                    if (n.getPriority() != m) continue;
                    p = x;
                    continue;
                }
                if (RET_CONST.matcher(x).matches()) {
                    p = x;
                    break;
                }
                if (p != null) {
                    this.getOptions().pwarn("ambiguousaccept", new Object[0]);
                }
                p = x;
            }
            out.format("\t\t\t%s\n", p != null ? p : "return $$;");
        }
    }

    @Override
    public void printActions(PrintStream out) {
        boolean[] a = new boolean[1];
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            String p = null;
            out.format("\t\tcase %d:\n", this.stateNo(s));
            String x = s.toString();
            if (x != null && !(x = x.trim()).equals("")) {
                p = x;
            }
            if (p == null) {
                out.println("\t\t\tbreak;");
                continue;
            }
            p = ReplaceAction.replace(p, a, this, this.stateNo(s), this.builder.getLabelByState(s));
            out.format("\t\t\t%s\n", p);
            if (a[0]) continue;
            out.println("\t\t\tbreak;");
        }
    }

    @Override
    public void printImports(List<String> imp, PrintStream out) {
        for (String s : imp) {
            out.format("import %s;\n", s);
        }
    }

    @Override
    public void printIsEnd(PrintStream out) {
        HashSet<Integer> t = new HashSet<Integer>();
        String d = "\t\treturn (";
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            if (!(s instanceof DFABuilder.DBS) || ((DFABuilder.DBS)s).getEnd() == null) continue;
            t.add(this.stateNo(s));
        }
        if (t.size() == 0) {
            out.println("\t\treturn false;");
        } else {
            for (Integer i : t) {
                out.print(d);
                out.format("STATE == %d", i);
                d = " ||\n\t\t\t\t";
            }
            out.println(");");
        }
    }

    @Override
    public void printDeadState(String n, PrintStream out) {
        out.printf("\t\t\treturn %d;\n", this.getDeadStateNo());
    }

    @Override
    protected void printRecover(PrintStream out) {
        String d = "";
        for (String x : this.builder.getLabels()) {
            if (!x.endsWith("Exception")) continue;
            DFAState s = (DFAState)this.builder.getStateByLabel(x);
            out.printf("\t\t\t%sif(e instanceof %s) {\n", d, x);
            out.printf("\t\t\t\treturn %d;\n", this.getStateNo(s));
            d = "} else ";
        }
        if (d.equals("")) {
            out.println("\t\t\treturn -1;");
        } else {
            out.println("\t\t\t} else {");
            out.println("\t\t\t\treturn -1;");
            out.println("\t\t\t}");
        }
    }

    @Override
    public void printFinallyState(PrintStream out) {
        out.printf("\t\t\treturn %d;\n", this.getStateNoByLabel("finally"));
    }

    @Override
    protected void printAttrs(PrintStream out) {
    }

    @Override
    public void reportStatistics(PrintStream std) {
        this.getOptions().print("statheader", new Object[0]);
        this.getOptions().print("statstates", this.stateSize());
        this.getOptions().print("stataccept", this.acceptsSize());
    }

    @Override
    protected InputStream openScript() {
        return NinaTranslator.class.getResourceAsStream("/net/morilib/nina/translate/nina_template." + this.getMachine() + ".java.sh");
    }

    @Override
    protected PrintStream openOutput() throws IOException {
        return new PrintStream(new FileOutputStream(this.getOptions().getJavaFile()), true);
    }

    @Override
    protected AbstractNinaTranslator newPrototype() {
        NinaTranslatorJava r = new NinaTranslatorJava();
        r.quadro = this.quadro;
        return r;
    }

    @Override
    protected void appendValue(StringBuffer ot, StringBuffer b1) {
        Object o = this.builder.getStateByLabel(b1.toString());
        String t = this.builder.getTypeByLabel(b1.toString());
        if (o == null) {
            ot.append('$');
            ot.append(b1);
        } else if (t == null) {
            ot.append("(__stv[__slen - 1][");
            ot.append(this.stateNo(o));
            ot.append("])");
        } else if (t.equals("byte")) {
            ot.append("((Byte)(__stv[__slen - 1][");
            ot.append(this.stateNo(o));
            ot.append("])).byteValue()");
        } else if (t.equals("short")) {
            ot.append("((Short)(__stv[__slen - 1][");
            ot.append(this.stateNo(o));
            ot.append("])).shortValue()");
        } else if (t.equals("int")) {
            ot.append("((Integer)(__stv[__slen - 1][");
            ot.append(this.stateNo(o));
            ot.append("])).intValue()");
        } else if (t.equals("long")) {
            ot.append("((Long)(__stv[__slen - 1][");
            ot.append(this.stateNo(o));
            ot.append("])).longValue()");
        } else if (t.equals("double")) {
            ot.append("((Double)(__stv[__slen - 1][");
            ot.append(this.stateNo(o));
            ot.append("])).doubleValue()");
        } else if (t.equals("float")) {
            ot.append("((Byte)(__stv[__slen - 1][");
            ot.append(this.stateNo(o));
            ot.append("])).floatValue()");
        } else if (t.equals("char")) {
            ot.append("((Character)(__stv[__slen - 1][");
            ot.append(this.stateNo(o));
            ot.append("])).charValue()");
        } else {
            ot.append("((");
            ot.append(t);
            ot.append(")(__stv[__slen - 1][");
            ot.append(this.stateNo(o));
            ot.append("]))");
        }
    }

    @Override
    protected void appendLvalue(StringBuffer ot, StringBuffer b1) {
        Object o = this.builder.getStateByLabel(b1.toString());
        if (o == null) {
            ot.append('@');
            ot.append(b1);
        } else {
            ot.append("(__stv[__slen - 1][");
            ot.append(this.stateNo(o));
            ot.append("])");
        }
    }

    @Override
    protected void appendMyPosition(StringBuffer ot, String ln, int cn) {
        ot.append("(__stv[__slen - 1][");
        ot.append(cn);
        ot.append("])");
    }

    @Override
    protected void appendReturn(StringBuffer ot) {
        ot.append("$$");
    }
}

