/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.morilib.nina.cmd.Ninat;
import net.morilib.nina.cmd.NinatOptions;
import net.morilib.nina.translate.AbstractNinaTranslator;

public class NinatTask {
    private String src;
    private String outfile;
    private String lang;
    private List<Param> params = new ArrayList<Param>();
    private List<Library> libs = new ArrayList<Library>();

    public Param createParameter() {
        Param p = new Param();
        this.params.add(p);
        return p;
    }

    public Library createLibrary() {
        Library p = new Library();
        this.libs.add(p);
        return p;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setOutfile(String outfile) {
        this.outfile = outfile;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void execute() {
        Ninat a = new Ninat();
        a.opts = new NinatOptions();
        HashMap<String, String> z = new HashMap<String, String>();
        for (Param param : this.params) {
            z.put(param.name, param.value);
        }
        for (Library library : this.libs) {
            a.opts.libs.add(library.path);
        }
        if (this.outfile != null) {
            a.opts.opts.put("outfile", this.outfile);
        }
        if (this.lang != null) {
            AbstractNinaTranslator t = AbstractNinaTranslator.getTranslator(this.lang);
            a.opts.setTranslator(t);
        }
        a.process(this.src, z, false);
        a.opts.print("anttranslated", this.src);
    }

    public static class Library {
        private String path;

        public void setPath(String path) {
            this.path = path;
        }
    }

    public static class Param {
        private String name;
        private String value;

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

