/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.automata.DFA;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaConsole;
import net.morilib.nina.NinaDFAPattern;
import net.morilib.nina.NinaException;
import net.morilib.nina.NinaNFA;
import net.morilib.nina.NinaNFAPattern;
import net.morilib.nina.NinaParser;
import net.morilib.nina.NinaPattern;
import net.morilib.nina.Quadro;
import net.morilib.util.CharCodes;

public final class Nina {
    public static final String VERSION = "0.3.0.1";
    private static final Pattern FANM = Pattern.compile("(.*/)?([^/.]+)(\\..*)?");

    private Nina() {
    }

    static Object prendClasse(String s) {
        return Nina.prendClasse("", s);
    }

    static Object prendClasse(String d, String n) {
        String s = n;
        try {
            if (s.indexOf(46) < 0) {
                s = String.valueOf(d) + "." + n;
            }
            Class<?> c = Class.forName(s);
            return c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (InstantiationException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
    }

    static void apelle(Object o, String s, Object ... os) {
        Class[] a = new Class[os.length];
        Class<?> c = o.getClass();
        try {
            int i = 0;
            while (i < os.length) {
                a[i] = os[i].getClass();
                ++i;
            }
            Method m = c.getMethod(s, a);
            m.invoke(o, os);
        }
        catch (SecurityException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
    }

    static void apelleInt(Object o, String s, int n) {
        Class<?> c = o.getClass();
        try {
            Method m = c.getMethod(s, Integer.TYPE);
            m.invoke(o, n);
        }
        catch (SecurityException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
    }

    static int prendCharcode(String charset, int c) {
        try {
            int x = CharCodes.unicodeToOtherCode((char)c, charset);
            return x;
        }
        catch (UnsupportedEncodingException e) {
            throw new NinaException(e, "unsupportedcharset", charset);
        }
    }

    public static String getFAName(String s) {
        Matcher m = FANM.matcher(s);
        if (!m.matches()) {
            throw new RuntimeException();
        }
        return m.group(2);
    }

    public static NinaAction compile(String name, String s, Map<String, String> prms, Map<String, Object> sub, NinaConsole cons) {
        return NinaParser.compile(Quadro.read(name, s), null, null, prms, sub, cons, 0);
    }

    public static NinaAction compile(String name, Reader rd, List<String> libs, Map<String, String> prms, Map<String, Object> sub, NinaConsole cons) throws IOException {
        return NinaParser.compile(Quadro.read(name, rd), null, libs, prms, sub, cons, 0);
    }

    public static NinaAction compile(String name, Reader rd, Map<String, String> prms, Map<String, Object> sub, NinaConsole cons) throws IOException {
        return NinaParser.compile(Quadro.read(name, rd), null, null, prms, sub, cons, 0);
    }

    public static NinaAction compileResource(String name, Map<String, String> prms, Map<String, Object> sub, NinaConsole cons) throws IOException {
        return NinaParser.compile(Quadro.readResource(name), null, null, prms, sub, cons, 0);
    }

    public static NinaAction trace(String name, String s, Map<String, String> prms, Map<String, Object> sub, NinaConsole cons, boolean pause) {
        return NinaParser.compile(Quadro.read(name, s), null, null, prms, sub, cons, 2 | (pause ? 1 : 0));
    }

    public static NinaAction trace(String name, Reader rd, Map<String, String> prms, Map<String, Object> sub, NinaConsole cons, boolean pause) throws IOException {
        return NinaParser.compile(Quadro.read(name, rd), null, null, prms, sub, cons, 2 | (pause ? 1 : 0));
    }

    public static NinaAction traceResource(String name, Map<String, String> prms, Map<String, Object> sub, NinaConsole cons, boolean pause) throws IOException {
        return NinaParser.compile(Quadro.readResource(name), null, null, prms, sub, cons, 2 | (pause ? 1 : 0));
    }

    private static NinaPattern cst(Object o) {
        if (o instanceof NinaNFA) {
            return new NinaNFAPattern((NinaNFA)o);
        }
        if (o instanceof DFA) {
            return new NinaDFAPattern((DFA)o);
        }
        throw new ClassCastException();
    }

    public static NinaPattern pattern(String name, String s, Map<String, String> prms, Map<String, Object> sub, NinaConsole cons) {
        return Nina.cst(Nina.compile(name, s, prms, sub, cons).getMachine());
    }

    public static NinaPattern pattern(String name, Reader rd, Map<String, String> prms, Map<String, Object> sub, NinaConsole cons) throws IOException {
        return Nina.cst(Nina.compile(name, rd, prms, sub, cons));
    }

    public static NinaPattern patternResource(String name, Map<String, String> prms, Map<String, Object> sub, NinaConsole cons) throws IOException {
        return Nina.cst(Nina.compileResource(name, prms, sub, cons).getMachine());
    }

    public static NinaPattern patternTrace(String name, String s, Map<String, String> prms, Map<String, Object> sub, NinaConsole cons, boolean z) {
        return Nina.cst(Nina.trace(name, s, prms, sub, cons, z));
    }

    public static NinaPattern patternTrace(String name, Reader rd, Map<String, String> prms, Map<String, Object> sub, NinaConsole cons, boolean z) throws IOException {
        return Nina.cst(Nina.trace(name, rd, prms, sub, cons, z));
    }

    public static NinaPattern patternResourceTrace(String name, Map<String, String> prms, Map<String, Object> sub, NinaConsole cons, boolean z) throws IOException {
        return Nina.cst(Nina.traceResource(name, prms, sub, cons, z));
    }
}

