/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano.util;

public final class DoubleUtils {
    private static final int EMAX = 2047;
    private static final int EXPBIT = 52;
    private static final long EXPMASK = 0x7FF0000000000000L;
    private static final long SIGMASK = 0xFFFFFFFFFFFFFL;
    private static final long SGNMASK = Long.MIN_VALUE;
    public static final int MAX_EXPONENT = 1023;
    public static final int MIN_NORMALIZED_EXPONENT = -1022;
    public static final int MIN_EXPONENT = -1074;
    public static final int FRACTION_BITS = 52;
    public static final int BIAS = 1023;
    public static final long POSITIVE_INFINITY_BY_LONG = 0x7FF0000000000000L;
    public static final long NEGATIVE_INFINITY_BY_LONG = -4503599627370496L;
    public static final long MAX_VALUE_BY_SHORT = 0x7FEFFFFFFFFFFFFFL;
    public static final long MIN_VALUE_BY_SHORT = -4503599627370497L;
    public static final long ZERO = 0L;
    public static final long MINUS_ZERO = -1152921504606846976L;

    static double _getDouble(int sign, int exp, long frac) {
        long l = 0L;
        l |= sign == 1 ? Long.MIN_VALUE : 0L;
        if (exp > 1023) {
            return l | 0x7FF0000000000000L;
        }
        if (exp >= -1022) {
            l |= (long)(exp + 1023) << 52;
        } else if (exp < -1074) {
            return Double.longBitsToDouble(l);
        }
        return Double.longBitsToDouble(l |= frac & 0xFFFFFFFFFFFFFL);
    }

    public static int getSignumField(long x) {
        return x < 0L ? 1 : 0;
    }

    public static int getExponentField(long x) {
        return (int)((x & 0x7FF0000000000000L) >> 52);
    }

    public static long getFractionField(long x) {
        return x & 0xFFFFFFFFFFFFFL;
    }

    private static int _getMsb(long x, int s, int e) {
        if (s == e) {
            return s;
        }
        int c = (e - s >> 1) + s;
        int m = (1 << (e - s >> 1) + 1) - 1 << c;
        if ((x & (long)m) != 0L) {
            return DoubleUtils._getMsb(x, c + 1, e);
        }
        return DoubleUtils._getMsb(x, s, c);
    }

    public static int getMsb(long x) {
        return x == 0L ? 0 : DoubleUtils._getMsb(x, 0, 63);
    }

    private static int _getLsb(long x, int s, int e) {
        if (s == e) {
            return s + 1;
        }
        int c = (e - s >> 1) + s;
        int m = (1 << (e - s >> 1) + 1) - 1 << s;
        if ((x & (long)m) != 0L) {
            return DoubleUtils._getLsb(x, s, c);
        }
        return DoubleUtils._getLsb(x, c + 1, e);
    }

    public static int getLsb(long x) {
        return x == 0L ? 0 : DoubleUtils._getLsb(x, 0, 63);
    }

    public static boolean isZero(long x) {
        return (x & Long.MAX_VALUE) == 0L;
    }

    public static int getExponent(double d) {
        long x = Double.doubleToLongBits(d);
        int e = DoubleUtils.getExponentField(x);
        long f = DoubleUtils.getFractionField(x);
        if (DoubleUtils.isZero(x)) {
            return 0;
        }
        if (e == 2047) {
            if (f == 0L) {
                return 1024;
            }
            return Integer.MIN_VALUE;
        }
        if (e > 0) {
            return e - 1023;
        }
        return -1074 + (DoubleUtils.getMsb(f) - 1);
    }
}

