/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano.java6;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import net.morilib.lisp.nano.LispException;
import net.morilib.lisp.nano.Scheme;
import net.morilib.lisp.nano.java6.SchlushEngineFactory;
import net.morilib.lisp.nano.java6.SchlushScriptContext;

public class SchlushScriptEngine
extends AbstractScriptEngine
implements Invocable {
    private SchlushEngineFactory factory;
    private Scheme scheme;

    SchlushScriptEngine(SchlushEngineFactory f) {
        this.factory = f;
        this.scheme = SchlushEngineFactory.SCHEME;
    }

    @Override
    protected ScriptContext getScriptContext(Bindings nn) {
        SchlushScriptContext c = new SchlushScriptContext(this.factory.environ);
        c.setReader(new InputStreamReader(System.in));
        c.setWriter(new OutputStreamWriter(System.out));
        c.setErrorWriter(new OutputStreamWriter(System.err));
        c.setBindings(nn, 100);
        return c;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval((Reader)new StringReader(script), context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        try {
            if (context instanceof SchlushScriptContext) {
                SchlushScriptContext c = (SchlushScriptContext)context;
                return this.scheme.read(c.env, context.getReader());
            }
            throw new IllegalArgumentException();
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Object invokeMethod(Object dieser, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        throw new NoSuchMethodException();
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        try {
            return this.scheme.call(name, args);
        }
        catch (LispException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public <T> T getInterface(Class<T> klasse) {
        throw new IllegalArgumentException();
    }

    @Override
    public <T> T getInterface(Object dieser, Class<T> klasse) {
        throw new IllegalArgumentException();
    }
}

