/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.LispUtils;
import net.morilib.lisp.nano.Nil;

public final class Cons
extends Datum
implements Serializable {
    private Datum car;
    private Datum cdr;

    public Cons() {
        this.car = Nil.NIL;
        this.cdr = Nil.NIL;
    }

    public Cons(Datum car, Datum cdr) {
        if (car == null) {
            throw new NullPointerException("car is null");
        }
        if (cdr == null) {
            throw new NullPointerException("cdr is null");
        }
        this.car = car;
        this.cdr = cdr;
    }

    public Datum getCar() {
        return this.car;
    }

    void setCar(Datum car) {
        this.car = car;
    }

    public Datum getCdr() {
        return this.cdr;
    }

    void setCdr(Datum cdr) {
        this.cdr = cdr;
    }

    @Override
    public boolean isTypeList() {
        return true;
    }

    @Override
    public boolean isDottedList() {
        return !this.getDottedDatum().isNil();
    }

    @Override
    public List<Datum> getList() {
        ArrayList<Datum> res = new ArrayList<Datum>();
        Datum p = this.cdr;
        res.add(this.car);
        while (p instanceof Cons) {
            Cons p2 = (Cons)p;
            res.add(p2.car);
            p = p2.cdr;
        }
        return Collections.unmodifiableList(res);
    }

    @Override
    public Datum getDottedDatum() {
        Datum p = this.cdr;
        while (p instanceof Cons) {
            p = ((Cons)p).cdr;
        }
        return p;
    }

    @Override
    public String toString() {
        return LispUtils.toWrite(this);
    }

    @Override
    public String toDisplay() {
        return LispUtils.toDisplay(this);
    }

    @Override
    public String toWrite() {
        return LispUtils.toWrite(this);
    }
}

