/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import net.morilib.lisp.nano.ClosureClass;
import net.morilib.lisp.nano.CompiledCode;
import net.morilib.lisp.nano.ConsIterator;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.NamableDatum;
import net.morilib.lisp.nano.Procedure;

public final class Closure
extends NamableDatum
implements Procedure {
    private Datum params;
    private CompiledCode body;
    private Environment env;

    Closure(ClosureClass cl, Environment env) {
        super(null);
        if (cl == null || env == null) {
            throw new NullPointerException();
        }
        this.params = cl.getParameterList();
        this.body = cl.getCode();
        this.env = env;
    }

    Datum getParameterList() {
        return this.params;
    }

    CompiledCode getCode() {
        return this.body;
    }

    Environment getEnvironment() {
        return this.env;
    }

    public int getArity() {
        ConsIterator itr = new ConsIterator(this.params);
        int ary = 0;
        while (itr.hasNext()) {
            itr.next();
            ++ary;
        }
        return itr.getTerminal().isNil() ? ary : -1;
    }

    @Override
    public boolean isTypeProcedure() {
        return true;
    }

    @Override
    public String toDisplay() {
        return "#<closure " + this.printName() + ">";
    }

    @Override
    public String toString() {
        return "Closure:" + this.printName();
    }
}

