/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.util.sql.ConnectionWrapper;
import jp.ossc.nimbus.util.sql.WrappedCallableStatement;
import jp.ossc.nimbus.util.sql.WrappedPreparedStatement;
import jp.ossc.nimbus.util.sql.WrappedStatement;

public class WrappedConnection
extends ConnectionWrapper {
    private static final long serialVersionUID = 2276362914025130990L;
    protected static final String DEFAULT_REQUEST_ID_KEY = "REQUEST_ID";
    protected static final String DEFAULT_JOURNAL_OPEN = "Open";
    protected static final String DEFAULT_JOURNAL_COMMIT = "Commit";
    protected static final String DEFAULT_JOURNAL_COMMIT_FAIL = "CommitFail";
    protected static final String DEFAULT_JOURNAL_ROLLBACK = "Rollback";
    protected static final String DEFAULT_JOURNAL_ROLLBACK_FAIL = "RollbackFail";
    protected static final Class DEFAULT_STATEMENT_CLASS = WrappedStatement.class;
    protected static final Class DEFAULT_PREPARED_STATEMENT_CLASS = WrappedPreparedStatement.class;
    protected static final Class DEFAULT_CALLABLE_STATEMENT_CLASS = WrappedCallableStatement.class;
    protected Journal journal;
    protected Context threadContext;
    protected String requestIDKey = "REQUEST_ID";
    protected Sequence sequence;
    protected boolean isStartJournal;
    protected String journalKeyOpen = "Open";
    protected EditorFinder editorFinderForOpen;
    protected String journalKeyCommit = "Commit";
    protected String journalKeyCommitFail = "CommitFail";
    protected String journalKeyRollback = "Rollback";
    protected String journalKeyRollbackFail = "RollbackFail";

    public WrappedConnection(Connection con) {
        super(con);
        this.setStatementWrapperClass(DEFAULT_STATEMENT_CLASS);
        this.setPreparedStatementWrapperClass(DEFAULT_PREPARED_STATEMENT_CLASS);
        this.setCallableStatementWrapperClass(DEFAULT_CALLABLE_STATEMENT_CLASS);
    }

    public void setJournal(Journal jnl) {
        this.journal = jnl;
    }

    public void setThreadContext(Context ctx) {
        this.threadContext = ctx;
    }

    public void setRequestIDKey(String key) {
        this.requestIDKey = key;
    }

    public void setSequence(Sequence seq) {
        this.sequence = seq;
    }

    public void setJournalKeyOpen(String key) {
        this.journalKeyOpen = key;
    }

    public void setEditorFinderForOpen(EditorFinder finder) {
        this.editorFinderForOpen = finder;
    }

    public void setJournalKeyCommit(String key) {
        this.journalKeyCommit = key;
    }

    public void setJournalKeyCommitFail(String key) {
        this.journalKeyCommitFail = key;
    }

    public void setJournalKeyRollback(String key) {
        this.journalKeyRollback = key;
    }

    public void setJournalKeyRollbackFail(String key) {
        this.journalKeyRollbackFail = key;
    }

    public void setStartJournal(boolean isStart) {
        this.isStartJournal = isStart;
        if (this.isStartJournal && this.journal != null) {
            String requestId = null;
            if (this.threadContext != null && this.requestIDKey != null) {
                requestId = (String)this.threadContext.get(this.requestIDKey);
            }
            if (requestId == null && this.sequence != null) {
                requestId = this.sequence.increment();
                if (this.threadContext != null && this.requestIDKey != null) {
                    this.threadContext.put(this.requestIDKey, requestId);
                }
            }
            this.journal.startJournal(this.journalKeyOpen, this.editorFinderForOpen);
            if (requestId != null) {
                this.journal.setRequestId(requestId);
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            super.commit();
            if (this.journal != null) {
                this.journal.addInfo(this.journalKeyCommit, new Date());
            }
        }
        catch (SQLException e) {
            if (this.journal != null) {
                this.journal.addInfo(this.journalKeyCommitFail, e);
            }
            throw e;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            super.rollback();
            if (this.journal != null) {
                this.journal.addInfo(this.journalKeyRollback, new Date());
            }
        }
        catch (SQLException e) {
            if (this.journal != null) {
                this.journal.addInfo(this.journalKeyRollbackFail, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            super.close();
        }
        finally {
            if (this.isStartJournal && this.journal != null) {
                this.journal.endJournal();
            }
        }
    }
}

