/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer.mail;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.IllegalWriteException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.keepalive.KeepAliveCheckerSelector;
import jp.ossc.nimbus.service.keepalive.smtp.SmtpKeepAliveChecker;
import jp.ossc.nimbus.service.writer.MessageWriteException;
import jp.ossc.nimbus.service.writer.MessageWriter;
import jp.ossc.nimbus.service.writer.WritableElement;
import jp.ossc.nimbus.service.writer.WritableRecord;
import jp.ossc.nimbus.service.writer.mail.MailWriterServiceMBean;
import jp.ossc.nimbus.util.CsvArrayList;

public class MailWriterService
extends ServiceBase
implements MessageWriter,
MailWriterServiceMBean {
    private static final long serialVersionUID = 8479884337523286206L;
    private static final String SESSION_PROPERTY_NAME_HOST = "mail.smtp.host";
    private static final String SESSION_PROPERTY_NAME_PORT = "mail.smtp.port";
    private static final String SESSION_PROPERTY_NAME_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    private static final String SESSION_PROPERTY_VALUE_TRANSPORT_PROTOCOL = "smtp";
    private static final String SESSION_PROPERTY_NAME_FROM = "mail.smtp.from";
    private Properties sessionProperties;
    private ServiceName authenticatorServiceName;
    private Authenticator authenticator;
    private Properties headers;
    private String[] headerKeys;
    private String envelopeFromAddressKey;
    private String envelopeFromAddress;
    private boolean isEnvelopeFromAddressValidate;
    private String fromAddressKey;
    private String fromAddress;
    private String fromPersonalKey;
    private String fromPersonal;
    private String fromPersonalEncodingKey;
    private String fromPersonalEncoding;
    private boolean isFromAddressValidate;
    private String senderAddressKey;
    private String senderAddress;
    private String senderPersonalKey;
    private String senderPersonal;
    private String senderPersonalEncodingKey;
    private String senderPersonalEncoding;
    private boolean isSenderAddressValidate;
    private String toAddressKey;
    private String[] toAddress;
    private String toPersonalKey;
    private String[] toPersonals;
    private String toPersonalEncodingKey;
    private String[] toPersonalEncodings;
    private String toPersonalEncoding;
    private boolean isToAddressValidate;
    private String ccAddressKey;
    private String[] ccAddress;
    private String ccPersonalKey;
    private String[] ccPersonals;
    private String ccPersonalEncodingKey;
    private String[] ccPersonalEncodings;
    private String ccPersonalEncoding;
    private boolean isCcAddressValidate;
    private String bccAddressKey;
    private String[] bccAddress;
    private String bccPersonalKey;
    private String[] bccPersonals;
    private String bccPersonalEncodingKey;
    private String[] bccPersonalEncodings;
    private String bccPersonalEncoding;
    private boolean isBccAddressValidate;
    private String replyToAddressKey;
    private String[] replyToAddress;
    private String replyToPersonalKey;
    private String[] replyToPersonals;
    private String replyToPersonalEncodingKey;
    private String[] replyToPersonalEncodings;
    private String replyToPersonalEncoding;
    private boolean isReplyToAddressValidate;
    private String subjectKey;
    private String subject;
    private String subjectEncodingKey;
    private String subjectEncoding;
    private String contentIDKey;
    private String contentID;
    private String contentLanguageKey;
    private String[] contentLanguage;
    private String contentMD5Key;
    private String contentMD5;
    private String descriptionKey;
    private String description;
    private String descriptionEncodingKey;
    private String descriptionEncoding;
    private String dispositionKey;
    private String disposition;
    private String filePartKey;
    private String fileCharset = MimeUtility.getDefaultJavaCharset();
    private String fileCharsetKey;
    private String fileLanguage;
    private String fileLanguageKey;
    private String bodyText;
    private String bodyIndexKey;
    private int bodyIndex = -1;
    private String bodyEncoding;
    private String smtpHostName;
    private int smtpPort = 25;
    private ServiceName smtpKeepAliveCheckerSelectorServiceName;
    private KeepAliveCheckerSelector smtpKeepAliveCheckerSelector;
    private int retryCount = -1;
    private long retryInterval = -1L;
    private ServiceName jndiFinderServiceName;
    private JndiFinder jndiFinder;
    private String mailSessionJndiName = "java:/Mail";

    @Override
    public void setSessionProperties(Properties prop) {
        this.sessionProperties = prop;
    }

    @Override
    public Properties getSessionProperties() {
        return this.sessionProperties;
    }

    @Override
    public void setAuthenticatorServiceName(ServiceName name) {
        this.authenticatorServiceName = name;
    }

    @Override
    public ServiceName getAuthenticatorServiceName() {
        return this.authenticatorServiceName;
    }

    @Override
    public void setHeaders(Properties prop) {
        this.headers = prop;
    }

    @Override
    public Properties getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaderKeys(String[] keys) {
        this.headerKeys = keys;
    }

    @Override
    public String[] getHeaderKeys() {
        return this.headerKeys;
    }

    @Override
    public void setEnvelopeFromAddressKey(String key) {
        this.envelopeFromAddressKey = key;
    }

    @Override
    public String getEnvelopeFromAddressKey() {
        return this.envelopeFromAddressKey;
    }

    @Override
    public void setEnvelopeFromAddress(String address) {
        this.envelopeFromAddress = address;
    }

    @Override
    public String getEnvelopeFromAddress() {
        return this.envelopeFromAddress;
    }

    @Override
    public void setEnvelopeFromAddressValidate(boolean isValidate) {
        this.isEnvelopeFromAddressValidate = isValidate;
    }

    @Override
    public boolean isEnvelopeFromAddressValidate() {
        return this.isEnvelopeFromAddressValidate;
    }

    @Override
    public void setFromAddressKey(String key) {
        this.fromAddressKey = key;
    }

    @Override
    public String getFromAddressKey() {
        return this.fromAddressKey;
    }

    @Override
    public void setFromAddress(String address) {
        this.fromAddress = address;
    }

    @Override
    public String getFromAddress() {
        return this.fromAddress;
    }

    @Override
    public void setFromPersonalKey(String key) {
        this.fromPersonalKey = key;
    }

    @Override
    public String getFromPersonalKey() {
        return this.fromPersonalKey;
    }

    @Override
    public void setFromPersonal(String personal) {
        this.fromPersonal = personal;
    }

    @Override
    public String getFromPersonal() {
        return this.fromPersonal;
    }

    @Override
    public void setFromPersonalEncodingKey(String key) {
        this.fromPersonalEncodingKey = key;
    }

    @Override
    public String getFromPersonalEncodingKey() {
        return this.fromPersonalEncodingKey;
    }

    @Override
    public void setFromPersonalEncoding(String encoding) {
        this.fromPersonalEncoding = encoding;
    }

    @Override
    public String getFromPersonalEncoding() {
        return this.fromPersonalEncoding;
    }

    @Override
    public void setFromAddressValidate(boolean isValidate) {
        this.isFromAddressValidate = isValidate;
    }

    @Override
    public boolean isFromAddressValidate() {
        return this.isFromAddressValidate;
    }

    @Override
    public void setSenderAddressKey(String key) {
        this.senderAddressKey = key;
    }

    @Override
    public String getSenderAddressKey() {
        return this.senderAddressKey;
    }

    @Override
    public void setSenderAddress(String address) {
        this.senderAddress = address;
    }

    @Override
    public String getSenderAddress() {
        return this.senderAddress;
    }

    @Override
    public void setSenderPersonalKey(String key) {
        this.senderPersonalKey = key;
    }

    @Override
    public String getSenderPersonalKey() {
        return this.senderPersonalKey;
    }

    @Override
    public void setSenderPersonal(String personal) {
        this.senderPersonal = personal;
    }

    @Override
    public String getSenderPersonal() {
        return this.senderPersonal;
    }

    @Override
    public void setSenderPersonalEncodingKey(String key) {
        this.senderPersonalEncodingKey = key;
    }

    @Override
    public String getSenderPersonalEncodingKey() {
        return this.senderPersonalEncodingKey;
    }

    @Override
    public void setSenderPersonalEncoding(String encoding) {
        this.senderPersonalEncoding = encoding;
    }

    @Override
    public String getSenderPersonalEncoding() {
        return this.senderPersonalEncoding;
    }

    @Override
    public void setSenderAddressValidate(boolean isValidate) {
        this.isSenderAddressValidate = isValidate;
    }

    @Override
    public boolean isSenderAddressValidate() {
        return this.isSenderAddressValidate;
    }

    @Override
    public void setToAddressKey(String key) {
        this.toAddressKey = key;
    }

    @Override
    public String getToAddressKey() {
        return this.toAddressKey;
    }

    @Override
    public void setToAddress(String[] address) {
        this.toAddress = address;
    }

    @Override
    public String[] getToAddress() {
        return this.toAddress;
    }

    @Override
    public void setToPersonalKey(String key) {
        this.toPersonalKey = key;
    }

    @Override
    public String getToPersonalKey() {
        return this.toPersonalKey;
    }

    @Override
    public void setToPersonals(String[] personal) {
        this.toPersonals = personal;
    }

    @Override
    public String[] getToPersonals() {
        return this.toPersonals;
    }

    @Override
    public void setToPersonalEncodingKey(String key) {
        this.toPersonalEncodingKey = key;
    }

    @Override
    public String getToPersonalEncodingKey() {
        return this.toPersonalEncodingKey;
    }

    @Override
    public void setToPersonalEncodings(String[] encoding) {
        this.toPersonalEncodings = encoding;
    }

    @Override
    public String[] getToPersonalEncodings() {
        return this.toPersonalEncodings;
    }

    @Override
    public void setToPersonalEncoding(String encoding) {
        this.toPersonalEncoding = encoding;
    }

    @Override
    public String getToPersonalEncoding() {
        return this.toPersonalEncoding;
    }

    @Override
    public void setToAddressValidate(boolean isValidate) {
        this.isToAddressValidate = isValidate;
    }

    @Override
    public boolean isToAddressValidate() {
        return this.isToAddressValidate;
    }

    @Override
    public void setCcAddressKey(String key) {
        this.ccAddressKey = key;
    }

    @Override
    public String getCcAddressKey() {
        return this.ccAddressKey;
    }

    @Override
    public void setCcAddress(String[] address) {
        this.ccAddress = address;
    }

    @Override
    public String[] getCcAddress() {
        return this.ccAddress;
    }

    @Override
    public void setCcPersonalKey(String key) {
        this.ccPersonalKey = key;
    }

    @Override
    public String getCcPersonalKey() {
        return this.ccPersonalKey;
    }

    @Override
    public void setCcPersonals(String[] personal) {
        this.ccPersonals = personal;
    }

    @Override
    public String[] getCcPersonals() {
        return this.ccPersonals;
    }

    @Override
    public void setCcPersonalEncodingKey(String key) {
        this.ccPersonalEncodingKey = key;
    }

    @Override
    public String getCcPersonalEncodingKey() {
        return this.ccPersonalEncodingKey;
    }

    @Override
    public void setCcPersonalEncodings(String[] encoding) {
        this.ccPersonalEncodings = encoding;
    }

    @Override
    public String[] getCcPersonalEncodings() {
        return this.ccPersonalEncodings;
    }

    @Override
    public void setCcPersonalEncoding(String encoding) {
        this.ccPersonalEncoding = encoding;
    }

    @Override
    public String getCcPersonalEncoding() {
        return this.ccPersonalEncoding;
    }

    @Override
    public void setCcAddressValidate(boolean isValidate) {
        this.isCcAddressValidate = isValidate;
    }

    @Override
    public boolean isCcAddressValidate() {
        return this.isCcAddressValidate;
    }

    @Override
    public void setBccAddressKey(String key) {
        this.bccAddressKey = key;
    }

    @Override
    public String getBccAddressKey() {
        return this.bccAddressKey;
    }

    @Override
    public void setBccAddress(String[] address) {
        this.bccAddress = address;
    }

    @Override
    public String[] getBccAddress() {
        return this.bccAddress;
    }

    @Override
    public void setBccPersonalKey(String key) {
        this.bccPersonalKey = key;
    }

    @Override
    public String getBccPersonalKey() {
        return this.bccPersonalKey;
    }

    @Override
    public void setBccPersonals(String[] personal) {
        this.bccPersonals = personal;
    }

    @Override
    public String[] getBccPersonals() {
        return this.bccPersonals;
    }

    @Override
    public void setBccPersonalEncodingKey(String key) {
        this.bccPersonalEncodingKey = key;
    }

    @Override
    public String getBccPersonalEncodingKey() {
        return this.bccPersonalEncodingKey;
    }

    @Override
    public void setBccPersonalEncodings(String[] encoding) {
        this.bccPersonalEncodings = encoding;
    }

    @Override
    public String[] getBccPersonalEncodings() {
        return this.bccPersonalEncodings;
    }

    @Override
    public void setBccPersonalEncoding(String encoding) {
        this.bccPersonalEncoding = encoding;
    }

    @Override
    public String getBccPersonalEncoding() {
        return this.bccPersonalEncoding;
    }

    @Override
    public void setBccAddressValidate(boolean isValidate) {
        this.isBccAddressValidate = isValidate;
    }

    @Override
    public boolean isBccAddressValidate() {
        return this.isBccAddressValidate;
    }

    @Override
    public void setReplyToAddressKey(String key) {
        this.replyToAddressKey = key;
    }

    @Override
    public String getReplyToAddressKey() {
        return this.replyToAddressKey;
    }

    @Override
    public void setReplyToAddress(String[] address) {
        this.replyToAddress = address;
    }

    @Override
    public String[] getReplyToAddress() {
        return this.replyToAddress;
    }

    @Override
    public void setReplyToPersonalKey(String key) {
        this.replyToPersonalKey = key;
    }

    @Override
    public String getReplyToPersonalKey() {
        return this.replyToPersonalKey;
    }

    @Override
    public void setReplyToPersonals(String[] personal) {
        this.replyToPersonals = personal;
    }

    @Override
    public String[] getReplyToPersonals() {
        return this.replyToPersonals;
    }

    @Override
    public void setReplyToPersonalEncodingKey(String key) {
        this.replyToPersonalEncodingKey = key;
    }

    @Override
    public String getReplyToPersonalEncodingKey() {
        return this.replyToPersonalEncodingKey;
    }

    @Override
    public void setReplyToPersonalEncodings(String[] encoding) {
        this.replyToPersonalEncodings = encoding;
    }

    @Override
    public String[] getReplyToPersonalEncodings() {
        return this.replyToPersonalEncodings;
    }

    @Override
    public void setReplyToPersonalEncoding(String encoding) {
        this.replyToPersonalEncoding = encoding;
    }

    @Override
    public String getReplyToPersonalEncoding() {
        return this.replyToPersonalEncoding;
    }

    @Override
    public void setReplyToAddressValidate(boolean isValidate) {
        this.isReplyToAddressValidate = isValidate;
    }

    @Override
    public boolean isReplyToAddressValidate() {
        return this.isReplyToAddressValidate;
    }

    @Override
    public void setSubjectKey(String key) {
        this.subjectKey = key;
    }

    @Override
    public String getSubjectKey() {
        return this.subjectKey;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setSubjectEncodingKey(String key) {
        this.subjectEncodingKey = key;
    }

    @Override
    public String getSubjectEncodingKey() {
        return this.subjectEncodingKey;
    }

    @Override
    public void setSubjectEncoding(String encoding) {
        this.subjectEncoding = encoding;
    }

    @Override
    public String getSubjectEncoding() {
        return this.subjectEncoding;
    }

    @Override
    public void setContentIDKey(String key) {
        this.contentIDKey = key;
    }

    @Override
    public String getContentIDKey() {
        return this.contentIDKey;
    }

    @Override
    public void setContentID(String id) {
        this.contentID = id;
    }

    @Override
    public String getContentID() {
        return this.contentID;
    }

    @Override
    public void setContentLanguageKey(String key) {
        this.contentLanguageKey = key;
    }

    @Override
    public String getContentLanguageKey() {
        return this.contentLanguageKey;
    }

    @Override
    public void setContentLanguage(String[] lang) {
        this.contentLanguage = lang;
    }

    @Override
    public String[] getContentLanguage() {
        return this.contentLanguage;
    }

    @Override
    public void setContentMD5Key(String key) {
        this.contentMD5Key = key;
    }

    @Override
    public String getContentMD5Key() {
        return this.contentMD5Key;
    }

    @Override
    public void setContentMD5(String val) {
        this.contentMD5 = val;
    }

    @Override
    public String getContentMD5() {
        return this.contentMD5;
    }

    @Override
    public void setDescriptionKey(String key) {
        this.descriptionKey = key;
    }

    @Override
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    @Override
    public void setDescription(String val) {
        this.description = val;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescriptionEncodingKey(String key) {
        this.descriptionEncodingKey = key;
    }

    @Override
    public String getDescriptionEncodingKey() {
        return this.descriptionEncodingKey;
    }

    @Override
    public void setDescriptionEncoding(String encoding) {
        this.descriptionEncoding = encoding;
    }

    @Override
    public String getDescriptionEncoding() {
        return this.descriptionEncoding;
    }

    @Override
    public void setDispositionKey(String key) {
        this.dispositionKey = key;
    }

    @Override
    public String getDispositionKey() {
        return this.dispositionKey;
    }

    @Override
    public void setDisposition(String val) {
        this.disposition = val;
    }

    @Override
    public String getDisposition() {
        return this.disposition;
    }

    @Override
    public void setFilePartKey(String key) {
        this.filePartKey = key;
    }

    @Override
    public String getFilePartKey() {
        return this.filePartKey;
    }

    @Override
    public void setFileCharsetKey(String key) {
        this.fileCharsetKey = key;
    }

    @Override
    public String getFileCharsetKey() {
        return this.fileCharsetKey;
    }

    @Override
    public void setFileCharset(String charset) {
        this.fileCharset = charset;
    }

    @Override
    public String getFileCharset() {
        return this.fileCharset;
    }

    @Override
    public void setFileLanguageKey(String key) {
        this.fileLanguageKey = key;
    }

    @Override
    public String getFileLanguageKey() {
        return this.fileLanguageKey;
    }

    @Override
    public void setFileLanguage(String lang) {
        this.fileLanguage = lang;
    }

    @Override
    public String getFileLanguage() {
        return this.fileLanguage;
    }

    @Override
    public void setBodyIndex(int index) {
        this.bodyIndex = index;
    }

    @Override
    public int getBodyIndex() {
        return this.bodyIndex;
    }

    @Override
    public void setBodyIndexKey(String key) {
        this.bodyIndexKey = key;
    }

    @Override
    public String getBodyIndexKey() {
        return this.bodyIndexKey;
    }

    @Override
    public void setBodyText(String text) {
        this.bodyText = text;
    }

    @Override
    public String getBodyText() {
        return this.bodyText;
    }

    @Override
    public void setBodyEncoding(String encoding) {
        this.bodyEncoding = encoding;
    }

    @Override
    public String getBodyEncoding() {
        return this.bodyEncoding;
    }

    @Override
    public void setSmtpHostName(String name) {
        this.smtpHostName = name;
    }

    @Override
    public String getSmtpHostName() {
        return this.smtpHostName;
    }

    @Override
    public void setSmtpPort(int port) {
        this.smtpPort = port;
    }

    @Override
    public int getSmtpPort() {
        return this.smtpPort;
    }

    @Override
    public void setRetryCount(int count) {
        this.retryCount = count;
    }

    @Override
    public int getRetryCount() {
        return this.retryCount;
    }

    @Override
    public void setRetryInterval(long millis) {
        this.retryInterval = millis;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public void setSmtpKeepAliveCheckerSelectorServiceName(ServiceName name) {
        this.smtpKeepAliveCheckerSelectorServiceName = name;
    }

    @Override
    public ServiceName getSmtpKeepAliveCheckerSelectorServiceName() {
        return this.smtpKeepAliveCheckerSelectorServiceName;
    }

    @Override
    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    @Override
    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    @Override
    public void setMailSessionJndiName(String name) {
        this.mailSessionJndiName = name;
    }

    @Override
    public String getMailSessionJndiName() {
        return this.mailSessionJndiName;
    }

    @Override
    public void startService() throws Exception {
        if (this.authenticatorServiceName != null) {
            this.authenticator = (Authenticator)ServiceManagerFactory.getServiceObject(this.authenticatorServiceName);
        }
        if (this.fromAddressKey == null && this.fromAddress == null) {
            throw new IllegalArgumentException("It is necessary to set any of FromAddressKey and FromAddress.");
        }
        if (this.toAddress != null && this.toAddress.length != 0) {
            if (this.toPersonals != null && this.toPersonals.length != this.toAddress.length) {
                throw new IllegalArgumentException("It is necessary to set toAddress and toPersonals to the same length.");
            }
            if (this.toPersonalEncodings != null && this.toPersonalEncodings.length != this.toAddress.length) {
                throw new IllegalArgumentException("It is necessary to set toAddress and toPersonalEncodings to the same length.");
            }
        }
        if (this.ccAddress != null && this.ccAddress.length != 0) {
            if (this.ccPersonals != null && this.ccPersonals.length != this.ccAddress.length) {
                throw new IllegalArgumentException("It is necessary to set ccAddress and ccPersonals to the same length.");
            }
            if (this.ccPersonalEncodings != null && this.ccPersonalEncodings.length != this.ccAddress.length) {
                throw new IllegalArgumentException("It is necessary to set ccAddress and ccPersonalEncodings to the same length.");
            }
        }
        if (this.bccAddress != null && this.bccAddress.length != 0) {
            if (this.bccPersonals != null && this.bccPersonals.length != this.bccAddress.length) {
                throw new IllegalArgumentException("It is necessary to set bccAddress and bccPersonals to the same length.");
            }
            if (this.bccPersonalEncodings != null && this.bccPersonalEncodings.length != this.bccAddress.length) {
                throw new IllegalArgumentException("It is necessary to set bccAddress and bccPersonalEncodings to the same length.");
            }
        }
        if (this.smtpKeepAliveCheckerSelectorServiceName != null) {
            this.smtpKeepAliveCheckerSelector = (KeepAliveCheckerSelector)ServiceManagerFactory.getServiceObject(this.smtpKeepAliveCheckerSelectorServiceName);
        }
        if (this.smtpHostName == null && this.smtpKeepAliveCheckerSelector == null) {
            throw new IllegalArgumentException("It is necessary to set any of SmtpHostName and SmtpKeepAliveCheckerSelectorServiceName.");
        }
        if (this.jndiFinderServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        }
    }

    @Override
    public void write(WritableRecord rec) throws MessageWriteException {
        int maxCount = this.retryCount > 0 ? this.retryCount : 0;
        Throwable exception = null;
        for (int count = 0; count <= maxCount; ++count) {
            try {
                this.sendMail(rec);
                return;
            }
            catch (NamingException e) {
                exception = e;
            }
            catch (IllegalWriteException e) {
                exception = e;
            }
            catch (MessagingException e) {
                exception = e;
            }
            if (this.retryInterval <= 0L) continue;
            try {
                Thread.sleep(this.retryInterval);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        throw new MessageWriteException(exception);
    }

    public void sendMail(WritableRecord rec) throws MessageWriteException, IllegalWriteException, MessagingException, NamingException {
        String enc;
        String[] vals;
        List elements;
        Map elementMap = rec.getElementMap();
        InternetAddress fromInternetAddress = this.createAddress(elementMap, this.fromAddress, this.fromPersonal, this.fromPersonalEncoding, this.fromAddressKey, this.fromPersonalKey, this.fromPersonalEncodingKey, this.isFromAddressValidate);
        if (fromInternetAddress == null) {
            throw new MessageWriteException("The From address is null.");
        }
        InternetAddress senderInternetAddress = this.createAddress(elementMap, this.senderAddress, this.senderPersonal, this.senderPersonalEncoding, this.senderAddressKey, this.senderPersonalKey, this.senderPersonalEncodingKey, this.isSenderAddressValidate);
        InternetAddress[] toInternetAddress = this.createAddressArray(elementMap, this.toAddress, this.toPersonals, this.toPersonalEncodings, this.toPersonalEncoding, this.toAddressKey, this.toPersonalKey, this.toPersonalEncodingKey, this.isToAddressValidate);
        InternetAddress[] ccInternetAddress = this.createAddressArray(elementMap, this.ccAddress, this.ccPersonals, this.ccPersonalEncodings, this.ccPersonalEncoding, this.ccAddressKey, this.ccPersonalKey, this.ccPersonalEncodingKey, this.isCcAddressValidate);
        InternetAddress[] bccInternetAddress = this.createAddressArray(elementMap, this.bccAddress, this.bccPersonals, this.bccPersonalEncodings, this.bccPersonalEncoding, this.bccAddressKey, this.bccPersonalKey, this.bccPersonalEncodingKey, this.isBccAddressValidate);
        if (!(toInternetAddress != null && toInternetAddress.length != 0 || ccInternetAddress != null && ccInternetAddress.length != 0 || bccInternetAddress != null && bccInternetAddress.length != 0)) {
            throw new MessageWriteException("The destination address is null.");
        }
        InternetAddress[] replyToInternetAddress = this.createAddressArray(elementMap, this.replyToAddress, this.replyToPersonals, this.replyToPersonalEncodings, this.replyToPersonalEncoding, this.replyToAddressKey, this.replyToPersonalKey, this.replyToPersonalEncodingKey, this.isReplyToAddressValidate);
        String body = this.bodyText;
        int bIndex = this.getIntValue(elementMap, this.bodyIndex, this.bodyIndexKey);
        if (bIndex >= 0 && (elements = rec.getElements()).size() > bIndex) {
            StringBuffer buf = new StringBuffer();
            int imax = elements.size();
            for (int i = bIndex; i < imax; ++i) {
                WritableElement element = (WritableElement)elements.get(i);
                if (element == null) continue;
                buf.append(element);
            }
            body = buf.toString();
        }
        Session session = null;
        if (this.jndiFinder != null) {
            session = (Session)this.jndiFinder.lookup(this.mailSessionJndiName);
        } else {
            Properties props = new Properties(System.getProperties());
            if (this.smtpKeepAliveCheckerSelector != null) {
                SmtpKeepAliveChecker checker = (SmtpKeepAliveChecker)this.smtpKeepAliveCheckerSelector.selectChecker();
                if (checker == null) {
                    throw new MessageWriteException("All smtp server is dead.");
                }
                props.setProperty(SESSION_PROPERTY_NAME_HOST, checker.getHostIp());
                props.setProperty(SESSION_PROPERTY_NAME_PORT, String.valueOf(checker.getHostPort()));
            } else {
                props.setProperty(SESSION_PROPERTY_NAME_HOST, this.smtpHostName);
                props.setProperty(SESSION_PROPERTY_NAME_PORT, String.valueOf(this.smtpPort));
            }
            props.setProperty(SESSION_PROPERTY_NAME_TRANSPORT_PROTOCOL, SESSION_PROPERTY_VALUE_TRANSPORT_PROTOCOL);
            InternetAddress envelopeFromInternetAddress = this.createAddress(elementMap, this.envelopeFromAddress, null, null, this.envelopeFromAddressKey, null, null, this.isEnvelopeFromAddressValidate);
            if (envelopeFromInternetAddress != null) {
                props.setProperty(SESSION_PROPERTY_NAME_FROM, envelopeFromInternetAddress.getAddress());
            }
            if (this.sessionProperties != null) {
                props.putAll((Map<?, ?>)this.sessionProperties);
            }
            session = Session.getInstance((Properties)props, (Authenticator)this.authenticator);
        }
        MimeMessage message = new MimeMessage(session);
        String val = this.getStringValue(elementMap, this.contentID, this.contentIDKey);
        if (val != null) {
            message.setContentID(val);
        }
        if ((vals = this.getStringArrayValue(elementMap, this.contentLanguage, this.contentLanguageKey)) != null) {
            message.setContentLanguage(vals);
        }
        if ((val = this.getStringValue(elementMap, this.contentMD5, this.contentMD5Key)) != null) {
            message.setContentMD5(val);
        }
        if ((val = this.getStringValue(elementMap, this.description, this.descriptionKey)) != null) {
            String enc2 = this.getStringValue(elementMap, this.descriptionEncoding, this.descriptionEncodingKey);
            if (enc2 == null) {
                message.setDescription(val);
            } else {
                message.setDescription(val, enc2);
            }
        }
        if ((val = this.getStringValue(elementMap, this.disposition, this.dispositionKey)) != null) {
            message.setDisposition(val);
        }
        message.setFrom((Address)fromInternetAddress);
        if (senderInternetAddress != null) {
            message.setSender((Address)senderInternetAddress);
        }
        if (toInternetAddress != null) {
            for (int i = 0; i < toInternetAddress.length; ++i) {
                message.addRecipient(Message.RecipientType.TO, (Address)toInternetAddress[i]);
            }
        }
        if (ccInternetAddress != null) {
            for (int i = 0; i < ccInternetAddress.length; ++i) {
                message.addRecipient(Message.RecipientType.CC, (Address)ccInternetAddress[i]);
            }
        }
        if (bccInternetAddress != null) {
            for (int i = 0; i < bccInternetAddress.length; ++i) {
                message.addRecipient(Message.RecipientType.BCC, (Address)bccInternetAddress[i]);
            }
        }
        if (replyToInternetAddress != null) {
            message.setReplyTo((Address[])replyToInternetAddress);
        }
        if ((enc = this.getStringValue(elementMap, this.subjectEncoding, this.subjectEncodingKey)) != null) {
            message.setSubject(this.getStringValue(elementMap, this.subject, this.subjectKey), enc);
        } else {
            message.setSubject(this.getStringValue(elementMap, this.subject, this.subjectKey));
        }
        File[] files = null;
        if (this.filePartKey != null) {
            files = this.getFileArrayValue(elementMap, this.filePartKey);
        }
        if (files != null && files.length != 0) {
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            if (this.bodyEncoding == null) {
                mimeBodyPart.setText(body);
            } else {
                mimeBodyPart.setText(body, this.bodyEncoding);
            }
            mp.addBodyPart((BodyPart)mimeBodyPart);
            for (int i = 0; i < files.length; ++i) {
                MimeBodyPart filePart = new MimeBodyPart();
                filePart.setDataHandler(new DataHandler((DataSource)new FileDataSource(files[i])));
                this.setFileName((Part)filePart, files[i].getName(), this.getStringValue(elementMap, this.fileCharset, this.fileCharsetKey), this.getStringValue(elementMap, this.fileLanguage, this.fileLanguageKey));
                mp.addBodyPart((BodyPart)filePart);
            }
            message.setContent((Multipart)mp);
        } else if (this.bodyEncoding == null) {
            message.setText(body);
        } else {
            message.setText(body, this.bodyEncoding);
        }
        if (this.headers != null) {
            for (String string : this.headers.keySet()) {
                message.setHeader(string, this.headers.getProperty(string));
            }
        }
        if (this.headerKeys != null) {
            for (int i = 0; i < this.headerKeys.length; ++i) {
                String string = this.getStringValue(elementMap, null, this.headerKeys[i]);
                if (string == null) continue;
                message.setHeader(this.headerKeys[i], string);
            }
        }
        message.setSentDate(new Date());
        message.saveChanges();
        Transport.send((Message)message);
    }

    private void setFileName(Part part, String filename, String charset, String lang) throws MessagingException {
        ContentDisposition disposition;
        String[] strings = part.getHeader("Content-Disposition");
        if (strings == null || strings.length < 1) {
            disposition = new ContentDisposition("attachment");
        } else {
            disposition = new ContentDisposition(strings[0]);
            disposition.getParameterList().remove("filename");
        }
        part.setHeader("Content-Disposition", disposition.toString() + this.encodeParameter("filename", filename, charset, lang));
        strings = part.getHeader("Content-Type");
        ContentType cType = strings == null || strings.length < 1 ? new ContentType(part.getDataHandler().getContentType()) : new ContentType(strings[0]);
        try {
            int i;
            String mimeString = MimeUtility.encodeWord((String)filename, (String)charset, (String)"B");
            StringBuffer sb = new StringBuffer();
            while ((i = mimeString.indexOf(13)) != -1) {
                sb.append(mimeString.substring(0, i));
                mimeString = mimeString.substring(i + 2);
            }
            sb.append(mimeString);
            cType.setParameter("name", new String(sb));
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("Encoding error", (Exception)e);
        }
        part.setHeader("Content-Type", cType.toString());
    }

    private String encodeParameter(String name, String value, String encoding, String lang) {
        StringBuffer result = new StringBuffer();
        StringBuffer encodedPart = new StringBuffer();
        boolean needWriteCES = !this.isAllAscii(value);
        boolean CESWasWritten = false;
        boolean needFolding = false;
        int sequenceNo = 0;
        while (value.length() > 0) {
            boolean encoded;
            int lastIndex;
            boolean isAscii = value.charAt(0) < '\u0080';
            for (lastIndex = 1; lastIndex < value.length() && !(value.charAt(lastIndex) < '\u0080' ? !isAscii : isAscii); ++lastIndex) {
            }
            if (lastIndex != value.length()) {
                needFolding = true;
            }
            block4: while (true) {
                byte[] bytes;
                encodedPart.delete(0, encodedPart.length());
                String target = value.substring(0, lastIndex);
                try {
                    bytes = isAscii ? target.getBytes("us-ascii") : target.getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    bytes = target.getBytes();
                    encoding = MimeUtility.mimeCharset((String)MimeUtility.getDefaultJavaCharset());
                }
                encoded = false;
                int column = name.length() + 7;
                for (int i = 0; i < bytes.length; ++i) {
                    if (bytes[i] > 32 && bytes[i] < 122 && "()<>@,;:\\\"\t []/?=".indexOf((char)bytes[i]) < 0) {
                        encodedPart.append((char)bytes[i]);
                        ++column;
                    } else {
                        encoded = true;
                        encodedPart.append('%');
                        String hex = Integer.toString(bytes[i] & 0xFF, 16);
                        if (hex.length() == 1) {
                            encodedPart.append('0');
                        }
                        encodedPart.append(hex);
                        column += 3;
                    }
                    if (column <= 76) continue;
                    needFolding = true;
                    lastIndex /= 2;
                    continue block4;
                }
                break;
            }
            result.append(";\r\n ").append(name);
            if (needFolding) {
                result.append('*').append(sequenceNo);
                ++sequenceNo;
            }
            if (!CESWasWritten && needWriteCES) {
                result.append("*=");
                CESWasWritten = true;
                result.append(encoding).append('\'');
                if (lang != null) {
                    result.append(lang);
                }
                result.append('\'');
            } else if (encoded) {
                result.append("*=");
            } else {
                result.append('=');
            }
            result.append(new String(encodedPart));
            value = value.substring(lastIndex);
        }
        return result.toString();
    }

    private boolean isAllAscii(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private String[] toStringArray(Object obj) {
        if (obj == null) {
            return null;
        }
        String[] result = null;
        if (obj instanceof String[]) {
            result = (String[])obj;
        } else if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            if (col.size() != 0) {
                result = new String[col.size()];
                int index = 0;
                Iterator itr = col.iterator();
                while (itr.hasNext()) {
                    result[index++] = itr.next().toString();
                }
            }
        } else {
            CsvArrayList list = new CsvArrayList();
            list.split(obj.toString());
            result = list.toStringAry();
        }
        return result;
    }

    private InternetAddress[] createAddressArray(Map elementMap, String[] defaultAddress, String[] defaultPersonals, String[] defaultPersonalEncodings, String defaultPersonalEncoding, String addressKey, String personalKey, String personalEncodingKey, boolean isAddressValidate) throws MessageWriteException {
        String[] address = this.getStringArrayValue(elementMap, defaultAddress, addressKey);
        if (address == null || address.length == 0) {
            return null;
        }
        String[] personals = null;
        String[] personalEncodings = null;
        if (address == defaultAddress) {
            personals = defaultPersonals;
            personalEncodings = defaultPersonalEncodings;
        } else {
            personals = this.getStringArrayValue(elementMap, null, personalKey);
            if (personals != null && personals.length != address.length) {
                throw new MessageWriteException("It is necessary to set address and personals to the same length.");
            }
            personalEncodings = this.getStringArrayValue(elementMap, null, personalEncodingKey);
            if (personalEncodings != null && personalEncodings.length != address.length) {
                throw new MessageWriteException("It is necessary to set address and personalEncodings to the same length.");
            }
        }
        InternetAddress[] internetAddress = new InternetAddress[address.length];
        for (int i = 0; i < address.length; ++i) {
            internetAddress[i] = this.createAddress(address[i], personals == null ? null : personals[i], personalEncodings == null ? defaultPersonalEncoding : personalEncodings[i], isAddressValidate);
        }
        return internetAddress;
    }

    private InternetAddress createAddress(Map elementMap, String defaultAddress, String defaultPersonal, String defaultPersonalEncoding, String addressKey, String personalKey, String personalEncodingKey, boolean isAddressValidate) throws MessageWriteException {
        String address = this.getStringValue(elementMap, defaultAddress, addressKey);
        if (address == null) {
            return null;
        }
        String personal = this.getStringValue(elementMap, defaultPersonal, personalKey);
        String personalEncoding = this.getStringValue(elementMap, defaultPersonalEncoding, personalEncodingKey);
        return this.createAddress(address, personal, personalEncoding, isAddressValidate);
    }

    private InternetAddress createAddress(String address, String personal, String personalEncoding, boolean isAddressValidate) throws MessageWriteException {
        InternetAddress internetAddress = null;
        try {
            internetAddress = personal != null && personalEncoding != null ? new InternetAddress(address, personal, personalEncoding) : (personal != null ? new InternetAddress(address, personal) : new InternetAddress(address));
            if (isAddressValidate) {
                internetAddress.validate();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageWriteException(e);
        }
        catch (AddressException e) {
            throw new MessageWriteException(e);
        }
        return internetAddress;
    }

    private String[] getStringArrayValue(Map elementMap, String[] defaultVal, String key) {
        String[] tmpArray;
        Object tmpVal;
        WritableElement tmpElement;
        String[] val = defaultVal;
        if (key != null && (tmpElement = (WritableElement)elementMap.get(key)) != null && (tmpVal = tmpElement.toObject()) != null && (tmpArray = this.toStringArray(tmpVal)) != null && tmpArray.length != 0) {
            val = tmpArray;
        }
        return val;
    }

    private String getStringValue(Map elementMap, String defaultVal, String key) {
        Object val = this.getValue(elementMap, defaultVal, key);
        return val == null ? null : val.toString();
    }

    private int getIntValue(Map elementMap, int defaultVal, String key) {
        Integer val = (Integer)this.getValue(elementMap, null, key);
        return val == null ? defaultVal : val;
    }

    private Object getValue(Map elementMap, Object defaultVal, String key) {
        Object tmpVal;
        WritableElement tmpElement;
        Object val = defaultVal;
        if (key != null && (tmpElement = (WritableElement)elementMap.get(key)) != null && (tmpVal = tmpElement.toObject()) != null) {
            val = tmpVal;
        }
        return val;
    }

    private File[] getFileArrayValue(Map elementMap, String key) {
        Object tmpVal;
        WritableElement tmpElement;
        File[] val = null;
        if (key != null && (tmpElement = (WritableElement)elementMap.get(key)) != null && (tmpVal = tmpElement.toObject()) != null) {
            Collection col;
            if (tmpVal instanceof File[]) {
                val = (File[])tmpVal;
            } else if (tmpVal instanceof Collection && (col = (Collection)tmpVal).size() != 0) {
                val = new File[col.size()];
                int index = 0;
                Iterator itr = col.iterator();
                while (itr.hasNext()) {
                    val[index++] = (File)itr.next();
                }
            }
        }
        return val;
    }
}

