/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer.db;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.writer.MessageWriteException;
import jp.ossc.nimbus.service.writer.WritableElement;
import jp.ossc.nimbus.service.writer.WritableRecord;
import jp.ossc.nimbus.service.writer.db.DatabaseWriterServiceMBean;

public class DatabaseWriterService
extends ServiceBase
implements DatabaseWriterServiceMBean,
Serializable {
    private static final long serialVersionUID = 3540234844213981431L;
    private static final String DBW__ = "DBW__";
    private static final String DBW__0 = "DBW__0";
    private static final String DBW__00 = "DBW__00";
    private static final String DBW__000 = "DBW__000";
    private static final String DBW__0000 = "DBW__0000";
    private static final String DBW__00001 = "DBW__00001";
    private static final String DBW__00002 = "DBW__00002";
    private Map insertSQLMap;
    private List insertSQLList;
    private Map updateSQLMap;
    private List updateSQLList;
    private Map deleteSQLMap;
    private List deleteSQLList;
    private Map selectSQLMap;
    private List selectSQLList;
    private int bufferSize;
    private List recordBuffer;
    private long bufferTimeout;
    private Timer bufferTimeoutTimer;
    private TimerTask bufferTimeoutTimerTask;
    private ServiceName connectionFactoryServiceName;
    private ConnectionFactory connectionFactory;
    private boolean isAutoCommit = true;

    @Override
    public void setInsertSQL(Map sqls) {
        this.insertSQLMap = sqls;
    }

    @Override
    public Map getInsertSQL() {
        return this.insertSQLMap;
    }

    @Override
    public void setUpdateSQL(Map sqls) {
        this.updateSQLMap = sqls;
    }

    @Override
    public Map getUpdateSQL() {
        return this.updateSQLMap;
    }

    @Override
    public void setDeleteSQL(Map sqls) {
        this.deleteSQLMap = sqls;
    }

    @Override
    public Map getDeleteSQL() {
        return this.deleteSQLMap;
    }

    @Override
    public void setSelectSQL(Map sqls) {
        this.selectSQLMap = sqls;
    }

    @Override
    public Map getSelectSQL() {
        return this.selectSQLMap;
    }

    @Override
    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferTimeout(long timeout) {
        this.bufferTimeout = timeout;
    }

    @Override
    public long getBufferTimeout() {
        return this.bufferTimeout;
    }

    @Override
    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    @Override
    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    @Override
    public void setAutoCommit(boolean isAuto) {
        this.isAutoCommit = isAuto;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public void createService() throws Exception {
        this.insertSQLList = new ArrayList();
        this.updateSQLList = new ArrayList();
        this.deleteSQLList = new ArrayList();
        this.selectSQLList = new ArrayList();
        this.recordBuffer = new ArrayList();
    }

    @Override
    public void startService() throws Exception {
        if (this.connectionFactory == null) {
            if (this.connectionFactoryServiceName == null) {
                throw new IllegalArgumentException("ConnectionFactoryServiceName is null");
            }
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.selectSQLMap != null) {
            for (String sql : this.selectSQLMap.keySet()) {
                this.selectSQLList.add(new SQLElement(sql, (String)this.selectSQLMap.get(sql)));
            }
            if (this.selectSQLList.size() != 0 && this.bufferSize > 0) {
                throw new IllegalArgumentException("When BufferSize is effective, SelectSQL cannot be specified.");
            }
        }
        if (this.insertSQLMap != null) {
            for (String sql : this.insertSQLMap.keySet()) {
                this.insertSQLList.add(new SQLElement(sql, (String)this.insertSQLMap.get(sql)));
            }
            if (this.selectSQLMap != null && this.insertSQLList.size() != this.selectSQLList.size()) {
                throw new IllegalArgumentException("InsertSQL and SelectSQL should be the same numbers.");
            }
        }
        if (this.updateSQLMap != null) {
            for (String sql : this.updateSQLMap.keySet()) {
                this.updateSQLList.add(new SQLElement(sql, (String)this.updateSQLMap.get(sql)));
            }
            if (this.selectSQLMap == null) {
                if (this.insertSQLList.size() != 0) {
                    throw new IllegalArgumentException("UpdateSQL and InsertSQL cannot be specified at the same time.");
                }
            } else if (this.updateSQLList.size() != this.selectSQLList.size()) {
                throw new IllegalArgumentException("UpdateSQL and SelectSQL should be the same numbers.");
            }
        }
        if (this.deleteSQLMap != null) {
            for (String sql : this.deleteSQLMap.keySet()) {
                this.deleteSQLList.add(new SQLElement(sql, (String)this.deleteSQLMap.get(sql)));
            }
            if (this.selectSQLMap == null) {
                if (this.updateSQLList.size() != 0) {
                    throw new IllegalArgumentException("DeleteSQL and UpdateSQL cannot be specified at the same time.");
                }
            } else {
                if (this.deleteSQLList.size() != 0 && this.updateSQLList.size() != 0) {
                    throw new IllegalArgumentException("DeleteSQL and SelectSQL cannot be specified at the same time.");
                }
                if (this.deleteSQLList.size() != this.selectSQLList.size()) {
                    throw new IllegalArgumentException("DeleteSQL and SelectSQL should be the same numbers.");
                }
            }
        }
        if (this.selectSQLList.size() == 0) {
            if (this.insertSQLList.size() == 0 && this.updateSQLList.size() == 0 && this.deleteSQLList.size() == 0) {
                throw new IllegalArgumentException("It is necessary to specify either of InsertSQL or UpdateSQL or DeleteSQL.");
            }
        } else if (this.insertSQLList.size() == 0 && this.updateSQLList.size() == 0 && this.deleteSQLList.size() == 0) {
            throw new IllegalArgumentException("It is necessary to specify SelectSQL at the same time as InsertSQL or UpdateSQL or DeleteSQL.");
        }
        if (this.bufferTimeout > 0L && this.bufferSize > 0) {
            this.bufferTimeoutTimer = new Timer(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService() throws Exception {
        if (this.bufferTimeoutTimer != null) {
            Timer timer = this.bufferTimeoutTimer;
            synchronized (timer) {
                this.bufferTimeoutTimer.cancel();
                this.bufferTimeoutTimer = null;
                this.bufferTimeoutTimerTask = null;
            }
        }
        if (this.bufferSize > 0 && this.recordBuffer.size() > 0) {
            this.writeBatch();
        }
        this.recordBuffer.clear();
        this.insertSQLList.clear();
        this.updateSQLList.clear();
        this.deleteSQLList.clear();
        this.selectSQLList.clear();
        if (this.connectionFactoryServiceName == null) {
            this.connectionFactory = null;
        }
    }

    @Override
    public void destroyService() throws Exception {
        this.insertSQLList = null;
        this.updateSQLList = null;
        this.deleteSQLList = null;
        this.selectSQLList = null;
        this.recordBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(WritableRecord rec) throws MessageWriteException {
        Object object;
        if (this.getState() != 3) {
            return;
        }
        final Logger logger = this.getLogger();
        if (this.bufferSize <= 0) {
            Connection conn = null;
            try {
                conn = this.connectionFactory.getConnection();
                this.executeSQL(conn, rec);
                if (conn.getAutoCommit() || !this.isAutoCommit) return;
                conn.commit();
                return;
            }
            catch (SQLException e) {
                try {
                    if (!conn.getAutoCommit() && this.isAutoCommit) {
                        conn.rollback();
                    }
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                logger.write(DBW__00001, e);
                throw new MessageWriteException(e);
            }
            catch (ConnectionFactoryException e) {
                logger.write(DBW__00002, e);
                throw new MessageWriteException(e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {}
                    conn = null;
                }
            }
        }
        if (this.bufferTimeoutTimer != null && this.bufferTimeoutTimerTask == null) {
            object = this.bufferTimeoutTimer;
            synchronized (object) {
                if (this.bufferTimeoutTimer != null && this.bufferTimeoutTimerTask == null) {
                    this.bufferTimeoutTimerTask = new TimerTask(){

                        @Override
                        public void run() {
                            try {
                                DatabaseWriterService.this.writeBatch();
                            }
                            catch (MessageWriteException e) {
                            }
                            catch (Throwable e) {
                                logger.write(DatabaseWriterService.DBW__00002, e);
                            }
                        }
                    };
                    this.bufferTimeoutTimer.schedule(this.bufferTimeoutTimerTask, this.bufferTimeout);
                }
            }
        }
        object = this;
        synchronized (object) {
            this.recordBuffer.add(rec);
        }
        if (this.recordBuffer.size() < this.bufferSize) return;
        this.writeBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSQL(Connection conn, WritableRecord rec) throws SQLException, MessageWriteException {
        if (this.selectSQLList.size() == 0) {
            if (this.insertSQLList.size() != 0 && this.deleteSQLList.size() != 0) {
                int maxIndex;
                SQLElement sql;
                Iterator sqls = this.deleteSQLList.iterator();
                while (sqls.hasNext()) {
                    sql = (SQLElement)((SQLElement)sqls.next()).clone();
                    try {
                        sql.open(conn);
                        int index = 0;
                        maxIndex = 1;
                        do {
                            maxIndex = this.setStatement(sql, rec, index);
                            sql.statement.executeUpdate();
                        } while (++index < maxIndex);
                    }
                    finally {
                        try {
                            sql.close();
                        }
                        catch (SQLException e) {}
                    }
                }
                sqls = this.insertSQLList.iterator();
                while (sqls.hasNext()) {
                    sql = (SQLElement)((SQLElement)sqls.next()).clone();
                    try {
                        sql.open(conn);
                        int index = 0;
                        maxIndex = 1;
                        do {
                            maxIndex = this.setStatement(sql, rec, index);
                            sql.statement.executeUpdate();
                        } while (++index < maxIndex);
                    }
                    finally {
                        try {
                            sql.close();
                        }
                        catch (SQLException e) {}
                    }
                }
            } else {
                List sqlList = null;
                if (this.insertSQLList.size() != 0) {
                    sqlList = this.insertSQLList;
                } else if (this.updateSQLList.size() != 0) {
                    sqlList = this.updateSQLList;
                } else if (this.deleteSQLList.size() != 0) {
                    sqlList = this.deleteSQLList;
                }
                Iterator sqls = sqlList.iterator();
                while (sqls.hasNext()) {
                    SQLElement sql = (SQLElement)((SQLElement)sqls.next()).clone();
                    try {
                        sql.open(conn);
                        int index = 0;
                        int maxIndex = 1;
                        do {
                            maxIndex = this.setStatement(sql, rec, index);
                            sql.statement.executeUpdate();
                        } while (++index < maxIndex);
                    }
                    finally {
                        try {
                            sql.close();
                        }
                        catch (SQLException e) {}
                    }
                }
            }
        } else {
            Iterator deleteSQLs;
            Iterator selectSQLs = this.selectSQLList.iterator();
            Iterator insertSQLs = this.insertSQLList.size() == 0 ? null : this.insertSQLList.iterator();
            Iterator updateSQLs = this.updateSQLList.size() == 0 ? null : this.updateSQLList.iterator();
            Iterator iterator = deleteSQLs = this.deleteSQLList.size() == 0 ? null : this.deleteSQLList.iterator();
            while (selectSQLs.hasNext()) {
                SQLElement selectSQL = (SQLElement)((SQLElement)selectSQLs.next()).clone();
                SQLElement insertSQL = insertSQLs == null ? null : (SQLElement)((SQLElement)insertSQLs.next()).clone();
                SQLElement updateSQL = updateSQLs == null ? null : (SQLElement)((SQLElement)updateSQLs.next()).clone();
                SQLElement deleteSQL = deleteSQLs == null ? null : (SQLElement)((SQLElement)deleteSQLs.next()).clone();
                try {
                    selectSQL.open(conn);
                    if (insertSQL != null) {
                        insertSQL.open(conn);
                    }
                    if (updateSQL != null) {
                        updateSQL.open(conn);
                    }
                    if (deleteSQL != null) {
                        deleteSQL.open(conn);
                    }
                    int index = 0;
                    int maxIndex = 1;
                    do {
                        maxIndex = this.setStatement(selectSQL, rec, index);
                        ResultSet rs = selectSQL.statement.executeQuery();
                        if (!rs.next()) {
                            throw new MessageWriteException("The result of SelectSQL is 0. : " + selectSQL);
                        }
                        int selectCount = rs.getInt(1);
                        if (selectCount == 0) {
                            if (insertSQL == null) continue;
                            maxIndex = this.setStatement(insertSQL, rec, index);
                            insertSQL.statement.executeUpdate();
                            continue;
                        }
                        if (updateSQL != null) {
                            maxIndex = this.setStatement(updateSQL, rec, index);
                            updateSQL.statement.executeUpdate();
                            continue;
                        }
                        if (deleteSQL == null) continue;
                        maxIndex = this.setStatement(deleteSQL, rec, index);
                        deleteSQL.statement.executeUpdate();
                        if (insertSQL == null) continue;
                        maxIndex = this.setStatement(insertSQL, rec, index);
                        insertSQL.statement.executeUpdate();
                    } while (++index < maxIndex);
                }
                finally {
                    selectSQL.close();
                    if (insertSQL != null) {
                        insertSQL.close();
                    }
                    if (updateSQL != null) {
                        updateSQL.close();
                    }
                    if (deleteSQL == null) continue;
                    deleteSQL.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeBatch() throws MessageWriteException {
        final Logger logger = this.getLogger();
        if (this.bufferTimeoutTimer != null && this.bufferTimeoutTimerTask != null) {
            Timer timer = this.bufferTimeoutTimer;
            synchronized (timer) {
                if (this.bufferTimeoutTimer != null && this.bufferTimeoutTimerTask != null) {
                    this.bufferTimeoutTimerTask.cancel();
                    this.bufferTimeoutTimerTask = null;
                }
            }
        }
        if (this.recordBuffer.size() == 0) {
            return;
        }
        Connection conn = null;
        try {
            conn = this.connectionFactory.getConnection();
            List sqlList = null;
            if (this.insertSQLList.size() != 0) {
                sqlList = this.insertSQLList;
            } else if (this.updateSQLList.size() != 0) {
                sqlList = this.updateSQLList;
            } else if (this.deleteSQLList.size() != 0) {
                sqlList = this.deleteSQLList;
            }
            Iterator sqls = sqlList.iterator();
            int maxSize = this.recordBuffer.size();
            if (maxSize > this.bufferSize) {
                maxSize = this.bufferSize;
            }
            int totalCount = 0;
            while (sqls.hasNext()) {
                SQLElement sql = (SQLElement)((SQLElement)sqls.next()).clone();
                try {
                    sql.open(conn);
                    int i = 0;
                    for (i = 0; i < maxSize; ++i) {
                        int index = 0;
                        int maxIndex = 1;
                        WritableRecord rec = (WritableRecord)this.recordBuffer.get(i);
                        int count = 0;
                        try {
                            do {
                                maxIndex = this.setStatement(sql, rec, index);
                                sql.statement.addBatch();
                                if (++count < this.bufferSize) continue;
                                sql.statement.executeBatch();
                                count = 0;
                            } while (++index < maxIndex);
                            continue;
                        }
                        catch (SQLException e) {
                            this.recordBuffer.remove(i);
                            throw e;
                        }
                    }
                    if (totalCount < i) {
                        totalCount = i;
                    }
                    try {
                        sql.statement.executeBatch();
                    }
                    catch (SQLException e) {
                        for (int j = 0; j < totalCount; ++j) {
                            this.recordBuffer.remove(0);
                        }
                        throw e;
                    }
                }
                finally {
                    try {
                        sql.statement.clearBatch();
                    }
                    catch (SQLException e) {}
                    try {
                        sql.close();
                    }
                    catch (SQLException e) {}
                }
            }
            for (int i = 0; i < totalCount; ++i) {
                this.recordBuffer.remove(0);
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                // empty catch block
            }
            logger.write(DBW__00001, e);
            throw new MessageWriteException(e);
        }
        catch (ConnectionFactoryException e) {
            logger.write(DBW__00002, e);
            throw new MessageWriteException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
                conn = null;
            }
        }
        if (this.recordBuffer.size() >= this.bufferSize) {
            this.writeBatch();
        }
        if (this.bufferTimeoutTimer != null && this.bufferTimeoutTimerTask == null && this.recordBuffer.size() != 0) {
            Timer timer = this.bufferTimeoutTimer;
            synchronized (timer) {
                if (this.bufferTimeoutTimer != null && this.bufferTimeoutTimerTask == null) {
                    this.bufferTimeoutTimerTask = new TimerTask(){

                        @Override
                        public void run() {
                            try {
                                DatabaseWriterService.this.writeBatch();
                            }
                            catch (MessageWriteException e) {
                            }
                            catch (Throwable e) {
                                logger.write(DatabaseWriterService.DBW__00002, e);
                            }
                        }
                    };
                    this.bufferTimeoutTimer.schedule(this.bufferTimeoutTimerTask, this.bufferTimeout);
                }
            }
        }
    }

    private int setStatement(SQLElement sql, WritableRecord rec, int index) throws SQLException {
        int maxIndex = 1;
        if (sql.keyList != null) {
            Map elementMap = rec.getElementMap();
            int max = sql.keyList.size();
            for (int i = 0; i < max; ++i) {
                WritableElement element = (WritableElement)elementMap.get(sql.keyList.get(i));
                Object val = null;
                if (element != null) {
                    val = element.toObject();
                }
                if (val != null) {
                    if (val instanceof List) {
                        List list = (List)val;
                        int size = list.size();
                        if (maxIndex < size) {
                            maxIndex = size;
                        }
                        val = index < size ? list.get(index) : null;
                    } else if (val.getClass().isArray()) {
                        int length = Array.getLength(val);
                        if (maxIndex < length) {
                            maxIndex = length;
                        }
                        val = index < length ? Array.get(val, index) : null;
                    }
                }
                sql.statement.setObject(i + 1, val);
            }
        }
        return maxIndex;
    }

    protected static class SQLElement
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 8841553454194582056L;
        PreparedStatement statement;
        List keyList;
        private String statementString;

        private SQLElement() {
        }

        public SQLElement(String stm, String keys) throws SQLException, IllegalArgumentException {
            this.statementString = stm;
            if (keys.length() == 0) {
                return;
            }
            this.keyList = new ArrayList();
            boolean isEscape = false;
            StringBuffer buf = new StringBuffer();
            int max = keys.length();
            block4: for (int i = 0; i < max; ++i) {
                char c = keys.charAt(i);
                switch (c) {
                    case '\\': {
                        if (isEscape) {
                            buf.append(c);
                            isEscape = false;
                            continue block4;
                        }
                        isEscape = true;
                        continue block4;
                    }
                    case ',': {
                        if (isEscape) {
                            buf.append(c);
                            isEscape = false;
                            continue block4;
                        }
                        this.keyList.add(buf.toString());
                        buf.setLength(0);
                        continue block4;
                    }
                    default: {
                        if (isEscape) {
                            throw new IllegalArgumentException("'\\' is escape character. : " + keys);
                        }
                        buf.append(c);
                    }
                }
            }
            if (isEscape) {
                throw new IllegalArgumentException("'\\' is escape character. : " + keys);
            }
            if (buf.length() != 0) {
                this.keyList.add(buf.toString());
                buf.setLength(0);
            }
        }

        public void open(Connection con) throws SQLException {
            this.statement = con.prepareStatement(this.statementString);
        }

        public void close() throws SQLException {
            if (this.statement != null) {
                this.statement.close();
                this.statement = null;
            }
        }

        public Object clone() {
            SQLElement element = new SQLElement();
            element.statementString = this.statementString;
            element.keyList = this.keyList;
            return element;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.statementString);
            return buf.toString();
        }
    }
}

