/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer;

import java.io.Serializable;
import jp.ossc.nimbus.service.writer.WritableElement;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.FormatConverter;
import jp.ossc.nimbus.util.converter.StringConverter;

public class SimpleElement
implements WritableElement,
Serializable {
    private static final long serialVersionUID = 8510769262946215439L;
    protected Object key;
    protected Object mValue;
    protected StringConverter stringConverter;
    protected FormatConverter formatConverter;
    protected String nullString = null;

    public SimpleElement() {
        this.key = this;
    }

    public SimpleElement(Object value) {
        this.key = this;
        this.mValue = value;
    }

    public SimpleElement(Object key, Object value) {
        this.key = key;
        this.mValue = value;
    }

    @Override
    public void setKey(Object key) {
        this.key = key;
    }

    @Override
    public Object getKey() {
        return this.key == null ? this : this.key;
    }

    @Override
    public void setValue(Object val) {
        this.mValue = val;
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    public void setNullString(String str) {
        this.nullString = str;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setStringConverter(StringConverter converter) {
        this.stringConverter = converter;
    }

    public StringConverter getStringConverter() {
        return this.stringConverter;
    }

    public void setFormatConverter(FormatConverter converter) {
        this.formatConverter = converter;
        this.formatConverter.setConvertType(1);
    }

    public FormatConverter getFormatConverter() {
        return this.formatConverter;
    }

    @Override
    public String toString() {
        if (this.formatConverter == null) {
            return this.convertString(this.mValue != null ? this.mValue.toString() : this.nullString);
        }
        String ret = (String)this.formatConverter.convert(this.mValue);
        return ret == null ? this.nullString : ret;
    }

    protected String convertString(String str) {
        String result = str;
        if (this.stringConverter != null && result != null) {
            try {
                result = this.stringConverter.convert(result);
            }
            catch (ConvertException convertException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public Object toObject() {
        return this.mValue;
    }
}

