/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.datasource;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import jp.ossc.nimbus.service.resource.datasource.AbstNimbusStatement;
import jp.ossc.nimbus.service.resource.datasource.NimbusResultSet;

public class NimbusStatement
extends AbstNimbusStatement
implements Statement {
    protected boolean mIsOpen = true;
    final String BATCH_SEPARATOR = System.getProperty("line.separator");
    protected final String PF_FOOTER = "[ms]";
    protected final String PF_KEY_HEADER = ":Performance";
    protected ArrayList mBatchArray = new ArrayList();

    public NimbusStatement(Statement st) {
        super(st);
        this.mStatement = st;
    }

    @Override
    public void cancel() throws SQLException {
        this.mStatement.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.mStatement.clearBatch();
        if (this.journalService != null) {
            this.mBatchArray.clear();
        }
    }

    @Override
    public void close() throws SQLException {
        for (int cnt = 0; cnt < this.mResultSetList.size(); ++cnt) {
            ResultSet tmp = (ResultSet)this.mResultSetList.get(cnt);
            tmp.close();
        }
        this.mResultSetList.clear();
        if (this.mIsOpen) {
            this.mStatement.close();
            this.mIsOpen = false;
        }
        if (this.journalService != null) {
            this.mBatchArray.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < this.mBatchArray.size(); ++i) {
                String sql = (String)this.mBatchArray.get(i);
                buff.append(sql);
                buff.append(this.BATCH_SEPARATOR);
            }
            this.journalService.addInfo(sqlID, (Object)buff.toString(), this.journalLevel);
            this.mBatchArray.clear();
        }
        int[] ret = null;
        startTime = System.currentTimeMillis();
        try {
            ret = this.mStatement.executeBatch();
        }
        finally {
            endTime = System.currentTimeMillis();
            if (this.performanceService != null) {
                this.performanceService.entry(this.makeBatchAllSqlKey(this.mBatchArray), endTime - startTime);
            }
            if (this.journalService != null) {
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
        }
        return ret;
    }

    protected String makeBatchAllSqlKey(ArrayList arr) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < arr.size(); ++i) {
            buff.append(arr.get(i));
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String arg0) throws SQLException {
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            int n = this.mStatement.executeUpdate(arg0);
            return n;
        }
        finally {
            endTime = System.currentTimeMillis();
            if (this.performanceService != null) {
                this.performanceService.entry(arg0, endTime - startTime);
            }
            if (this.journalService != null) {
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
        }
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
        if (this.journalService != null) {
            this.mBatchArray.add(arg0);
        }
        this.mStatement.addBatch(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String arg0) throws SQLException {
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            boolean bl = this.mStatement.execute(arg0);
            return bl;
        }
        finally {
            endTime = System.currentTimeMillis();
            if (this.performanceService != null) {
                this.performanceService.entry(arg0, endTime - startTime);
            }
            if (this.journalService != null) {
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            int n = this.mStatement.executeUpdate(arg0, arg1);
            return n;
        }
        finally {
            endTime = System.currentTimeMillis();
            if (this.performanceService != null) {
                this.performanceService.entry(arg0, endTime - startTime);
            }
            if (this.journalService != null) {
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        if (this.performanceService != null) {
            startTime = System.currentTimeMillis();
        }
        try {
            boolean bl = this.mStatement.execute(arg0, arg1);
            return bl;
        }
        finally {
            endTime = System.currentTimeMillis();
            if (this.performanceService != null) {
                this.performanceService.entry(arg0, endTime - startTime);
            }
            if (this.journalService != null) {
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            int n = this.mStatement.executeUpdate(arg0, arg1);
            return n;
        }
        finally {
            endTime = System.currentTimeMillis();
            if (this.performanceService != null) {
                this.performanceService.entry(arg0, endTime - startTime);
            }
            if (this.journalService != null) {
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            boolean bl = this.mStatement.execute(arg0, arg1);
            return bl;
        }
        finally {
            endTime = System.currentTimeMillis();
            if (this.performanceService != null) {
                this.performanceService.entry(arg0, endTime - startTime);
            }
            if (this.journalService != null) {
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            int n = this.mStatement.executeUpdate(arg0, arg1);
            return n;
        }
        finally {
            endTime = System.currentTimeMillis();
            if (this.performanceService != null) {
                this.performanceService.entry(arg0, endTime - startTime);
            }
            if (this.journalService != null) {
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            boolean bl = this.mStatement.execute(arg0, arg1);
            return bl;
        }
        finally {
            endTime = System.currentTimeMillis();
            if (this.performanceService != null) {
                this.performanceService.entry(arg0, endTime - startTime);
            }
            if (this.journalService != null) {
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String arg0) throws SQLException {
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        NimbusResultSet nret = null;
        try {
            ResultSet ret = this.mStatement.executeQuery(arg0);
            nret = new NimbusResultSet(ret);
            this.mResultSetList.add(nret);
        }
        finally {
            endTime = System.currentTimeMillis();
            if (this.performanceService != null) {
                this.performanceService.entry(arg0, endTime - startTime);
            }
            if (this.journalService != null) {
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
        }
        return nret;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.mStatement.isPoolable();
    }

    @Override
    public void setPoolable(boolean isPoolable) throws SQLException {
        this.mStatement.setPoolable(isPoolable);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.mStatement.isClosed();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.mStatement.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.mStatement.unwrap(iface);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.mStatement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.mStatement.isCloseOnCompletion();
    }
}

