/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.DistributedQueueSelector;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.queue.SimpleDistributedQueueSelectorServiceMBean;

public class SimpleDistributedQueueSelectorService
extends ServiceBase
implements DistributedQueueSelector,
SimpleDistributedQueueSelectorServiceMBean {
    private static final long serialVersionUID = -5532252767404568375L;
    protected ServiceName[] queueServiceNames;
    protected Queue[] queues;
    protected ServiceName queueFactoryServiceName;
    protected int distributedSize = 2;
    protected int selectMode = 1;

    @Override
    public void setQueueServiceNames(ServiceName[] names) {
        this.queueServiceNames = names;
    }

    @Override
    public ServiceName[] getQueueServiceNames() {
        return this.queueServiceNames;
    }

    @Override
    public void setQueueFactoryServiceName(ServiceName name) {
        this.queueFactoryServiceName = name;
    }

    @Override
    public ServiceName getQueueFactoryServiceName() {
        return this.queueFactoryServiceName;
    }

    @Override
    public void setDistributedSize(int size) {
        this.distributedSize = size;
    }

    @Override
    public int getDistributedSize() {
        return this.distributedSize;
    }

    @Override
    public void setSelectMode(int mode) {
        this.selectMode = mode;
    }

    @Override
    public int getSelectMode() {
        return this.selectMode;
    }

    @Override
    public void startService() throws Exception {
        if (this.queueServiceNames != null && this.queueServiceNames.length != 0) {
            this.queues = new Queue[this.queueServiceNames.length];
            for (int i = 0; i < this.queueServiceNames.length; ++i) {
                this.queues[i] = (Queue)ServiceManagerFactory.getServiceObject(this.queueServiceNames[i]);
            }
        } else if (this.distributedSize > 1) {
            this.queues = new Queue[this.distributedSize];
            for (int i = 0; i < this.distributedSize; ++i) {
                if (this.queueFactoryServiceName == null) {
                    DefaultQueueService queueService = new DefaultQueueService();
                    queueService.create();
                    queueService.start();
                    this.queues[i] = queueService;
                    continue;
                }
                this.queues[i] = (Queue)ServiceManagerFactory.getServiceObject(this.queueFactoryServiceName);
            }
        } else {
            throw new IllegalArgumentException("Queues must be specified.");
        }
    }

    @Override
    public Queue selectQueue(Object obj) {
        Queue queue = null;
        long min = Long.MAX_VALUE;
        for (int i = 0; i < this.queues.length; ++i) {
            long current = 0L;
            switch (this.selectMode) {
                case 2: {
                    current = this.queues[i].size();
                    break;
                }
                default: {
                    current = this.queues[i].getCount();
                }
            }
            if (queue != null && min <= current) continue;
            min = current;
            queue = this.queues[i];
        }
        return queue;
    }

    @Override
    public Queue[] getQueues() {
        return this.queues;
    }

    @Override
    public void clear() {
    }
}

