/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.tcp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.io.Externalizer;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ConnectionCreateException;
import jp.ossc.nimbus.service.publish.RemoteClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.publish.ServerConnectionListener;
import jp.ossc.nimbus.service.publish.tcp.ClientConnectionImpl;
import jp.ossc.nimbus.service.publish.tcp.ConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.publish.tcp.ServerConnectionImpl;
import jp.ossc.nimbus.service.repository.Repository;

public class ConnectionFactoryService
extends ServiceBase
implements ServerConnectionFactory,
ClientConnectionFactory,
ConnectionFactoryServiceMBean {
    private static final long serialVersionUID = 4621521654243947901L;
    private String clientAddressPropertyName;
    private String clientPortPropertyName;
    private int clientReconnectCount;
    private long clientReconnectInterval;
    private long clientReconnectBufferTime;
    private String serverAddress;
    private int serverPort;
    private int serverBacklog;
    private boolean isNIO;
    private ServiceName nioSocketFactoryServiceName;
    private ServiceName serverSocketFactoryServiceName;
    private ServiceName socketFactoryServiceName;
    private ServiceName jndiRepositoryServiceName;
    private String jndiName = "publish/ClientConnectionFactory";
    private int rmiPort;
    private ServiceName[] serverConnectionListenerServiceNames;
    private int sendThreadSize = 1;
    private ServiceName sendQueueServiceName;
    private int asynchSendThreadSize;
    private ServiceName asynchSendQueueFactoryServiceName;
    private ServiceName externalizerServiceName;
    private int maxSendRetryCount;
    private long sendBufferTime = 5000L;
    private String serverSendErrorMessageId = "PCFT_00001";
    private String serverSendErrorRetryOverMessageId = "PCFT_00002";
    private String clientServerCloseMessageId = "PCFT_00008";
    private String clientReceiveWarnMessageId = "PCFT_00003";
    private String clientReceiveErrorMessageId = "PCFT_00004";
    private ServerSocketFactory serverSocketFactory;
    private ServerConnectionImpl serverConnection;
    private SocketFactory socketFactory;
    private jp.ossc.nimbus.util.net.SocketFactory nioSocketFactory;
    private Repository jndiRepository;
    private Externalizer externalizer;
    private List serverConnectionListeners;

    @Override
    public void setClientAddressPropertyName(String name) {
        this.clientAddressPropertyName = name;
    }

    @Override
    public String getClientAddressPropertyName() {
        return this.clientAddressPropertyName;
    }

    @Override
    public void setClientPortPropertyName(String name) {
        this.clientPortPropertyName = name;
    }

    @Override
    public String getClientPortPropertyName() {
        return this.clientPortPropertyName;
    }

    @Override
    public void setClientReconnectCount(int count) {
        this.clientReconnectCount = count;
    }

    @Override
    public int getClientReconnectCount() {
        return this.clientReconnectCount;
    }

    @Override
    public void setClientReconnectInterval(long interval) {
        this.clientReconnectInterval = interval;
    }

    @Override
    public long getClientReconnectInterval() {
        return this.clientReconnectInterval;
    }

    @Override
    public void setClientReconnectBufferTime(long interval) {
        this.clientReconnectBufferTime = interval;
    }

    @Override
    public long getClientReconnectBufferTime() {
        return this.clientReconnectBufferTime;
    }

    @Override
    public void setServerAddress(String address) {
        this.serverAddress = address;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public void setServerPort(int port) {
        this.serverPort = port;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public boolean isNIO() {
        return this.isNIO;
    }

    @Override
    public void setNIO(boolean isNIO) {
        this.isNIO = isNIO;
    }

    @Override
    public void setServerBacklog(int backlog) {
        this.serverBacklog = backlog;
    }

    @Override
    public int getServerBacklog() {
        return this.serverBacklog;
    }

    @Override
    public void setServerSocketFactoryServiceName(ServiceName name) {
        this.serverSocketFactoryServiceName = name;
    }

    @Override
    public ServiceName getServerSocketFactoryServiceName() {
        return this.serverSocketFactoryServiceName;
    }

    @Override
    public void setSocketFactoryServiceName(ServiceName name) {
        this.socketFactoryServiceName = name;
    }

    @Override
    public ServiceName getSocketFactoryServiceName() {
        return this.socketFactoryServiceName;
    }

    @Override
    public void setNIOSocketFactoryServiceName(ServiceName name) {
        this.nioSocketFactoryServiceName = name;
    }

    @Override
    public ServiceName getNIOSocketFactoryServiceName() {
        return this.nioSocketFactoryServiceName;
    }

    @Override
    public void setJndiName(String name) {
        this.jndiName = name;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public void setJndiRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    @Override
    public ServiceName getJndiRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    @Override
    public void setRMIPort(int port) {
        this.rmiPort = port;
    }

    @Override
    public int getRMIPort() {
        return this.rmiPort;
    }

    @Override
    public void setSendQueueServiceName(ServiceName name) {
        this.sendQueueServiceName = name;
    }

    @Override
    public ServiceName getSendQueueServiceName() {
        return this.sendQueueServiceName;
    }

    @Override
    public void setSendThreadSize(int threadSize) {
        this.sendThreadSize = threadSize;
    }

    @Override
    public int getSendThreadSize() {
        return this.sendThreadSize;
    }

    @Override
    public void setAsynchSendQueueFactoryServiceName(ServiceName name) {
        this.asynchSendQueueFactoryServiceName = name;
    }

    @Override
    public ServiceName getAsynchSendQueueFactoryServiceName() {
        return this.asynchSendQueueFactoryServiceName;
    }

    @Override
    public void setAsynchSendThreadSize(int threadSize) {
        this.asynchSendThreadSize = threadSize;
    }

    @Override
    public int getAsynchSendThreadSize() {
        return this.asynchSendThreadSize;
    }

    @Override
    public void setExternalizerServiceName(ServiceName name) {
        this.externalizerServiceName = name;
    }

    @Override
    public ServiceName getExternalizerServiceName() {
        return this.externalizerServiceName;
    }

    @Override
    public void setServerConnectionListenerServiceNames(ServiceName[] names) {
        this.serverConnectionListenerServiceNames = names;
    }

    @Override
    public ServiceName[] getServerConnectionListenerServiceNames() {
        return this.serverConnectionListenerServiceNames;
    }

    @Override
    public void setMaxSendRetryCount(int count) {
        this.maxSendRetryCount = count;
    }

    @Override
    public int getMaxSendRetryCount() {
        return this.maxSendRetryCount;
    }

    @Override
    public void setSendBufferTime(long time) {
        this.sendBufferTime = time;
    }

    @Override
    public long getSendBufferTime() {
        return this.sendBufferTime;
    }

    @Override
    public void setServerSendErrorMessageId(String id) {
        this.serverSendErrorMessageId = id;
    }

    @Override
    public String getServerSendErrorMessageId() {
        return this.serverSendErrorMessageId;
    }

    @Override
    public void setServerSendErrorRetryOverMessageId(String id) {
        this.serverSendErrorRetryOverMessageId = id;
    }

    @Override
    public String getServerSendErrorRetryOverMessageId() {
        return this.serverSendErrorRetryOverMessageId;
    }

    @Override
    public void setClientServerCloseMessageId(String id) {
        this.clientServerCloseMessageId = id;
    }

    @Override
    public String getClientServerCloseMessageId() {
        return this.clientServerCloseMessageId;
    }

    @Override
    public void setClientReceiveWarnMessageId(String id) {
        this.clientReceiveWarnMessageId = id;
    }

    @Override
    public String getClientReceiveWarnMessageId() {
        return this.clientReceiveWarnMessageId;
    }

    @Override
    public void setClientReceiveErrorMessageId(String id) {
        this.clientReceiveErrorMessageId = id;
    }

    @Override
    public String getClientReceiveErrorMessageId() {
        return this.clientReceiveErrorMessageId;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.serverSocketFactory = factory;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public void setSocketFactory(SocketFactory factory) {
        this.socketFactory = factory;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setNIOSocketFactory(jp.ossc.nimbus.util.net.SocketFactory factory) {
        this.nioSocketFactory = factory;
    }

    public jp.ossc.nimbus.util.net.SocketFactory getNIOSocketFactory() {
        return this.nioSocketFactory;
    }

    public void setExternalizer(Externalizer ext) {
        this.externalizer = ext;
    }

    public Externalizer getExternalizer() {
        return this.externalizer;
    }

    public void addServerConnectionListener(ServerConnectionListener listener) {
        if (this.serverConnectionListeners == null) {
            this.serverConnectionListeners = new ArrayList();
        }
        this.serverConnectionListeners.add(listener);
    }

    public void removeServerConnectionListener(ServerConnectionListener listener) {
        if (this.serverConnectionListeners == null) {
            return;
        }
        this.serverConnectionListeners.remove(listener);
    }

    public void clearServerConnectionListeners() {
        if (this.serverConnectionListeners == null) {
            return;
        }
        this.serverConnectionListeners.clear();
    }

    public ServerConnectionListener[] getServerConnectionListeners() {
        return this.serverConnectionListeners == null ? null : this.serverConnectionListeners.toArray(new ServerConnectionListener[this.serverConnectionListeners.size()]);
    }

    @Override
    public long getSendCount() {
        return this.serverConnection == null ? 0L : this.serverConnection.getSendCount();
    }

    @Override
    public void resetSendCount() {
        if (this.serverConnection == null) {
            return;
        }
        this.serverConnection.resetSendCount();
    }

    @Override
    public long getAverageSendProcessTime() {
        return this.serverConnection == null ? 0L : this.serverConnection.getAverageSendProcessTime();
    }

    @Override
    public Set getClients() {
        if (this.serverConnection == null) {
            return new HashSet();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        HashSet<SocketAddress> result = new HashSet<SocketAddress>();
        for (int i = 0; i < clientArray.length; ++i) {
            SocketAddress address;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || (address = socket.getRemoteSocketAddress()) == null) continue;
            result.add(address);
        }
        return result;
    }

    @Override
    public int getClientSize() {
        return this.serverConnection.getClients().size();
    }

    @Override
    public Set getEnabledClients() {
        if (this.serverConnection == null) {
            return new HashSet();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        HashSet<SocketAddress> result = new HashSet<SocketAddress>();
        for (int i = 0; i < clientArray.length; ++i) {
            SocketAddress address;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || !clientArray[i].isEnabled() || (address = socket.getRemoteSocketAddress()) == null) continue;
            result.add(address);
        }
        return result;
    }

    @Override
    public Set getDisabledClients() {
        if (this.serverConnection == null) {
            return new HashSet();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        HashSet<SocketAddress> result = new HashSet<SocketAddress>();
        for (int i = 0; i < clientArray.length; ++i) {
            SocketAddress address;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || clientArray[i].isEnabled() || (address = socket.getRemoteSocketAddress()) == null) continue;
            result.add(address);
        }
        return result;
    }

    @Override
    public void enabledClient(String address, int port) {
        this.setEnabledClient(address, port, true);
    }

    @Override
    public void disabledClient(String address, int port) {
        this.setEnabledClient(address, port, false);
    }

    @Override
    public Set getSubjects(String address, int port) {
        if (this.serverConnection == null) {
            return new HashSet();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        for (int i = 0; i < clientArray.length; ++i) {
            InetSocketAddress remoteAddress;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || (remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress()) == null || !remoteAddress.getAddress().getHostAddress().equals(address) && !remoteAddress.getAddress().getHostName().equalsIgnoreCase(address) || port != remoteAddress.getPort()) continue;
            return clientArray[i].getSubjects();
        }
        return new HashSet();
    }

    @Override
    public Set getKeys(String address, int port, String subject) {
        if (this.serverConnection == null) {
            return new HashSet();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        for (int i = 0; i < clientArray.length; ++i) {
            InetSocketAddress remoteAddress;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || (remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress()) == null || !remoteAddress.getAddress().getHostAddress().equals(address) && !remoteAddress.getAddress().getHostName().equalsIgnoreCase(address) || port != remoteAddress.getPort()) continue;
            return clientArray[i].getKeys(subject);
        }
        return new HashSet();
    }

    private void setEnabledClient(String address, int port, boolean isEnabled) {
        if (this.serverConnection == null) {
            return;
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        for (int i = 0; i < clientArray.length; ++i) {
            InetSocketAddress remoteAddress;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || clientArray[i].isEnabled() == isEnabled || (remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress()) == null || !remoteAddress.getAddress().getHostAddress().equals(address) && !remoteAddress.getAddress().getHostName().equalsIgnoreCase(address) || port > 0 && port != remoteAddress.getPort()) continue;
            clientArray[i].setEnabled(isEnabled);
        }
    }

    @Override
    public Map getSendCountsByClient() {
        if (this.serverConnection == null) {
            return new HashMap();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        HashMap<SocketAddress, Long> result = new HashMap<SocketAddress, Long>();
        for (int i = 0; i < clientArray.length; ++i) {
            SocketAddress address;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || (address = socket.getRemoteSocketAddress()) == null) continue;
            result.put(address, new Long(clientArray[i].getSendCount()));
        }
        return result;
    }

    @Override
    public Map getAverageSendProcessTimesByClient() {
        if (this.serverConnection == null) {
            return new HashMap();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        HashMap<SocketAddress, Long> result = new HashMap<SocketAddress, Long>();
        for (int i = 0; i < clientArray.length; ++i) {
            SocketAddress address;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || (address = socket.getRemoteSocketAddress()) == null) continue;
            result.put(address, new Long(clientArray[i].getAverageSendProcessTime()));
        }
        return result;
    }

    @Override
    public void resetSendCountsByClient() {
        if (this.serverConnection == null) {
            return;
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        for (int i = 0; i < clientArray.length; ++i) {
            clientArray[i].resetSendCount();
        }
    }

    @Override
    public void startService() throws Exception {
        if (this.clientReconnectCount > 0 && this.serverPort == 0) {
            throw new IllegalArgumentException("When clientReconnectCount is more than 0, serverPort must not be 0.");
        }
        if (this.serverAddress == null) {
            this.serverAddress = InetAddress.getLocalHost().getHostAddress();
        }
        if (this.externalizerServiceName != null) {
            this.externalizer = (Externalizer)ServiceManagerFactory.getServiceObject(this.externalizerServiceName);
        }
        if (this.isNIO) {
            if (this.nioSocketFactoryServiceName != null) {
                this.nioSocketFactory = (jp.ossc.nimbus.util.net.SocketFactory)ServiceManagerFactory.getServiceObject(this.nioSocketFactoryServiceName);
            }
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.socket().setReuseAddress(true);
            serverSocketChannel.socket().bind(new InetSocketAddress(this.serverAddress, this.serverPort));
            if (this.serverPort == 0) {
                this.serverPort = serverSocketChannel.socket().getLocalPort();
            }
            serverSocketChannel.configureBlocking(false);
            this.serverConnection = new ServerConnectionImpl(serverSocketChannel, this.externalizer, this.sendThreadSize, this.sendQueueServiceName, this.asynchSendThreadSize, this.asynchSendQueueFactoryServiceName, this.nioSocketFactory);
        } else {
            ServerSocket serverSocket = null;
            if (this.serverSocketFactory == null) {
                if (this.serverSocketFactoryServiceName == null) {
                    serverSocket = new ServerSocket(this.serverPort, this.serverBacklog, InetAddress.getByName(this.serverAddress));
                } else {
                    this.serverSocketFactory = (ServerSocketFactory)ServiceManagerFactory.getServiceObject(this.serverSocketFactoryServiceName);
                }
            }
            if (serverSocket == null) {
                serverSocket = this.serverSocketFactory.createServerSocket(this.serverPort, this.serverBacklog, InetAddress.getByName(this.serverAddress));
            }
            if (this.serverPort == 0) {
                this.serverPort = serverSocket.getLocalPort();
            }
            this.serverConnection = new ServerConnectionImpl(serverSocket, this.externalizer, this.sendThreadSize, this.sendQueueServiceName, this.asynchSendThreadSize, this.asynchSendQueueFactoryServiceName);
        }
        this.serverConnection.setLogger(this.getLogger());
        this.serverConnection.setMaxSendRetryCount(this.maxSendRetryCount);
        this.serverConnection.setSendBufferTime(this.sendBufferTime);
        this.serverConnection.setSendErrorMessageId(this.serverSendErrorMessageId);
        this.serverConnection.setSendErrorRetryOverMessageId(this.serverSendErrorRetryOverMessageId);
        if (this.serverConnectionListenerServiceNames != null) {
            for (int i = 0; i < this.serverConnectionListenerServiceNames.length; ++i) {
                this.serverConnection.addServerConnectionListener((ServerConnectionListener)ServiceManagerFactory.getServiceObject(this.serverConnectionListenerServiceNames[i]));
            }
        }
        if (this.serverConnectionListeners != null) {
            int imax = this.serverConnectionListeners.size();
            for (int i = 0; i < imax; ++i) {
                this.serverConnection.addServerConnectionListener((ServerConnectionListener)this.serverConnectionListeners.get(i));
            }
        }
        if (this.socketFactoryServiceName != null) {
            this.socketFactory = (SocketFactory)ServiceManagerFactory.getServiceObject(this.socketFactoryServiceName);
        }
        if (this.jndiRepositoryServiceName != null) {
            this.jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(this.jndiRepositoryServiceName);
            RemoteClientConnectionFactory remoteClientConnectionFactory = new RemoteClientConnectionFactory(this, this.rmiPort);
            if (!this.jndiRepository.register(this.jndiName, remoteClientConnectionFactory)) {
                throw new Exception("Could not register in jndiRepository.");
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.jndiRepository != null) {
            this.jndiRepository.unregister(this.jndiName);
        }
        if (this.serverConnection != null) {
            this.serverConnection.close();
            this.serverConnection = null;
        }
    }

    @Override
    public ServerConnection getServerConnection() throws ConnectionCreateException {
        return this.serverConnection;
    }

    @Override
    public ClientConnection getClientConnection() throws ConnectionCreateException {
        ClientConnectionImpl connection = new ClientConnectionImpl(this.serverAddress, this.serverPort, this.socketFactory, this.externalizer, this.getServiceNameObject());
        if (this.clientAddressPropertyName != null) {
            connection.setBindAddressPropertyName(this.clientAddressPropertyName);
        }
        if (this.clientPortPropertyName != null) {
            connection.setBindPortPropertyName(this.clientPortPropertyName);
        }
        connection.setServerCloseMessageId(this.clientServerCloseMessageId);
        connection.setReceiveWarnMessageId(this.clientReceiveWarnMessageId);
        connection.setReceiveErrorMessageId(this.clientReceiveErrorMessageId);
        connection.setReconnectCount(this.clientReconnectCount);
        connection.setReconnectInterval(this.clientReconnectInterval);
        connection.setReconnectBufferTime(this.clientReconnectBufferTime);
        return connection;
    }

    @Override
    public int getClientCount() {
        return this.serverConnection == null ? 0 : this.serverConnection.getClientCount();
    }
}

