/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.msgresource;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.io.ExtentionFileFilter;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.byteconvert.ByteConverter;
import jp.ossc.nimbus.service.byteconvert.ByteConverterFactory;
import jp.ossc.nimbus.service.cui.DisplayConstructer;
import jp.ossc.nimbus.service.msgresource.BytesOrStreamMessageFormat;
import jp.ossc.nimbus.service.msgresource.CommonMessageFormat;
import jp.ossc.nimbus.service.msgresource.MapMessageFormat;
import jp.ossc.nimbus.service.msgresource.MessageResource;
import jp.ossc.nimbus.service.msgresource.MessageResourceDefine;
import jp.ossc.nimbus.service.msgresource.MessageResourceFactory;
import jp.ossc.nimbus.service.msgresource.MessageResourceFactoryServiceMBean;
import jp.ossc.nimbus.service.msgresource.MessageResourceImpl;
import jp.ossc.nimbus.service.msgresource.MessageResourceOperator;
import jp.ossc.nimbus.service.msgresource.MessageResourceUtil;
import jp.ossc.nimbus.service.msgresource.ObjectMessageFormat;
import jp.ossc.nimbus.service.msgresource.TextMessageFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MessageResourceFactoryService
extends ServiceBase
implements MessageResourceFactoryServiceMBean,
MessageResourceFactory,
MessageResourceDefine,
DisplayConstructer {
    private static final long serialVersionUID = -9078293076843372913L;
    private String mDefineFileDir = null;
    private String mDefFileExt = null;
    private HashMap mMsgResObjectHash = new HashMap();
    private ArrayList mMsgResArrayList = new ArrayList();
    private ServiceName mByteConverterFactoryName = null;
    private ByteConverterFactory mByteConverterFactory = null;
    private ByteConverter mByteConverter = null;

    @Override
    public MessageResource findInstance(String key) {
        return (MessageResource)this.mMsgResObjectHash.get(key);
    }

    @Override
    public String check(String val) {
        if (this.mMsgResObjectHash.containsKey(val)) {
            return val;
        }
        return null;
    }

    @Override
    public String display() {
        StringBuffer ret = new StringBuffer();
        for (MessageResourceOperator msgResObj : this.mMsgResArrayList) {
            ret.append(msgResObj.getKey());
            ret.append(" ");
            ret.append(msgResObj.display());
            ret.append("\t");
        }
        return ret.toString();
    }

    @Override
    public void setDefineFileDir(String dir) {
        this.mDefineFileDir = dir;
    }

    @Override
    public String getDefineFineDir() {
        return this.mDefineFileDir;
    }

    @Override
    public void setDefineFileExt(String ext) {
        this.mDefFileExt = ext;
    }

    @Override
    public String getDefineFileExt() {
        return this.mDefFileExt;
    }

    @Override
    public void setByteConverterServiceName(ServiceName name) {
        this.mByteConverterFactoryName = name;
    }

    public void setByteConverterFactory(ByteConverterFactory byteConverterFactory) {
        this.mByteConverterFactory = byteConverterFactory;
    }

    @Override
    public void startService() {
        if (this.mByteConverterFactoryName != null) {
            this.mByteConverterFactory = (ByteConverterFactory)((Object)ServiceManagerFactory.getService(this.mByteConverterFactoryName));
        }
        this.mByteConverter = this.mByteConverterFactory.findConverter(0);
        File DefDir = new File(this.mDefineFileDir);
        ExtentionFileFilter filter = new ExtentionFileFilter(this.mDefFileExt);
        File[] defFileList = DefDir.listFiles(filter);
        if (defFileList != null) {
            for (int rCnt = 0; rCnt < defFileList.length; ++rCnt) {
                this.loadXMLDefinition(defFileList[rCnt]);
            }
        }
    }

    protected void loadXMLDefinition(File xmlfile) {
        Element root = null;
        try {
            root = this.getRoot(xmlfile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException("MESSAGERESOURCEFACTORY001", "Fail to get Root Element.", e);
        }
        NodeList MessageList = root.getElementsByTagName("Message");
        for (int rCnt = 0; rCnt < MessageList.getLength(); ++rCnt) {
            Element msgElement = (Element)MessageList.item(rCnt);
            String disp = MessageResourceUtil.getAttMustBeSpecified(msgElement, "display");
            String key = MessageResourceUtil.getAttMustBeSpecified(msgElement, "selectKey");
            MessageResourceImpl msgResource = new MessageResourceImpl();
            msgResource.setKey(key);
            msgResource.setDisplayMessage(disp);
            this.setMsgResBLFlowKeys(msgResource, msgElement);
            this.setMsgResFormatData(msgResource, msgElement, "send");
            this.setMsgResFormatData(msgResource, msgElement, "recv");
            this.mMsgResObjectHash.put(key, msgResource);
            this.mMsgResArrayList.add(msgResource);
        }
    }

    protected Element getRoot(File xmlfile) throws Exception {
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbfactory.newDocumentBuilder();
        Document doc = builder.parse(xmlfile);
        return doc.getDocumentElement();
    }

    protected void setMsgResBLFlowKeys(MessageResourceOperator msg, Element element) {
        NodeList blFlowList = element.getElementsByTagName("BLFlow");
        for (int rCnt = 0; rCnt < blFlowList.getLength(); ++rCnt) {
            Element blFlow = (Element)blFlowList.item(rCnt);
            String name = MessageResourceUtil.getAttMustBeSpecified(blFlow, "pattern");
            String value = MessageResourceUtil.getValueMustbeSpecified(blFlow);
            msg.addBLFlowKey(name, value);
        }
    }

    protected void setMsgResFormatData(MessageResourceOperator msg, Element element, String kind) {
        String tag = null;
        if (kind.equals("send")) {
            tag = "SendData";
        } else if (kind.equals("recv")) {
            tag = "RecvData";
        }
        NodeList DataList = element.getElementsByTagName(tag);
        int definedNum = DataList.getLength();
        if (definedNum > 1) {
            throw new ServiceException("MESSAGERESOURCEFACTORY005", tag + " must be specified only one or not be specified.");
        }
        if (definedNum != 0) {
            Element Data = (Element)DataList.item(0);
            String JmsMsgType = MessageResourceUtil.getAttMustBeSpecified(Data, "type");
            CommonMessageFormat messageFormat = null;
            if (JmsMsgType.equals("Text")) {
                messageFormat = new TextMessageFormat(this.mByteConverter);
            } else if (JmsMsgType.equals("Bytes")) {
                messageFormat = new BytesOrStreamMessageFormat(this.mByteConverter, "Bytes");
            } else if (JmsMsgType.equals("Object")) {
                messageFormat = new ObjectMessageFormat(this.mByteConverter);
            } else if (JmsMsgType.equals("Stream")) {
                messageFormat = new BytesOrStreamMessageFormat(this.mByteConverter, "Stream");
            } else if (JmsMsgType.equals("Map")) {
                messageFormat = new MapMessageFormat(this.mByteConverter);
            } else {
                throw new ServiceException("MESSAGERESOURCEFACTORY004", "[" + JmsMsgType + "]  is invalid as JMS Message Type.");
            }
            messageFormat.parse(Data);
            msg.setMessageFormat(messageFormat, kind);
        }
    }

    @Override
    public String getByteConverterServiceName() {
        return this.mByteConverterFactoryName.getServiceName();
    }
}

