/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.message;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.io.ExtentionFileFilter;
import jp.ossc.nimbus.io.UnicodeHexBufferedReader;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.message.MessageRecord;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.service.message.MessageRecordFactoryServiceMBean;
import jp.ossc.nimbus.service.message.MessageRecordImpl;
import jp.ossc.nimbus.service.message.MessageRecordOperator;
import jp.ossc.nimbus.service.message.MessageRecordParseException;
import jp.ossc.nimbus.util.CsvArrayList;
import jp.ossc.nimbus.util.StringOperator;

public class MessageRecordFactoryService
extends ServiceBase
implements MessageRecordFactory,
MessageRecordFactoryServiceMBean {
    private static final long serialVersionUID = 2051325927530427511L;
    private static final String C_DFAULT_DEF = "jp/ossc/nimbus/resource/Nimbus";
    private static final String C_UNDER_SCORE = "_";
    private static final String C_SLUSH = "/";
    private static final String C_BKSLA = "\\";
    private static final String C_PATH_DELIMETER = ";";
    private static final String C_RECORD_DELIMETER = ",";
    private static final String C_FOUND_DEF = "1";
    private static final String C_NOT_FOUND_DEF = "0";
    protected CsvArrayList mDir = new CsvArrayList();
    protected HashMap mMessageMap;
    protected String mExtention = "def";
    protected Class mMessageRecordClass = MessageRecordImpl.class;
    protected String mMessageRecordClassName = MessageRecordImpl.class.getName();
    protected boolean mIsSecret;
    protected String secretString;
    protected String[] mLocales = new String[0];
    protected HashSet mSerchedLocale;
    protected HashMap mSerchedPath;
    protected CsvArrayList mDefFileNames = new CsvArrayList();
    protected boolean isAllowOverrideMessage;

    public MessageRecordFactoryService() {
        this.mDefFileNames.add(C_DFAULT_DEF);
    }

    @Override
    public void setMessageDirPaths(String[] paths) {
        this.mDir.clear();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                this.mDir.add(paths[i]);
            }
        }
    }

    @Override
    public String[] getMessageDirPaths() {
        return this.mDir.toArray(new String[this.mDir.size()]);
    }

    @Override
    public void addMessageDirPaths(String path) throws Exception {
        CsvArrayList tmpAry = new CsvArrayList();
        tmpAry.split(path, C_PATH_DELIMETER);
        if (tmpAry.size() <= 0) {
            return;
        }
        for (String defFilePath : tmpAry) {
            boolean bFlg = false;
            for (int cnt = 0; cnt < this.mDir.size(); ++cnt) {
                if (!this.mDir.getStr(cnt).equals(defFilePath)) continue;
                bFlg = true;
                break;
            }
            if (bFlg) continue;
            this.mDir.add(defFilePath);
            File errDefDir = new File(defFilePath);
            this.setMessageDef(errDefDir);
            this.searchMessageDef(errDefDir);
        }
    }

    @Override
    public void setExtentionOfMessageFile(String extention) {
        this.mExtention = extention;
    }

    @Override
    public String getExtentionOfMessageFile() {
        return this.mExtention;
    }

    @Override
    public void setMessageRecordClassName(String className) throws ServiceException {
        this.mMessageRecordClassName = className;
        try {
            this.mMessageRecordClass = Class.forName(className, true, NimbusClassLoader.getInstance());
        }
        catch (ClassNotFoundException ce) {
            throw new ServiceException("MSG000030", "MessageRecordClassName is invalid class name is " + this.mMessageRecordClassName, ce);
        }
    }

    @Override
    public String getMessageRecordClassName() {
        return this.mMessageRecordClass.getName();
    }

    @Override
    public void setSecretMode(boolean flg) {
        this.mIsSecret = flg;
    }

    @Override
    public boolean isSecretMode() {
        return this.mIsSecret;
    }

    @Override
    public void setSecretString(String secret) {
        this.secretString = secret;
    }

    @Override
    public String getSecretString() {
        return this.secretString;
    }

    @Override
    public void setLocaleStrings(String[] locales) {
        this.mLocales = locales;
    }

    @Override
    public String[] getLocaleStrings() {
        return this.mLocales;
    }

    @Override
    public void addMessageFiles(String files) throws Exception {
        CsvArrayList tmp = new CsvArrayList();
        tmp.split(files, C_PATH_DELIMETER);
        if (tmp.size() <= 0) {
            return;
        }
        for (String fileName : tmp) {
            URL url;
            boolean bFlg = false;
            for (int cnt = 0; cnt < this.mDir.size(); ++cnt) {
                if (!this.mDefFileNames.getStr(cnt).equals(fileName)) continue;
                bFlg = true;
                break;
            }
            if (bFlg || (url = Thread.currentThread().getContextClassLoader().getResource(fileName + '.' + this.mExtention)) == null || url.openStream() == null) continue;
            this.readStream(url.openStream(), null);
            for (int j = 0; j < this.mLocales.length; ++j) {
                this.loadDefFileFromResource(this.mLocales[j], fileName);
            }
        }
    }

    @Override
    public void setMessageFiles(String[] files) {
        this.mDefFileNames.clear();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.mDefFileNames.add(files[i]);
            }
        }
        this.mDefFileNames.add(C_DFAULT_DEF);
    }

    @Override
    public String[] getMessageFiles() {
        return this.mDefFileNames.toArray(new String[this.mDefFileNames.size()]);
    }

    @Override
    public void setAllowOverrideMessage(boolean isAllow) {
        this.isAllowOverrideMessage = isAllow;
    }

    @Override
    public boolean isAllowOverrideMessage() {
        return this.isAllowOverrideMessage;
    }

    @Override
    public void createService() throws Exception {
        this.mMessageMap = new HashMap();
        this.mSerchedLocale = new HashSet();
        this.mSerchedPath = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        for (String defFilePath : this.mDir) {
            File errDefDir = new File(defFilePath);
            this.setMessageDef(errDefDir);
            this.searchMessageDef(errDefDir);
        }
        for (String fileName : this.mDefFileNames) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(fileName + '.' + this.mExtention);
            if (url == null) continue;
            this.readStream(url.openStream(), null);
            for (int j = 0; j < this.mLocales.length; ++j) {
                this.loadDefFileFromResource(this.mLocales[j], fileName);
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        this.mMessageMap.clear();
        this.mSerchedLocale.clear();
        this.mSerchedPath.clear();
    }

    @Override
    public void destroyService() throws Exception {
        this.mMessageMap = null;
        this.mSerchedLocale = null;
        this.mSerchedPath = null;
    }

    private void loadDirByLocale(Locale lo, String dirPath) throws IOException, MessageRecordParseException {
        StringBuffer propKey = new StringBuffer(dirPath);
        propKey.append(C_SLUSH).append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry()).append(C_UNDER_SCORE).append(lo.getVariant());
        String key = StringOperator.replaceString(propKey.toString(), C_BKSLA, C_SLUSH);
        String result = (String)this.mSerchedPath.get(key);
        File dirFile = null;
        if (result == null && this.addMessageDef(dirFile = new File(key))) {
            return;
        }
        propKey.setLength(0);
        propKey.append(dirPath).append(C_SLUSH).append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry());
        key = StringOperator.replaceString(propKey.toString(), C_BKSLA, C_SLUSH);
        result = (String)this.mSerchedPath.get(key);
        if (result == null && this.addMessageDef(dirFile = new File(key))) {
            return;
        }
        propKey.setLength(0);
        propKey.append(dirPath).append(C_SLUSH).append(lo.getLanguage());
        key = StringOperator.replaceString(propKey.toString(), C_BKSLA, C_SLUSH);
        result = (String)this.mSerchedPath.get(key);
        if (result == null && this.addMessageDef(dirFile = new File(key))) {
            return;
        }
        if (lo.equals(Locale.getDefault())) {
            return;
        }
        Locale loDafault = Locale.getDefault();
        propKey.setLength(0);
        propKey.append(dirPath).append(C_SLUSH).append(loDafault.getLanguage()).append(C_UNDER_SCORE).append(loDafault.getCountry()).append(C_UNDER_SCORE).append(loDafault.getVariant());
        key = StringOperator.replaceString(propKey.toString(), C_BKSLA, C_SLUSH);
        result = (String)this.mSerchedPath.get(key);
        if (result == null && this.addMessageDef(dirFile = new File(key))) {
            return;
        }
        propKey.setLength(0);
        propKey.append(dirPath).append(C_SLUSH).append(loDafault.getLanguage()).append(C_UNDER_SCORE).append(loDafault.getCountry());
        key = StringOperator.replaceString(propKey.toString(), C_BKSLA, C_SLUSH);
        result = (String)this.mSerchedPath.get(key);
        if (result == null && this.addMessageDef(dirFile = new File(key))) {
            return;
        }
        propKey.setLength(0);
        propKey.append(dirPath).append(C_SLUSH).append(loDafault.getLanguage());
        key = StringOperator.replaceString(propKey.toString(), C_BKSLA, C_SLUSH);
        result = (String)this.mSerchedPath.get(key);
        if (result == null && this.addMessageDef(dirFile = new File(key))) {
            return;
        }
    }

    private void loadClassPathByLocale(Locale lo, String defFileName) throws IOException, MessageRecordParseException {
        StringBuffer propKey = new StringBuffer();
        propKey.append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry()).append(C_UNDER_SCORE).append(lo.getVariant());
        String fileName = defFileName + '_' + propKey.toString() + '.' + this.mExtention;
        String result = (String)this.mSerchedPath.get(fileName);
        if (result == null && this.loadDefFileFromResource(propKey.toString(), defFileName)) {
            return;
        }
        propKey.setLength(0);
        propKey.append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry());
        fileName = defFileName + '_' + propKey.toString() + '.' + this.mExtention;
        result = (String)this.mSerchedPath.get(fileName);
        if (result == null && this.loadDefFileFromResource(propKey.toString(), defFileName)) {
            return;
        }
        propKey.setLength(0);
        propKey.append(lo.getLanguage());
        fileName = defFileName + '_' + propKey.toString() + '.' + this.mExtention;
        result = (String)this.mSerchedPath.get(fileName);
        if (result == null && this.loadDefFileFromResource(propKey.toString(), defFileName)) {
            return;
        }
        if (lo.equals(Locale.getDefault())) {
            return;
        }
        Locale loDafault = Locale.getDefault();
        propKey.setLength(0);
        propKey.append(loDafault.getLanguage()).append(C_UNDER_SCORE).append(loDafault.getCountry()).append(C_UNDER_SCORE).append(loDafault.getVariant());
        fileName = defFileName + '_' + propKey.toString() + '.' + this.mExtention;
        result = (String)this.mSerchedPath.get(fileName);
        if (result == null && this.loadDefFileFromResource(propKey.toString(), defFileName)) {
            return;
        }
        propKey.setLength(0);
        propKey.append(loDafault.getLanguage()).append(C_UNDER_SCORE).append(loDafault.getCountry());
        fileName = defFileName + '_' + propKey.toString() + '.' + this.mExtention;
        result = (String)this.mSerchedPath.get(fileName);
        if (result == null && this.loadDefFileFromResource(propKey.toString(), defFileName)) {
            return;
        }
        propKey.setLength(0);
        propKey.append(loDafault.getLanguage());
        fileName = defFileName + '_' + propKey.toString() + '.' + this.mExtention;
        result = (String)this.mSerchedPath.get(fileName);
        if (result == null && this.loadDefFileFromResource(propKey.toString(), defFileName)) {
            return;
        }
    }

    private boolean loadDefFileFromResource(String loString, String defName) throws IOException, MessageRecordParseException {
        String fileName = defName + '_' + loString + '.' + this.mExtention;
        boolean bret = false;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(fileName);
        try {
            if (url != null) {
                this.readStream(url.openStream(), loString);
                this.mSerchedPath.put(fileName, C_FOUND_DEF);
                bret = true;
            } else {
                this.mSerchedPath.put(fileName, C_NOT_FOUND_DEF);
            }
        }
        catch (IOException e) {
            this.mSerchedPath.put(fileName, C_NOT_FOUND_DEF);
        }
        return bret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findLocale(Locale lo) {
        HashSet hashSet = this.mSerchedLocale;
        synchronized (hashSet) {
            Locale tmpLo = null;
            tmpLo = lo == null ? Locale.getDefault() : lo;
            if (!this.mSerchedLocale.contains(tmpLo)) {
                boolean isLoad = false;
                for (String defDirPath : this.mDir) {
                    try {
                        this.loadDirByLocale(tmpLo, defDirPath);
                        isLoad = true;
                    }
                    catch (Exception e) {}
                }
                for (String fileName : this.mDefFileNames) {
                    try {
                        this.loadClassPathByLocale(tmpLo, fileName);
                        isLoad = true;
                    }
                    catch (Exception e) {}
                }
                if (isLoad) {
                    this.mSerchedLocale.add(tmpLo);
                }
            }
        }
    }

    protected void searchMessageDef(File dirRoot) throws IOException, MessageRecordParseException {
        if (this.mLocales == null || this.mLocales.length == 0) {
            return;
        }
        File[] dirs = dirRoot.listFiles();
        if (dirs != null) {
            block0: for (int cnt = 0; cnt < dirs.length; ++cnt) {
                if (!dirs[cnt].isDirectory()) continue;
                this.name = dirs[cnt].getName();
                for (int j = 0; j < this.mLocales.length; ++j) {
                    if (!this.name.equals(this.mLocales[j])) continue;
                    this.addMessageDef(dirs[cnt]);
                    continue block0;
                }
            }
        }
    }

    protected void setMessageDef(File dirRoot) throws IOException, MessageRecordParseException {
        ExtentionFileFilter filter = new ExtentionFileFilter(this.mExtention);
        File[] defFileList = dirRoot.listFiles(filter);
        if (defFileList != null) {
            for (int rCnt = 0; rCnt < defFileList.length; ++rCnt) {
                if (!defFileList[rCnt].isFile()) continue;
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(defFileList[rCnt]);
                }
                catch (FileNotFoundException e) {
                    continue;
                }
                this.readStream(stream, null);
            }
        }
    }

    protected boolean addMessageDef(File dir) throws IOException, MessageRecordParseException {
        ExtentionFileFilter filter = new ExtentionFileFilter(this.mExtention);
        File[] defFileList = dir.listFiles(filter);
        boolean bret = false;
        if (defFileList != null) {
            for (int rCnt = 0; rCnt < defFileList.length; ++rCnt) {
                if (defFileList[rCnt].isDirectory()) continue;
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(defFileList[rCnt]);
                }
                catch (FileNotFoundException e) {
                    continue;
                }
                this.readStream(stream, dir.getName());
            }
            this.mSerchedPath.put(dir.getAbsolutePath(), C_FOUND_DEF);
            bret = true;
        } else {
            this.mSerchedPath.put(dir.getAbsolutePath(), C_NOT_FOUND_DEF);
        }
        return bret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStream(InputStream stream, String locale) throws IOException, MessageRecordParseException {
        UnicodeHexBufferedReader in = new UnicodeHexBufferedReader(new InputStreamReader(stream));
        String record = null;
        try {
            while ((record = in.readLine()) != null) {
                if (record.length() == 0 || record.charAt(0) == '#') continue;
                if (locale == null) {
                    this.putDefRec(record);
                    continue;
                }
                this.addDefRec(record, locale);
            }
        }
        finally {
            in.close();
            stream.close();
        }
    }

    protected void addDefRec(String record, String locale) {
        CsvArrayList ps = new CsvArrayList();
        ps.split(record, C_RECORD_DELIMETER);
        if (ps.size() < 2) {
            throw new ServiceException("MESSAGERECORDSERVICEA00", "record format error record is " + record);
        }
        MessageRecordOperator messageRec = (MessageRecordOperator)this.mMessageMap.get(ps.getStr(0));
        if (messageRec == null) {
            throw new ServiceException("MESSAGERECORDSERVICEA01", "record id invalid. record is " + record);
        }
        messageRec.addMessage(ps.getStr(1), locale);
    }

    protected void putDefRec(String record) throws MessageRecordParseException {
        MessageRecordOperator messageRec = null;
        try {
            messageRec = (MessageRecordOperator)this.mMessageRecordClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ServiceException("MESSAGERECORDSERVICE030", "newInstance() failed.Class name is " + this.mMessageRecordClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("MESSAGERECORDSERVICE040", "newInstance() failed.Class name is " + this.mMessageRecordClass.getName(), e);
        }
        messageRec.rec2Obj(record);
        messageRec.setFactory(this);
        MessageRecord rec = (MessageRecord)((Object)messageRec);
        MessageRecordOperator tmpRec = (MessageRecordOperator)this.mMessageMap.get(rec.getMessageCode());
        if (tmpRec == null) {
            this.mMessageMap.put(rec.getMessageCode(), messageRec);
        } else if (!this.isAllowOverrideMessage) {
            throw new ServiceException("MESSAGERECORDSERVICE041", "message code duplicate.recode is " + record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList getMessgaeList() {
        MessageRecordOperator rec2 = null;
        ArrayList<String> retAry = new ArrayList<String>();
        HashMap hashMap = this.mMessageMap;
        synchronized (hashMap) {
            Collection c = this.mMessageMap.values();
            for (MessageRecordOperator rec2 : c) {
                retAry.add(rec2.toString());
            }
        }
        return retAry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList getUsedMessgaeList() {
        ArrayList<String> retAry = new ArrayList<String>();
        HashMap hashMap = this.mMessageMap;
        synchronized (hashMap) {
            Collection c = this.mMessageMap.values();
            for (MessageRecordOperator container : c) {
                if (container.getUsedCount() <= 0L) continue;
                retAry.add(container.toString());
            }
        }
        return retAry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initUsedCount() {
        HashMap hashMap = this.mMessageMap;
        synchronized (hashMap) {
            Collection c = this.mMessageMap.values();
            for (MessageRecordOperator container : c) {
                container.clearUsedCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageRecord findMessageRecord(String key) {
        MessageRecord eif;
        HashMap hashMap = this.mMessageMap;
        synchronized (hashMap) {
            eif = (MessageRecord)this.mMessageMap.get(key);
            if (eif != null) {
                MessageRecordOperator op = (MessageRecordOperator)((Object)eif);
                op.setSecret(this.mIsSecret);
                op.setSecretString(this.secretString);
            }
        }
        return eif;
    }

    @Override
    public String findMessageTemplete(Locale lo, String key) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.getMessageTemplate(lo);
    }

    @Override
    public String findMessageTemplete(String key) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.getMessageTemplate();
    }

    @Override
    public String findMessage(Locale lo, String key) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo);
    }

    @Override
    public String findMessage(String key) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage();
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, Object[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embeds);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, byte[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embeds);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, short[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embeds);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, char[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embeds);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, int[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embeds);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, long[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embeds);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, float[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embeds);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, double[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embeds);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, boolean[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embeds);
    }

    @Override
    public String findEmbedMessage(String key, Object[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embeds);
    }

    @Override
    public String findEmbedMessage(String key, byte[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embeds);
    }

    @Override
    public String findEmbedMessage(String key, short[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embeds);
    }

    @Override
    public String findEmbedMessage(String key, char[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embeds);
    }

    @Override
    public String findEmbedMessage(String key, int[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embeds);
    }

    @Override
    public String findEmbedMessage(String key, long[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embeds);
    }

    @Override
    public String findEmbedMessage(String key, float[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embeds);
    }

    @Override
    public String findEmbedMessage(String key, double[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embeds);
    }

    @Override
    public String findEmbedMessage(String key, boolean[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embeds);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, Object embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embed);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, byte embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embed);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, short embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embed);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, char embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embed);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, int embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embed);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, long embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embed);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, float embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embed);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, double embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embed);
    }

    @Override
    public String findEmbedMessage(Locale lo, String key, boolean embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(lo, embed);
    }

    @Override
    public String findEmbedMessage(String key, Object embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embed);
    }

    @Override
    public String findEmbedMessage(String key, byte embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embed);
    }

    @Override
    public String findEmbedMessage(String key, short embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embed);
    }

    @Override
    public String findEmbedMessage(String key, char embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embed);
    }

    @Override
    public String findEmbedMessage(String key, int embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embed);
    }

    @Override
    public String findEmbedMessage(String key, long embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embed);
    }

    @Override
    public String findEmbedMessage(String key, float embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embed);
    }

    @Override
    public String findEmbedMessage(String key, double embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embed);
    }

    @Override
    public String findEmbedMessage(String key, boolean embed) {
        MessageRecord rec = this.findMessageRecord(key);
        return rec == null ? null : rec.makeMessage(embed);
    }
}

