/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.keepalive.smtp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.keepalive.KeepAliveListener;
import jp.ossc.nimbus.service.keepalive.smtp.SmtpCheckerServiceMBean;

public class SmtpCheckerService
extends ServiceBase
implements SmtpCheckerServiceMBean,
DaemonRunnable {
    private static final long serialVersionUID = -1543463563116884001L;
    protected static final String C_HELLOW = "HELO localhost\r\n";
    protected static final String C_EOF_KEY = "WOUGN0600002002";
    protected static final String C_WRONG_SIGN = "2";
    protected static final String C_ERRSTATE_KEY = "WOUGN0600002003";
    protected static final String C_NORMALSTATE_KEY = "WOUGN0600002004";
    protected static final String C_QUITE = "QUIT\r\n";
    protected static final String C_TIMEOUT_KEY = "WOUGN0600002005";
    protected static final String C_PROTOCOL_ERROR_KEY = "WOUGN0600002006";
    protected static final String C_IOERROR_KEY = "WOUGN0600002007";
    protected String mHostName;
    protected InetAddress mIp;
    protected volatile int mPort = 0;
    protected volatile int mConnectionTimeOut = 0;
    protected volatile int mTimeOut = 1000;
    protected String eofLogMessageId = "WOUGN0600002002";
    protected String errorStateLogMessageId = "WOUGN0600002003";
    protected String normalStateLogMessageId = "WOUGN0600002004";
    protected String timeoutLogMessageId = "WOUGN0600002005";
    protected String protocolErrorLogMessageId = "WOUGN0600002006";
    protected String ioErrorLogMessageId = "WOUGN0600002007";
    protected boolean isOutputEOFLogMessage;
    protected boolean isOutputErrorStateLogMessage;
    protected boolean isOutputNormalStateLogMessage;
    protected boolean isOutputTimeoutLogMessage;
    protected boolean isOutputProtocolErrorLogMessage;
    protected boolean isOutputIOErrorLogMessage;
    protected List keepAliveListeners;
    protected boolean isAliveCheckSMTPServer;
    protected boolean isAliveSMTPServer;
    protected long aliveCheckSMTPServerInterval = 60000L;
    protected Daemon daemon;
    protected boolean isLoggingDeadSMTPServer = true;
    protected boolean isLoggingRecoverSMTPServer = true;
    protected String deadSMTPServerLogMessageId = "SMTP_00001";
    protected String recoverSMTPServerLogMessageId = "SMTP_00002";

    @Override
    public void setHostName(String hostName) throws UnknownHostException {
        this.mHostName = hostName;
        this.mIp = InetAddress.getByName(hostName);
    }

    @Override
    public String getHostName() {
        return this.mHostName;
    }

    @Override
    public void setPort(int port) {
        this.mPort = port;
    }

    @Override
    public int getPort() {
        return this.mPort;
    }

    @Override
    public void setConnectionTimeoutMillis(int milisec) {
        this.mConnectionTimeOut = milisec;
    }

    @Override
    public int getConnectionTimeoutMillis() {
        return this.mConnectionTimeOut;
    }

    @Override
    public void setTimeoutMillis(int milisec) {
        this.mTimeOut = milisec;
    }

    @Override
    public int getTimeoutMillis() {
        return this.mTimeOut;
    }

    @Override
    public void setEOFLogMessageId(String id) {
        this.eofLogMessageId = id;
    }

    @Override
    public String getEOFLogMessageId() {
        return this.eofLogMessageId;
    }

    @Override
    public void setErrorStateLogMessageId(String id) {
        this.errorStateLogMessageId = id;
    }

    @Override
    public String getErrorStateLogMessageId() {
        return this.errorStateLogMessageId;
    }

    @Override
    public void setNormalStateLogMessageId(String id) {
        this.normalStateLogMessageId = id;
    }

    @Override
    public String getNormalStateLogMessageId() {
        return this.normalStateLogMessageId;
    }

    @Override
    public void setTimeoutLogMessageId(String id) {
        this.timeoutLogMessageId = id;
    }

    @Override
    public String getTimeoutLogMessageId() {
        return this.timeoutLogMessageId;
    }

    @Override
    public void setProtocolErrorLogMessageId(String id) {
        this.protocolErrorLogMessageId = id;
    }

    @Override
    public String getProtocolErrorLogMessageId() {
        return this.protocolErrorLogMessageId;
    }

    @Override
    public void setIOErrorLogMessageId(String id) {
        this.ioErrorLogMessageId = id;
    }

    @Override
    public String getIOErrorLogMessageId() {
        return this.ioErrorLogMessageId;
    }

    @Override
    public void setOutputEOFLogMessage(boolean isOutput) {
        this.isOutputEOFLogMessage = isOutput;
    }

    @Override
    public boolean isOutputEOFLogMessage() {
        return this.isOutputEOFLogMessage;
    }

    @Override
    public void setOutputErrorStateLogMessage(boolean isOutput) {
        this.isOutputErrorStateLogMessage = isOutput;
    }

    @Override
    public boolean isOutputErrorStateLogMessage() {
        return this.isOutputErrorStateLogMessage;
    }

    @Override
    public void setOutputNormalStateLogMessage(boolean isOutput) {
        this.isOutputNormalStateLogMessage = isOutput;
    }

    @Override
    public boolean isOutputNormalStateLogMessage() {
        return this.isOutputNormalStateLogMessage;
    }

    @Override
    public void setOutputTimeoutLogMessage(boolean isOutput) {
        this.isOutputTimeoutLogMessage = isOutput;
    }

    @Override
    public boolean isOutputTimeoutLogMessage() {
        return this.isOutputTimeoutLogMessage;
    }

    @Override
    public void setOutputProtocolErrorLogMessage(boolean isOutput) {
        this.isOutputProtocolErrorLogMessage = isOutput;
    }

    @Override
    public boolean isOutputProtocolErrorLogMessage() {
        return this.isOutputProtocolErrorLogMessage;
    }

    @Override
    public void setOutputIOErrorLogMessage(boolean isOutput) {
        this.isOutputIOErrorLogMessage = isOutput;
    }

    @Override
    public boolean isOutputIOErrorLogMessage() {
        return this.isOutputIOErrorLogMessage;
    }

    @Override
    public void setLoggingDeadSMTPServer(boolean isOutput) {
        this.isLoggingDeadSMTPServer = isOutput;
    }

    @Override
    public boolean isLoggingDeadSMTPServer() {
        return this.isLoggingDeadSMTPServer;
    }

    @Override
    public void setLoggingRecoverSMTPServer(boolean isOutput) {
        this.isLoggingRecoverSMTPServer = isOutput;
    }

    @Override
    public boolean isLoggingRecoverSMTPServer() {
        return this.isLoggingRecoverSMTPServer;
    }

    @Override
    public void setDeadSMTPServerLogMessageId(String id) {
        this.deadSMTPServerLogMessageId = id;
    }

    @Override
    public String getDeadSMTPServerLogMessageId() {
        return this.deadSMTPServerLogMessageId;
    }

    @Override
    public void setRecoverSMTPServerLogMessageId(String id) {
        this.recoverSMTPServerLogMessageId = id;
    }

    @Override
    public String getRecoverSMTPServerLogMessageId() {
        return this.recoverSMTPServerLogMessageId;
    }

    @Override
    public void setAliveCheckSMTPServer(boolean isCheck) {
        this.isAliveCheckSMTPServer = isCheck;
        if (isCheck && this.getState() == 3 && !this.daemon.isRunning()) {
            this.daemon.start();
        }
    }

    @Override
    public boolean isAliveCheckSMTPServer() {
        return this.isAliveCheckSMTPServer;
    }

    @Override
    public void setAliveCheckSMTPServerInterval(long interval) {
        this.aliveCheckSMTPServerInterval = interval;
    }

    @Override
    public long getAliveCheckSMTPServerInterval() {
        return this.aliveCheckSMTPServerInterval;
    }

    @Override
    public boolean isAliveSMTPServer() {
        if (this.getState() != 3) {
            return false;
        }
        if (this.isAliveCheckSMTPServer) {
            return this.isAliveSMTPServer;
        }
        return this.isAlive();
    }

    @Override
    public String getHostIp() {
        return this.mIp == null ? null : this.mIp.getHostAddress();
    }

    @Override
    public int getHostPort() {
        return this.mPort;
    }

    @Override
    public void createService() throws Exception {
        this.keepAliveListeners = new ArrayList();
        this.daemon = new Daemon(this);
        this.daemon.setName("Nimbus SMTPCheckDaemon " + this.getServiceNameObject());
    }

    @Override
    public void startService() throws Exception {
        this.isAliveSMTPServer = this.isAlive();
        if (this.isAliveCheckSMTPServer) {
            this.daemon.start();
        }
    }

    @Override
    public void stopService() throws Exception {
        this.daemon.stop();
    }

    @Override
    public void destroyService() throws Exception {
        this.keepAliveListeners = null;
    }

    @Override
    public boolean isAlive() {
        return this.isAliveInternal() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object isAliveInternal() {
        Object ret = null;
        Socket sock = null;
        try {
            int len = 1024;
            sock = new Socket();
            sock.connect(new InetSocketAddress(this.mIp, this.mPort), this.mConnectionTimeOut);
            BufferedInputStream in = new BufferedInputStream(sock.getInputStream(), 1024);
            BufferedOutputStream out = new BufferedOutputStream(sock.getOutputStream(), 1024);
            out.write(C_HELLOW.getBytes(), 0, C_HELLOW.getBytes().length);
            out.flush();
            sock.setSoTimeout(this.mTimeOut);
            byte[] resBuf = new byte[1024];
            int readLen = in.read(resBuf, 0, 1024);
            if (readLen == -1) {
                if (this.isOutputEOFLogMessage) {
                    this.getLogger().write(this.eofLogMessageId, (Object)this.getSMTPServerInfo());
                }
                ret = "Response reading detect EOF.";
            } else {
                String retCode = new String(resBuf, 0, readLen);
                if (!retCode.startsWith(C_WRONG_SIGN)) {
                    if (this.isOutputErrorStateLogMessage) {
                        Object[] wd = new String[]{this.getSMTPServerInfo(), retCode};
                        this.getLogger().write(this.errorStateLogMessageId, wd);
                    }
                    ret = "Return code is : " + retCode;
                } else if (this.isOutputNormalStateLogMessage) {
                    this.getLogger().write(this.normalStateLogMessageId, (Object)this.getSMTPServerInfo());
                }
                out.write(C_QUITE.getBytes(), 0, C_QUITE.getBytes().length);
                out.flush();
            }
        }
        catch (InterruptedIOException e) {
            if (this.isOutputTimeoutLogMessage) {
                this.getLogger().write(this.timeoutLogMessageId, (Object)this.getSMTPServerInfo());
            }
            ret = e;
        }
        catch (SocketException e) {
            if (this.isOutputProtocolErrorLogMessage) {
                this.getLogger().write(this.protocolErrorLogMessageId, (Object)this.getSMTPServerInfo(), (Throwable)e);
            }
            ret = e;
        }
        catch (IOException e) {
            if (this.isOutputIOErrorLogMessage) {
                this.getLogger().write(this.ioErrorLogMessageId, (Object)this.getSMTPServerInfo(), (Throwable)e);
            }
            ret = e;
        }
        finally {
            try {
                if (sock != null) {
                    sock.close();
                }
            }
            catch (IOException ex) {
                if (this.isOutputIOErrorLogMessage) {
                    this.getLogger().write(this.ioErrorLogMessageId, (Object)this.getSMTPServerInfo(), (Throwable)ex);
                }
                ret = ex;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKeepAliveListener(KeepAliveListener listener) {
        List list = this.keepAliveListeners;
        synchronized (list) {
            this.keepAliveListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeKeepAliveListener(KeepAliveListener listener) {
        List list = this.keepAliveListeners;
        synchronized (list) {
            this.keepAliveListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearKeepAliveListener() {
        List list = this.keepAliveListeners;
        synchronized (list) {
            this.keepAliveListeners.clear();
        }
    }

    @Override
    public boolean onStart() {
        return true;
    }

    @Override
    public boolean onStop() {
        return true;
    }

    @Override
    public boolean onSuspend() {
        return true;
    }

    @Override
    public boolean onResume() {
        return true;
    }

    @Override
    public Object provide(DaemonControl ctrl) {
        try {
            Thread.sleep(this.aliveCheckSMTPServerInterval);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        return this.isAliveInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(Object lookupedObj, DaemonControl ctrl) {
        if (!this.isAliveCheckSMTPServer) {
            return;
        }
        if (this.isAliveSMTPServer) {
            if (lookupedObj != null) {
                this.isAliveSMTPServer = false;
                List list = this.keepAliveListeners;
                synchronized (list) {
                    for (KeepAliveListener keepAliveListener : this.keepAliveListeners) {
                        keepAliveListener.onDead(this);
                    }
                }
                if (this.isLoggingDeadSMTPServer) {
                    if (lookupedObj instanceof Throwable) {
                        this.getLogger().write(this.deadSMTPServerLogMessageId, new Object[]{this.getSMTPServerInfo(), ((Throwable)lookupedObj).getMessage()}, (Throwable)lookupedObj);
                    } else {
                        this.getLogger().write(this.deadSMTPServerLogMessageId, new Object[]{this.getSMTPServerInfo(), lookupedObj});
                    }
                }
            }
        } else if (lookupedObj == null) {
            this.isAliveSMTPServer = true;
            List list = this.keepAliveListeners;
            synchronized (list) {
                for (KeepAliveListener keepAliveListener : this.keepAliveListeners) {
                    keepAliveListener.onRecover(this);
                }
            }
            if (this.isLoggingRecoverSMTPServer) {
                this.getLogger().write(this.recoverSMTPServerLogMessageId, (Object)this.getSMTPServerInfo());
            }
        }
    }

    protected String getSMTPServerInfo() {
        return this.getHostName() + ':' + this.getHostPort();
    }

    @Override
    public void garbage() {
    }
}

