/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editorfinder;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.journal.editorfinder.RegexClassMappedEditorFinderServiceMBean;

public class RegexClassMappedEditorFinderService
extends ServiceBase
implements EditorFinder,
RegexClassMappedEditorFinderServiceMBean {
    private static final long serialVersionUID = 8606953387609440972L;
    private ServiceName parentEditorfinderServiceName;
    private EditorFinder parentEditorfinder;
    private Map editorMapping;
    private Map editorRegexMapping;
    private Map namePatternMapping;

    @Override
    public void setParentEditorfinderServiceName(ServiceName name) {
        this.parentEditorfinderServiceName = name;
    }

    @Override
    public ServiceName getParentEditorfinderServiceName() {
        return this.parentEditorfinderServiceName;
    }

    @Override
    public void setEditorMapping(Map map) {
        this.editorMapping = map;
    }

    @Override
    public Map getEditorMapping() {
        return this.editorMapping;
    }

    @Override
    public void createService() throws Exception {
        this.editorRegexMapping = new HashMap();
        this.namePatternMapping = new LinkedHashMap();
    }

    public void setEditorfinder(EditorFinder parentEditorfinder) {
        this.parentEditorfinder = parentEditorfinder;
    }

    @Override
    public void startService() throws Exception {
        if (this.parentEditorfinderServiceName != null) {
            this.parentEditorfinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.parentEditorfinderServiceName);
        }
        if (this.editorMapping == null) {
            throw new IllegalArgumentException("editorMapping must be specified.");
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setServiceManagerName(this.getServiceManagerName());
        for (String keyStr : this.editorMapping.keySet()) {
            String key = null;
            String className = null;
            int index = keyStr.indexOf(44);
            if (index == -1) {
                className = keyStr;
            } else {
                className = keyStr.substring(0, index);
                if (index != keyStr.length() - 1) {
                    key = keyStr.substring(index + 1);
                }
            }
            Object value = this.editorMapping.get(keyStr);
            JournalEditor journalEditor = null;
            if (value instanceof String) {
                String nameStr = (String)value;
                editor.setAsText(nameStr);
                ServiceName name = (ServiceName)editor.getValue();
                journalEditor = (JournalEditor)ServiceManagerFactory.getServiceObject(name);
            } else if (value instanceof JournalEditor) {
                journalEditor = (JournalEditor)value;
            }
            Pattern classNamePattern = Pattern.compile(className);
            this.namePatternMapping.put(className, classNamePattern);
            HashMap<String, JournalEditor> keyEditorMap = (HashMap<String, JournalEditor>)this.editorRegexMapping.get(className);
            if (keyEditorMap == null) {
                keyEditorMap = new HashMap<String, JournalEditor>();
                this.editorRegexMapping.put(className, keyEditorMap);
            }
            keyEditorMap.put(key, journalEditor);
        }
    }

    @Override
    public void stopService() throws Exception {
        this.editorRegexMapping.clear();
        this.namePatternMapping.clear();
    }

    @Override
    public void destroyService() throws Exception {
        this.editorRegexMapping = null;
        this.namePatternMapping = null;
    }

    @Override
    public JournalEditor findEditor(Class clazz) {
        return this.findEditor(null, clazz);
    }

    @Override
    public JournalEditor findEditor(Object key, Class clazz) {
        JournalEditor editor = this.findEditor(key, clazz.getName());
        if (editor == null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                editor = this.findEditor(key, interfaces[i]);
                if (editor == null) continue;
                return editor;
            }
        }
        if (editor == null) {
            Class tmpClass = clazz;
            while ((tmpClass = tmpClass.getSuperclass()) != null) {
                editor = this.findEditor(key, tmpClass);
                if (editor == null) continue;
                return editor;
            }
        }
        if (editor == null && this.parentEditorfinder != null) {
            editor = this.parentEditorfinder.findEditor(key, clazz);
        }
        return editor;
    }

    private JournalEditor findEditor(Object key, String className) {
        for (Map.Entry entry : this.namePatternMapping.entrySet()) {
            String name = (String)entry.getKey();
            Pattern pattern = (Pattern)entry.getValue();
            Matcher matcher = pattern.matcher(className);
            if (!matcher.matches()) continue;
            Map keyEditorMap = (Map)this.editorRegexMapping.get(name);
            JournalEditor editor = (JournalEditor)keyEditorMap.get(key);
            if (editor == null && key != null) {
                editor = (JournalEditor)keyEditorMap.get(null);
            }
            return editor;
        }
        return null;
    }

    @Override
    public JournalEditor findEditor(Object obj) {
        return this.findEditor(null, obj);
    }

    @Override
    public JournalEditor findEditor(Object key, Object obj) {
        JournalEditor editor = null;
        if (this.parentEditorfinder != null) {
            editor = this.parentEditorfinder.findEditor(key, obj);
        }
        if (editor == null) {
            if (obj == null) {
                return null;
            }
            return this.findEditor(key, obj.getClass());
        }
        return editor;
    }
}

