/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import javax.servlet.ServletResponse;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.ServletResponseJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class ServletResponseJournalEditorService
extends BlockJournalEditorServiceBase
implements ServletResponseJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = -540346255624096477L;
    private static final String BUFFER_SIZE_HEADER = "Buffer Size : ";
    private static final String CHARACTER_ENCODING_HEADER = "Character Encoding : ";
    private static final String CONTENT_TYPE_HEADER = "Content Type : ";
    private static final String LOCALE_HEADER = "Locale : ";
    private static final String IS_COMMITTED_HEADER = "Is Committed : ";
    private static final String HEADER = "[ServletResponse]";
    private boolean isOutputBufferSize = true;
    private boolean isOutputCharacterEncoding = true;
    private boolean isOutputContentType = true;
    private boolean isOutputLocale = true;
    private boolean isOutputIsCommitted = true;

    public ServletResponseJournalEditorService() {
        this.setHeader(HEADER);
    }

    @Override
    public void setOutputBufferSize(boolean isOutput) {
        this.isOutputBufferSize = isOutput;
    }

    @Override
    public boolean isOutputBufferSize() {
        return this.isOutputBufferSize;
    }

    @Override
    public void setOutputCharacterEncoding(boolean isOutput) {
        this.isOutputCharacterEncoding = isOutput;
    }

    @Override
    public boolean isOutputCharacterEncoding() {
        return this.isOutputCharacterEncoding;
    }

    @Override
    public void setOutputContentType(boolean isOutput) {
        this.isOutputContentType = isOutput;
    }

    @Override
    public boolean isOutputContentType() {
        return this.isOutputContentType;
    }

    @Override
    public void setOutputLocale(boolean isOutput) {
        this.isOutputLocale = isOutput;
    }

    @Override
    public boolean isOutputLocale() {
        return this.isOutputLocale;
    }

    @Override
    public void setOutputIsCommitted(boolean isOutput) {
        this.isOutputIsCommitted = isOutput;
    }

    @Override
    public boolean isOutputIsCommitted() {
        return this.isOutputIsCommitted;
    }

    @Override
    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        ServletResponse response = (ServletResponse)value;
        boolean isMake = false;
        if (this.isOutputBufferSize()) {
            this.makeBufferSizeFormat(finder, key, response, buf);
            isMake = true;
        }
        if (this.isOutputCharacterEncoding()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeCharacterEncodingFormat(finder, key, response, buf);
            isMake = true;
        }
        if (this.isOutputContentType()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeContentTypeFormat(finder, key, response, buf);
            isMake = true;
        }
        if (this.isOutputLocale()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeLocaleFormat(finder, key, response, buf);
            isMake = true;
        }
        if (this.isOutputIsCommitted()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeIsCommittedFormat(finder, key, response, buf);
            isMake = true;
        }
        return isMake;
    }

    protected StringBuffer makeBufferSizeFormat(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
        return buf.append(BUFFER_SIZE_HEADER).append(response.getBufferSize());
    }

    protected StringBuffer makeCharacterEncodingFormat(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
        return buf.append(CHARACTER_ENCODING_HEADER).append(response.getCharacterEncoding());
    }

    protected StringBuffer makeContentTypeFormat(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
        try {
            return buf.append(CONTENT_TYPE_HEADER).append(response.getContentType());
        }
        catch (NoSuchMethodError e) {
            return buf;
        }
    }

    protected StringBuffer makeLocaleFormat(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
        buf.append(LOCALE_HEADER);
        this.makeObjectFormat(finder, null, response.getLocale(), buf);
        return buf;
    }

    protected StringBuffer makeIsCommittedFormat(EditorFinder finder, Object key, ServletResponse response, StringBuffer buf) {
        return buf.append(IS_COMMITTED_HEADER).append(response.isCommitted());
    }
}

