/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.service.journal.editor.BeanJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.util.ClassMappingTree;

public class BeanJournalEditorService
extends BlockJournalEditorServiceBase
implements BeanJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 2608759992280175186L;
    protected static final String DEFAULT_SECRET_STRING = "******";
    private boolean isOutputPropertyType = true;
    protected String secretString = "******";
    protected String[] secretProperties;
    protected ClassMappingTree secretPropertyMap;
    protected String[] enabledProperties;
    protected ClassMappingTree enabledPropertyMap;
    protected String propertyTypeStartDelimiter = "[";
    protected String propertyTypeEndDelimiter = "]";
    protected String propertyNameValueDelimiter = "=";
    protected String startValueDelimiter;
    protected String endValueDelimiter;
    protected String propertyDelimiter;

    @Override
    public void setOutputPropertyType(boolean isOutput) {
        this.isOutputPropertyType = isOutput;
    }

    @Override
    public boolean isOutputPropertyType() {
        return this.isOutputPropertyType;
    }

    @Override
    public void setSecretString(String str) {
        this.secretString = str;
    }

    @Override
    public String getSecretString() {
        return this.secretString;
    }

    @Override
    public void setSecretProperties(String[] names) {
        this.secretProperties = names;
    }

    @Override
    public String[] getSecretProperties() {
        return this.secretProperties;
    }

    @Override
    public void setEnabledProperties(String[] names) {
        this.enabledProperties = names;
    }

    @Override
    public String[] getEnabledProperties() {
        return this.enabledProperties;
    }

    @Override
    public void setPropertyTypeStartDelimiter(String delimiter) {
        this.propertyTypeStartDelimiter = delimiter;
    }

    @Override
    public String getPropertyTypeStartDelimiter() {
        return this.propertyTypeStartDelimiter;
    }

    @Override
    public void setPropertyTypeEndDelimiter(String delimiter) {
        this.propertyTypeEndDelimiter = delimiter;
    }

    @Override
    public String getPropertyTypeEndDelimiter() {
        return this.propertyTypeEndDelimiter;
    }

    @Override
    public void setPropertyNameValueDelimiter(String delimiter) {
        this.propertyNameValueDelimiter = delimiter;
    }

    @Override
    public String getPropertyNameValueDelimiter() {
        return this.propertyNameValueDelimiter;
    }

    @Override
    public void setStartValueDelimiter(String delim) {
        this.startValueDelimiter = delim;
    }

    @Override
    public String getStartValueDelimiter() {
        return this.startValueDelimiter;
    }

    @Override
    public void setEndValueDelimiter(String delim) {
        this.endValueDelimiter = delim;
    }

    @Override
    public String getEndValueDelimiter() {
        return this.endValueDelimiter;
    }

    @Override
    public void setPropertyDelimiter(String delim) {
        this.propertyDelimiter = delim;
    }

    @Override
    public String getPropertyDelimiter() {
        return this.propertyDelimiter;
    }

    @Override
    public void createService() throws Exception {
        this.secretPropertyMap = new ClassMappingTree();
        this.enabledPropertyMap = new ClassMappingTree();
    }

    @Override
    public void startService() throws Exception {
        String className;
        String propName;
        Class clazz;
        int index;
        int i;
        if (this.secretProperties != null) {
            for (i = 0; i < this.secretProperties.length; ++i) {
                index = this.secretProperties[i].indexOf(35);
                clazz = Object.class;
                propName = null;
                if (index == -1) {
                    propName = this.secretProperties[i];
                } else {
                    className = this.secretProperties[i].substring(0, index);
                    clazz = Class.forName(className, true, NimbusClassLoader.getInstance());
                    propName = this.secretProperties[i].substring(index + 1);
                }
                this.secretPropertyMap.add(clazz, propName.toUpperCase());
            }
        }
        if (this.enabledProperties != null) {
            for (i = 0; i < this.enabledProperties.length; ++i) {
                index = this.enabledProperties[i].indexOf(35);
                clazz = Object.class;
                propName = null;
                if (index == -1) {
                    propName = this.enabledProperties[i];
                } else {
                    className = this.enabledProperties[i].substring(0, index);
                    clazz = Class.forName(className, true, NimbusClassLoader.getInstance());
                    propName = this.enabledProperties[i].substring(index + 1);
                }
                this.enabledPropertyMap.add(clazz, propName.toUpperCase());
            }
        }
    }

    @Override
    protected void startBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        if (this.isOutputHeader() && value != null) {
            buf.append('[').append(value.getClass().getName()).append(']');
        }
        buf.append(this.getStartBlockSeparator());
    }

    @Override
    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        if (value == null) {
            return false;
        }
        SimpleProperty[] props = SimpleProperty.getProperties(value);
        if (props == null || props.length == 0) {
            return false;
        }
        ArrayList<SimpleProperty> readProps = new ArrayList<SimpleProperty>();
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].isReadable(value)) continue;
            readProps.add(props[i]);
        }
        if (readProps.size() == 0) {
            return false;
        }
        Class<?> clazz = value.getClass();
        boolean isOutput = false;
        int max = readProps.size();
        for (int i = 0; i < max; ++i) {
            Property prop = (Property)readProps.get(i);
            if (!this.enabledPropertyMap.getValueList(clazz).contains(prop.getPropertyName().toUpperCase())) continue;
            if (isOutput) {
                if (this.getPropertyDelimiter() == null) {
                    buf.append(this.getLineSeparator());
                } else {
                    buf.append(this.getPropertyDelimiter());
                }
            }
            buf.append(prop.getPropertyName());
            if (this.isOutputPropertyType) {
                buf.append(this.getPropertyTypeStartDelimiter());
                try {
                    this.makeObjectFormat(finder, null, prop.getPropertyType(value), buf);
                }
                catch (NoSuchPropertyException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
                buf.append(this.getPropertyTypeEndDelimiter());
            }
            buf.append(this.getPropertyNameValueDelimiter());
            if (this.secretPropertyMap.getValueList(clazz).contains(prop.getPropertyName().toUpperCase())) {
                if (this.getStartValueDelimiter() != null) {
                    buf.append(this.getStartValueDelimiter());
                }
                buf.append(this.getSecretString());
                if (this.getEndValueDelimiter() != null) {
                    buf.append(this.getEndValueDelimiter());
                }
            } else {
                try {
                    Object val = prop.getProperty(value);
                    if (val != null && this.getStartValueDelimiter() != null) {
                        buf.append(this.getStartValueDelimiter());
                    }
                    this.makeObjectFormat(finder, null, val, buf);
                    if (val != null && this.getEndValueDelimiter() != null) {
                        buf.append(this.getEndValueDelimiter());
                    }
                }
                catch (NoSuchPropertyException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
            isOutput = true;
        }
        return true;
    }
}

