/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import java.util.HashSet;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionFactory;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import jp.ossc.nimbus.service.jms.ReconnectableConnectionConsumer;
import jp.ossc.nimbus.service.jms.ReconnectableQueueSession;
import jp.ossc.nimbus.service.jms.ReconnectableSession;
import jp.ossc.nimbus.service.jms.ReconnectableTopicSession;
import jp.ossc.nimbus.service.keepalive.KeepAliveChecker;
import jp.ossc.nimbus.service.keepalive.KeepAliveListener;
import jp.ossc.nimbus.service.log.Logger;

public class ReconnectableConnection
implements XAQueueConnection,
XATopicConnection,
KeepAliveListener,
ExceptionListener {
    public static int RECONNECT_MODE_ON_RECOVER = 1;
    public static int RECONNECT_MODE_ON_DEAD = 2;
    protected ConnectionFactory connectionFactory;
    protected String userName;
    protected String password;
    protected Connection connection;
    protected boolean isStart;
    protected boolean isClose;
    protected Set sessions;
    protected Set connectionConsumers;
    protected KeepAliveChecker keepAliveChecker;
    protected Logger logger;
    protected String reconnectErrorLogMessageId;
    protected int reconnectMode = RECONNECT_MODE_ON_RECOVER;
    protected boolean isReconnecting = false;
    protected ExceptionListener exceptionListener;
    protected int reconnectMaxRetryCount;
    protected long reconnectRetryInterval = 1000L;

    public ReconnectableConnection(ConnectionFactory factory) throws JMSException {
        this.connectionFactory = factory;
        this.connection = this.createConnection();
    }

    public ReconnectableConnection(ConnectionFactory factory, String userName, String password) throws JMSException {
        this.connectionFactory = factory;
        this.userName = userName;
        this.password = password;
        this.connection = this.createConnection(userName, password);
    }

    public void setKeepAliveChecker(KeepAliveChecker checker) {
        this.keepAliveChecker = checker;
        this.keepAliveChecker.addKeepAliveListener(this);
    }

    public void setReconnectMode(int mode) {
        this.reconnectMode = mode;
    }

    public void setReconnectMaxRetryCount(int count) {
        this.reconnectMaxRetryCount = count;
    }

    public void setReconnectRetryInterval(long interval) {
        this.reconnectRetryInterval = interval;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setReconnectErrorLogMessageId(String id) {
        this.reconnectErrorLogMessageId = id;
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected Connection createConnection() throws JMSException {
        Connection con = this.connectionFactory.createConnection();
        if (con != null) {
            con.setExceptionListener((ExceptionListener)this);
        }
        return con;
    }

    protected Connection createConnection(String userName, String password) throws JMSException {
        Connection con = this.connectionFactory.createConnection(userName, password);
        if (con != null) {
            con.setExceptionListener((ExceptionListener)this);
        }
        return con;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        ReconnectableSession session = new ReconnectableSession(this, transacted, acknowledgeMode);
        this.addSession((Session)session);
        return session;
    }

    public XASession createXASession() throws JMSException {
        ReconnectableSession session = new ReconnectableSession(this);
        this.addSession((Session)session);
        return session;
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.connection.createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages);
    }

    public String getClientID() throws JMSException {
        return this.connection.getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        this.connection.setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.connection.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.exceptionListener = listener;
    }

    public void start() throws JMSException {
        this.connection.start();
        this.isStart = true;
    }

    public void stop() throws JMSException {
        this.isStart = false;
        this.connection.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        Set set;
        this.isClose = true;
        if (this.sessions != null) {
            set = this.sessions;
            synchronized (set) {
                this.sessions = null;
            }
        }
        if (this.connectionConsumers != null) {
            set = this.connectionConsumers;
            synchronized (set) {
                this.connectionConsumers = null;
            }
        }
        this.keepAliveChecker.removeKeepAliveListener(this);
        this.connection.close();
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        ReconnectableQueueSession session = new ReconnectableQueueSession(this, transacted, acknowledgeMode);
        this.addSession((Session)session);
        return session;
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        ReconnectableQueueSession session = new ReconnectableQueueSession(this);
        this.addSession((Session)session);
        return session;
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        ReconnectableConnectionConsumer consumer = new ReconnectableConnectionConsumer(this, (Destination)queue, messageSelector, sessionPool, maxMessages);
        this.addConnectionConsumer(consumer);
        return consumer;
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        ReconnectableTopicSession session = new ReconnectableTopicSession(this, transacted, acknowledgeMode);
        this.addSession((Session)session);
        return session;
    }

    public XATopicSession createXATopicSession() throws JMSException {
        ReconnectableTopicSession session = new ReconnectableTopicSession(this);
        this.addSession((Session)session);
        return session;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        ReconnectableConnectionConsumer consumer = new ReconnectableConnectionConsumer(this, (Destination)topic, messageSelector, sessionPool, maxMessages);
        this.addConnectionConsumer(consumer);
        return consumer;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        ReconnectableConnectionConsumer consumer = new ReconnectableConnectionConsumer(this, topic, subscriptionName, messageSelector, sessionPool, maxMessages);
        this.addConnectionConsumer(consumer);
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() throws JMSException {
        if (this.isClose || this.isReconnecting) {
            return;
        }
        this.isReconnecting = true;
        try {
            int tryCount = 0;
            while (true) {
                ++tryCount;
                try {
                    Set set;
                    try {
                        this.connection.stop();
                    }
                    catch (JMSException e) {
                        // empty catch block
                    }
                    try {
                        this.connection.close();
                    }
                    catch (JMSException e) {
                        // empty catch block
                    }
                    Connection newConnection = null;
                    newConnection = this.userName == null && this.password == null ? this.createConnection() : this.createConnection(this.userName, this.password);
                    if (this.isStart) {
                        newConnection.start();
                    }
                    this.connection = newConnection;
                    if (this.sessions != null) {
                        set = this.sessions;
                        synchronized (set) {
                            if (this.sessions != null) {
                                for (ReconnectableSession session : this.sessions) {
                                    session.reconnect();
                                }
                            }
                        }
                    }
                    if (this.connectionConsumers == null) break;
                    set = this.connectionConsumers;
                    synchronized (set) {
                        if (this.connectionConsumers != null) {
                            for (ReconnectableConnectionConsumer connectionConsumer : this.connectionConsumers) {
                                connectionConsumer.reconnect();
                            }
                        }
                    }
                }
                catch (JMSException e) {
                    if (tryCount > this.reconnectMaxRetryCount) {
                        throw e;
                    }
                    try {
                        Thread.sleep(this.reconnectRetryInterval);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
        finally {
            this.isReconnecting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSession(Session session) {
        if (this.sessions == null) {
            this.sessions = new HashSet();
        }
        Set set = this.sessions;
        synchronized (set) {
            if (this.sessions != null) {
                this.sessions.add(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(Session session) {
        if (this.sessions == null) {
            return;
        }
        Set set = this.sessions;
        synchronized (set) {
            if (this.sessions != null) {
                this.sessions.remove(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnectionConsumer(ConnectionConsumer consumer) {
        if (this.connectionConsumers == null) {
            this.connectionConsumers = new HashSet();
        }
        Set set = this.connectionConsumers;
        synchronized (set) {
            if (this.connectionConsumers != null) {
                this.connectionConsumers.add(consumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionConsumer(ConnectionConsumer consumer) {
        if (this.connectionConsumers == null) {
            return;
        }
        Set set = this.connectionConsumers;
        synchronized (set) {
            if (this.connectionConsumers != null) {
                this.connectionConsumers.remove(consumer);
            }
        }
    }

    @Override
    public void onDead(KeepAliveChecker checker) {
        block3: {
            if (this.reconnectMode == RECONNECT_MODE_ON_DEAD) {
                try {
                    this.reconnect();
                }
                catch (JMSException e) {
                    if (this.logger == null || this.reconnectErrorLogMessageId == null) break block3;
                    this.logger.write(this.reconnectErrorLogMessageId, e);
                }
            }
        }
    }

    @Override
    public void onRecover(KeepAliveChecker checker) {
        block3: {
            if (this.reconnectMode == RECONNECT_MODE_ON_RECOVER) {
                try {
                    this.reconnect();
                }
                catch (JMSException e) {
                    if (this.logger == null || this.reconnectErrorLogMessageId == null) break block3;
                    this.logger.write(this.reconnectErrorLogMessageId, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException exception) {
        try {
            if (this.exceptionListener != null) {
                this.exceptionListener.onException(exception);
            }
        }
        finally {
            block10: {
                if (!this.isReconnecting) {
                    try {
                        this.reconnect();
                    }
                    catch (JMSException e) {
                        if (this.logger == null || this.reconnectErrorLogMessageId == null) break block10;
                        this.logger.write(this.reconnectErrorLogMessageId, e);
                    }
                }
            }
        }
    }
}

