/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.graph.AbstractTickUnitAdjusterServiceMBean;
import jp.ossc.nimbus.service.graph.TickUnitAdjustCommonDivisorMap;
import jp.ossc.nimbus.service.graph.TickUnitAdjuster;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;

public abstract class AbstractTickUnitAdjusterService
extends ServiceBase
implements TickUnitAdjuster,
AbstractTickUnitAdjusterServiceMBean {
    private static final long serialVersionUID = 4013207082825995188L;
    protected int displayGraduationCount;
    protected double unitCountCommonDivisor = Double.NaN;
    protected boolean isDomain;
    protected int axisIndex = -1;
    protected ServiceName tickUnitAdjustCommonDivisorMapServiceName;
    protected TickUnitAdjustCommonDivisorMap tickUnitAdjustCommonDivisorMap;
    protected boolean autoRangeMinimumSizeEnabled;

    @Override
    public void setDisplayGraduationCount(int count) {
        this.displayGraduationCount = count;
    }

    @Override
    public int getDisplayGraduationCount() {
        return this.displayGraduationCount;
    }

    @Override
    public void setUnitCountCommonDivisor(double divisor) {
        this.unitCountCommonDivisor = divisor;
    }

    @Override
    public double getUnitCountCommonDivisor() {
        return this.unitCountCommonDivisor;
    }

    @Override
    public void setDomain(boolean isDomain) {
        this.isDomain = isDomain;
    }

    @Override
    public boolean isDomain() {
        return this.isDomain;
    }

    @Override
    public void setAxisIndex(int index) {
        this.axisIndex = index;
    }

    @Override
    public int getAxisIndex() {
        return this.axisIndex;
    }

    @Override
    public void setAutoRangeMinimumSizeEnabled(boolean enabled) {
        this.autoRangeMinimumSizeEnabled = enabled;
    }

    @Override
    public boolean getAutoRangeMinimumSizeEnabled() {
        return this.autoRangeMinimumSizeEnabled;
    }

    @Override
    public void setTickUnitAdjustCommonDivisorMapServiceName(ServiceName serviceName) {
        this.tickUnitAdjustCommonDivisorMapServiceName = serviceName;
    }

    @Override
    public ServiceName getTickUnitAdjustCommonDivisorMapServiceName() {
        return this.tickUnitAdjustCommonDivisorMapServiceName;
    }

    @Override
    public void createService() throws Exception {
    }

    @Override
    public void startService() throws Exception {
        if (this.displayGraduationCount <= 0) {
            throw new IllegalArgumentException("displayGraduationCount must be specified.");
        }
        if (this.axisIndex < 0) {
            throw new IllegalArgumentException("axisIndex must be specified.");
        }
        if (this.tickUnitAdjustCommonDivisorMapServiceName != null) {
            this.tickUnitAdjustCommonDivisorMap = (TickUnitAdjustCommonDivisorMap)ServiceManagerFactory.getServiceObject(this.tickUnitAdjustCommonDivisorMapServiceName);
        }
    }

    @Override
    public void stopService() throws Exception {
    }

    @Override
    public void destroyService() throws Exception {
    }

    @Override
    public void adjust(XYPlot xyPlot) {
        ValueAxis axis = null;
        axis = this.isDomain() ? xyPlot.getDomainAxis(this.getAxisIndex()) : xyPlot.getRangeAxis(this.getAxisIndex());
        this.adjust(axis);
    }

    protected double adjustUnitCountByCommonDivisor(ValueAxis axis, double unitCount) {
        double commonDivisor = this.unitCountCommonDivisor;
        if (this.tickUnitAdjustCommonDivisorMap != null) {
            commonDivisor = this.tickUnitAdjustCommonDivisorMap.getCommonDivisor(axis.getRange().getLowerBound() + unitCount);
        }
        if (!Double.isNaN(commonDivisor) && unitCount % commonDivisor != 0.0) {
            unitCount += commonDivisor - unitCount % commonDivisor;
        }
        return unitCount;
    }

    protected abstract void adjust(ValueAxis var1);
}

