/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.IOException;
import java.io.Serializable;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.AbstractCacheService;
import jp.ossc.nimbus.service.cache.Cache;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.SerializeCachedReference;
import jp.ossc.nimbus.service.cache.SerializedMemoryCacheServiceMBean;
import jp.ossc.nimbus.service.io.Externalizer;

public class SerializedMemoryCacheService
extends AbstractCacheService
implements Serializable,
SerializedMemoryCacheServiceMBean {
    private static final long serialVersionUID = -360981346639234924L;
    private ServiceName externalizerServiceName;
    private Externalizer externalizer;
    private ServiceName persistCacheServiceName;

    @Override
    public void setPersistCacheServiceName(ServiceName name) {
        this.persistCacheServiceName = name;
    }

    @Override
    public ServiceName getPersistCacheServiceName() {
        return this.persistCacheServiceName;
    }

    @Override
    public void setExternalizerServiceName(ServiceName name) {
        this.externalizerServiceName = name;
    }

    @Override
    public ServiceName getExternalizerServiceName() {
        return this.externalizerServiceName;
    }

    public void setExternalizer(Externalizer ext) {
        this.externalizer = ext;
    }

    public Externalizer getExternalizer() {
        return this.externalizer;
    }

    @Override
    public void startService() throws Exception {
        if (this.externalizerServiceName != null) {
            this.externalizer = (Externalizer)ServiceManagerFactory.getServiceObject(this.externalizerServiceName);
        }
        if (this.persistCacheServiceName != null) {
            Cache persistCache = (Cache)ServiceManagerFactory.getServiceObject(this.persistCacheServiceName);
            CachedReference[] refs = persistCache.toArray();
            for (int i = 0; i < refs.length; ++i) {
                this.add(refs[i].get());
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.persistCacheServiceName != null) {
            Cache persistCache = (Cache)ServiceManagerFactory.getServiceObject(this.persistCacheServiceName);
            persistCache.clear();
            CachedReference[] refs = this.toArray();
            for (int i = 0; i < refs.length; ++i) {
                persistCache.add(refs[i].get());
            }
        }
    }

    @Override
    protected CachedReference createCachedReference(Object obj) {
        try {
            return this.externalizer == null ? new SerializeCachedReference(obj) : new SerializeCachedReference(obj, this.externalizer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }
}

