/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.AbstractCacheMapFactoryService;
import jp.ossc.nimbus.service.cache.AbstractCacheMapService;
import jp.ossc.nimbus.service.cache.FileCacheMapFactoryServiceMBean;
import jp.ossc.nimbus.service.cache.FileCacheMapService;

public class FileCacheMapFactoryService
extends AbstractCacheMapFactoryService
implements FileCacheMapFactoryServiceMBean,
Serializable {
    private static final long serialVersionUID = 2429673437287340561L;

    @Override
    protected AbstractCacheMapService createAbstractCacheMapService() throws Exception {
        return new FileCacheMapService();
    }

    @Override
    protected Service createServiceInstance() throws Exception {
        FileCacheMapService cacheMap = (FileCacheMapService)super.createServiceInstance();
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        cacheMap.setOutputDirectory(templateCacheMap.getOutputDirectory());
        cacheMap.setFileShared(templateCacheMap.isFileShared());
        cacheMap.setOutputPrefix(templateCacheMap.getOutputPrefix());
        cacheMap.setOutputSuffix(templateCacheMap.getOutputSuffix());
        cacheMap.setLoadOnStart(templateCacheMap.isLoadOnStart());
        cacheMap.setDeleteOnExitWithJVM(templateCacheMap.isDeleteOnExitWithJVM());
        cacheMap.setExternalizerServiceName(templateCacheMap.getExternalizerServiceName());
        return cacheMap;
    }

    @Override
    public void setOutputDirectory(String path) throws IllegalArgumentException {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return;
        }
        templateCacheMap.setOutputDirectory(path);
        Set instanceSet = this.getManagedInstanceSet();
        for (FileCacheMapService cacheMap : instanceSet) {
            cacheMap.setOutputDirectory(path);
        }
    }

    @Override
    public String getOutputDirectory() {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return null;
        }
        return templateCacheMap.getOutputDirectory();
    }

    @Override
    public void setFileShared(boolean isShared) {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return;
        }
        templateCacheMap.setFileShared(isShared);
        Set instanceSet = this.getManagedInstanceSet();
        for (FileCacheMapService cacheMap : instanceSet) {
            cacheMap.setFileShared(isShared);
        }
    }

    @Override
    public boolean isFileShared() {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return false;
        }
        return templateCacheMap.isFileShared();
    }

    @Override
    public void setOutputPrefix(String prefix) {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return;
        }
        templateCacheMap.setOutputPrefix(prefix);
        Set instanceSet = this.getManagedInstanceSet();
        for (FileCacheMapService cacheMap : instanceSet) {
            cacheMap.setOutputPrefix(prefix);
        }
    }

    @Override
    public String getOutputPrefix() {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return null;
        }
        return templateCacheMap.getOutputPrefix();
    }

    @Override
    public void setOutputSuffix(String suffix) {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return;
        }
        templateCacheMap.setOutputSuffix(suffix);
        Set instanceSet = this.getManagedInstanceSet();
        for (FileCacheMapService cacheMap : instanceSet) {
            cacheMap.setOutputSuffix(suffix);
        }
    }

    @Override
    public String getOutputSuffix() {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return null;
        }
        return templateCacheMap.getOutputSuffix();
    }

    @Override
    public void setLoadOnStart(boolean isLoad) {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return;
        }
        templateCacheMap.setLoadOnStart(isLoad);
        Set instanceSet = this.getManagedInstanceSet();
        for (FileCacheMapService cacheMap : instanceSet) {
            cacheMap.setLoadOnStart(isLoad);
        }
    }

    @Override
    public boolean isLoadOnStart() {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return false;
        }
        return templateCacheMap.isLoadOnStart();
    }

    @Override
    public void setDeleteOnExitWithJVM(boolean isDeleteOnExit) {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return;
        }
        templateCacheMap.setDeleteOnExitWithJVM(isDeleteOnExit);
        Set instanceSet = this.getManagedInstanceSet();
        for (FileCacheMapService cacheMap : instanceSet) {
            cacheMap.setDeleteOnExitWithJVM(isDeleteOnExit);
        }
    }

    @Override
    public boolean isDeleteOnExitWithJVM() {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return false;
        }
        return templateCacheMap.isDeleteOnExitWithJVM();
    }

    @Override
    public void setExternalizerServiceName(ServiceName name) {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return;
        }
        templateCacheMap.setExternalizerServiceName(name);
        Set instanceSet = this.getManagedInstanceSet();
        for (FileCacheMapService cacheMap : instanceSet) {
            cacheMap.setExternalizerServiceName(name);
        }
    }

    @Override
    public ServiceName getExternalizerServiceName() {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return null;
        }
        return templateCacheMap.getExternalizerServiceName();
    }
}

