/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol;

import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.ossc.nimbus.core.NimbusEntityResolver;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.io.ExtentionFileFilter;
import jp.ossc.nimbus.io.RecurciveSearchFile;
import jp.ossc.nimbus.service.aop.DefaultMethodInvocationContext;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChainFactory;
import jp.ossc.nimbus.service.beancontrol.BeanFlowAsynchInvokeCallback;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerAccess;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerAccessImpl;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerFactoryCallBack;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitor;
import jp.ossc.nimbus.service.beancontrol.DefaultBeanFlowInvokerFactoryServiceMBean;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanControlUncheckedException;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowAsynchTimeoutException;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.beancontrol.interfaces.InvalidConfigurationException;
import jp.ossc.nimbus.service.beancontrol.resource.ResourceManager;
import jp.ossc.nimbus.service.beancontrol.resource.ResourceManagerFactory;
import jp.ossc.nimbus.service.beancontrol.resource.ResourceManagerFactoryService;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.queue.BeanFlowInvokerCallQueueHandlerService;
import jp.ossc.nimbus.service.queue.QueueHandlerContainer;
import jp.ossc.nimbus.service.transaction.JndiTransactionManagerFactoryService;
import jp.ossc.nimbus.service.transaction.TransactionManagerFactory;
import jp.ossc.nimbus.util.CsvArrayList;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultBeanFlowInvokerFactoryService
extends ServiceBase
implements DefaultBeanFlowInvokerFactoryServiceMBean,
BeanFlowInvokerFactory,
BeanFlowInvokerFactoryCallBack {
    private static final long serialVersionUID = 6971974038632528589L;
    private static final String FLOW_TAG_NAME = "flow";
    private static final String INVOKE_FLOW_METHOD_NAME = "invokeFlow";
    private static final Class[] INVOKE_FLOW_METHOD_PARAM = new Class[]{Object.class, BeanFlowMonitor.class};
    private Map mSuspendKeyMap;
    private Map mIgnoreKeyMap;
    private List mExecFlowList;
    private Map mFlowConfigMap;
    private Map mAliasFlowConfigMap;
    private String[] mDirPath;
    private String[] mPath;
    private ServiceName mThreadContextServiceName;
    private Context mThreadContext;
    private ServiceName mJournalServiceName;
    private Journal mJournal;
    private ServiceName mResourceManagerFactoryServiceName;
    private ResourceManagerFactoryService defaultRmFactory;
    private ResourceManagerFactory mRmFactory;
    private ServiceName mLogServiceName;
    private Logger mLogger;
    protected Date mRefreshPlanTime;
    protected Date mRefreshedTime;
    private ServiceName editorFinderServiceName;
    private EditorFinder editorFinder;
    private ServiceName interpreterServiceName;
    private Interpreter interpreter;
    private boolean reloading = false;
    private boolean isManageExecBeanFlow = true;
    private Class beanFlowInvokerAccessClass = BeanFlowInvokerAccessImpl.class;
    private boolean isValidate;
    private ServiceName interceptorChainFactoryServiceName;
    private InterceptorChainFactory interceptorChainFactory;
    private ServiceName transactionManagerFactoryServiceName;
    private TransactionManagerFactory transactionManagerFactory;
    private ServiceName asynchInvokeQueueHandlerContainerServiceName;
    private QueueHandlerContainer asynchInvokeQueueHandlerContainer;
    private String asynchInvokeErrorLogMessageId;
    private String asynchInvokeRetryOverErrorLogMessageId;

    @Override
    public void setValidate(boolean validate) {
        this.isValidate = validate;
    }

    @Override
    public boolean isValidate() {
        return this.isValidate;
    }

    @Override
    public void setManageExecBeanFlow(boolean isManage) {
        this.isManageExecBeanFlow = isManage;
    }

    @Override
    public boolean isManageExecBeanFlow() {
        return this.isManageExecBeanFlow;
    }

    @Override
    public void setResourceManagerFactoryServiceName(ServiceName name) {
        this.mResourceManagerFactoryServiceName = name;
    }

    @Override
    public ServiceName getResourceManagerFactoryServiceName() {
        return this.mResourceManagerFactoryServiceName;
    }

    @Override
    public void setLogServiceName(ServiceName name) {
        this.mLogServiceName = name;
    }

    @Override
    public ServiceName getLogServiceName() {
        return this.mLogServiceName;
    }

    @Override
    public void setEditorFinderServiceName(ServiceName name) {
        this.editorFinderServiceName = name;
    }

    @Override
    public ServiceName getEditorFinderServiceName() {
        return this.editorFinderServiceName;
    }

    @Override
    public void setInterpreterServiceName(ServiceName name) {
        this.interpreterServiceName = name;
    }

    @Override
    public ServiceName getInterpreterServiceName() {
        return this.interpreterServiceName;
    }

    @Override
    public void setDirPaths(String[] dirPaths) {
        this.mDirPath = dirPaths;
    }

    @Override
    public String[] getDirPaths() {
        return this.mDirPath;
    }

    @Override
    public void setPaths(String[] paths) {
        this.mPath = paths;
    }

    @Override
    public String[] getPaths() {
        return this.mPath;
    }

    @Override
    public void setJournalServiceName(ServiceName name) {
        this.mJournalServiceName = name;
    }

    @Override
    public ServiceName getJournalServiceName() {
        return this.mJournalServiceName;
    }

    @Override
    public void setThreadContextServiceName(ServiceName name) {
        this.mThreadContextServiceName = name;
    }

    @Override
    public ServiceName getThreadContextServiceName() {
        return this.mThreadContextServiceName;
    }

    @Override
    public void setInterceptorChainFactoryServiceName(ServiceName name) {
        this.interceptorChainFactoryServiceName = name;
    }

    @Override
    public ServiceName getInterceptorChainFactoryServiceName() {
        return this.interceptorChainFactoryServiceName;
    }

    @Override
    public void setBeanFlowInvokerAccessClass(Class clazz) {
        this.beanFlowInvokerAccessClass = clazz;
    }

    @Override
    public Class getBeanFlowInvokerAccessClass() {
        return this.beanFlowInvokerAccessClass;
    }

    @Override
    public void setTransactionManagerFactoryServiceName(ServiceName name) {
        this.transactionManagerFactoryServiceName = name;
    }

    @Override
    public ServiceName getTransactionManagerFactoryServiceName() {
        return this.transactionManagerFactoryServiceName;
    }

    @Override
    public void setAsynchInvokeQueueHandlerContainerServiceName(ServiceName name) {
        this.asynchInvokeQueueHandlerContainerServiceName = name;
    }

    @Override
    public ServiceName getAsynchInvokeQueueHandlerContainerServiceName() {
        return this.asynchInvokeQueueHandlerContainerServiceName;
    }

    @Override
    public String getAsynchInvokeErrorLogMessageId() {
        return this.asynchInvokeErrorLogMessageId;
    }

    @Override
    public void setAsynchInvokeErrorLogMessageId(String id) {
        this.asynchInvokeErrorLogMessageId = id;
    }

    @Override
    public String getAsynchInvokeRetryOverErrorLogMessageId() {
        return this.asynchInvokeRetryOverErrorLogMessageId;
    }

    @Override
    public void setAsynchInvokeRetryOverErrorLogMessageId(String id) {
        this.asynchInvokeRetryOverErrorLogMessageId = id;
    }

    @Override
    public void createService() {
        this.mFlowConfigMap = new HashMap();
        this.mExecFlowList = new ArrayList();
        this.mAliasFlowConfigMap = new HashMap();
        this.mSuspendKeyMap = new HashMap();
        this.mIgnoreKeyMap = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        try {
            this.mRefreshPlanTime = ft.parse(ft.format(new Date()));
        }
        catch (ParseException e) {
            throw new BeanControlUncheckedException("DateFormat ParseException", e);
        }
        if (this.mThreadContextServiceName != null) {
            this.mThreadContext = (Context)ServiceManagerFactory.getServiceObject(this.mThreadContextServiceName);
        }
        if (this.mJournalServiceName != null) {
            this.mJournal = (Journal)ServiceManagerFactory.getServiceObject(this.mJournalServiceName);
        }
        if (this.editorFinderServiceName != null) {
            this.editorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.editorFinderServiceName);
        }
        if (this.mLogServiceName != null) {
            this.mLogger = (Logger)ServiceManagerFactory.getServiceObject(this.mLogServiceName);
        } else if (this.mLogger == null) {
            this.mLogger = super.getLogger();
        }
        if (this.mResourceManagerFactoryServiceName == null && this.mRmFactory == null) {
            this.defaultRmFactory = new ResourceManagerFactoryService();
            this.defaultRmFactory.create();
            this.defaultRmFactory.start();
            this.mRmFactory = this.defaultRmFactory;
        } else if (this.mResourceManagerFactoryServiceName != null) {
            this.mRmFactory = (ResourceManagerFactory)ServiceManagerFactory.getServiceObject(this.mResourceManagerFactoryServiceName);
        }
        if (this.interceptorChainFactoryServiceName != null) {
            this.interceptorChainFactory = (InterceptorChainFactory)ServiceManagerFactory.getServiceObject(this.interceptorChainFactoryServiceName);
        }
        if (this.interpreterServiceName != null) {
            this.interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
        }
        if (this.transactionManagerFactoryServiceName != null) {
            this.transactionManagerFactory = (TransactionManagerFactory)ServiceManagerFactory.getServiceObject(this.transactionManagerFactoryServiceName);
        }
        if (this.transactionManagerFactory == null) {
            JndiTransactionManagerFactoryService transactionManagerFactoryService = new JndiTransactionManagerFactoryService();
            transactionManagerFactoryService.create();
            transactionManagerFactoryService.start();
            this.transactionManagerFactory = transactionManagerFactoryService;
        }
        if (this.asynchInvokeQueueHandlerContainerServiceName != null) {
            this.asynchInvokeQueueHandlerContainer = (QueueHandlerContainer)ServiceManagerFactory.getServiceObject(this.asynchInvokeQueueHandlerContainerServiceName);
            BeanFlowInvokerCallQueueHandlerService queueHandler = new BeanFlowInvokerCallQueueHandlerService();
            queueHandler.create();
            queueHandler.setBeanFlowInvokerFactory(this);
            queueHandler.setThreadContext(this.mThreadContext);
            queueHandler.setErrorLogMessageId(this.asynchInvokeErrorLogMessageId);
            queueHandler.setRetryOverErrorLogMessageId(this.asynchInvokeRetryOverErrorLogMessageId);
            queueHandler.start();
            this.asynchInvokeQueueHandlerContainer.setQueueHandler(queueHandler);
            this.asynchInvokeQueueHandlerContainer.accept();
        }
        this.reload();
    }

    @Override
    public void stopService() throws Exception {
        if (this.asynchInvokeQueueHandlerContainer != null) {
            this.asynchInvokeQueueHandlerContainer.release();
            this.asynchInvokeQueueHandlerContainer = null;
        }
        if (this.defaultRmFactory != null) {
            this.defaultRmFactory.stop();
            this.defaultRmFactory.destroy();
            this.defaultRmFactory = null;
        }
        this.mRmFactory = null;
        this.mFlowConfigMap.clear();
        this.mExecFlowList.clear();
        this.mAliasFlowConfigMap.clear();
        for (SynchronizeMonitor obj : this.mSuspendKeyMap.values()) {
            obj.notifyAllMonitor();
        }
        this.mSuspendKeyMap.clear();
        this.mIgnoreKeyMap.clear();
    }

    @Override
    public void destroyService() {
        this.mDirPath = null;
        this.mPath = null;
        this.mFlowConfigMap = null;
        this.mExecFlowList = null;
        this.mAliasFlowConfigMap = null;
        this.mSuspendKeyMap = null;
        this.mIgnoreKeyMap = null;
        this.mThreadContext = null;
        this.mJournal = null;
        this.mLogger = null;
        this.editorFinder = null;
    }

    @Override
    public BeanFlowInvoker createFlow(String key) {
        return this.createFlow(key, null, true);
    }

    @Override
    public BeanFlowInvoker createFlow(String key, String caller, boolean isOverwride) {
        BeanFlowInvoker blFlowConfig;
        Object ignore;
        if (this.mRefreshedTime != null && this.mRefreshPlanTime.after(this.mRefreshedTime) && this.mRefreshPlanTime.before(new Date())) {
            this.reload();
        }
        if ((ignore = this.mIgnoreKeyMap.get(key = (blFlowConfig = this.createFlowInternal(key, caller, isOverwride)).getFlowName())) != null) {
            return null;
        }
        SynchronizeMonitor suspend = (SynchronizeMonitor)this.mSuspendKeyMap.get(key);
        if (suspend != null) {
            try {
                suspend.initMonitor();
                suspend.waitMonitor();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.interceptorChainFactory == null) {
            return blFlowConfig;
        }
        InterceptorChain chain = this.interceptorChainFactory.getInterceptorChain(key);
        if (chain == null) {
            return blFlowConfig;
        }
        return new WrappedBeanFlowInvoker(blFlowConfig, chain);
    }

    private BeanFlowInvoker createFlowInternal(String key, String caller, boolean isOverwride) {
        String[] overwrides;
        BeanFlowInvoker blFlowConfig = (BeanFlowInvoker)this.mFlowConfigMap.get(key);
        if (blFlowConfig == null) {
            blFlowConfig = (BeanFlowInvoker)this.mAliasFlowConfigMap.get(key);
        }
        if (blFlowConfig == null) {
            throw new InvalidConfigurationException(key + " no mapped FLOW");
        }
        if (isOverwride && (overwrides = blFlowConfig.getOverwrideFlowNames()) != null) {
            String overwrideName;
            int i = overwrides.length;
            while (--i >= 0 && !key.equals(overwrideName = this.replaceProperty(overwrides[i]))) {
                BeanFlowInvoker owbf;
                if (caller != null && caller.equals(overwrideName) || !this.containsFlow(overwrideName) || (owbf = this.createFlowInternal(overwrideName, caller, isOverwride)) == null) continue;
                blFlowConfig = owbf;
                key = owbf.getFlowName();
                break;
            }
        }
        return blFlowConfig;
    }

    private String replaceProperty(String textValue) {
        textValue = Utility.replaceSystemProperty(textValue);
        textValue = Utility.replaceServiceLoderConfig(textValue, this.getServiceLoader().getConfig());
        textValue = this.replaceContextProperty(textValue);
        textValue = Utility.replaceManagerProperty(this.getServiceManager(), textValue);
        textValue = Utility.replaceServerProperty(textValue);
        return textValue;
    }

    private String replaceContextProperty(String str) {
        Object propObj;
        Context context = this.getThreadContext();
        if (context == null) {
            return str;
        }
        String result = str;
        if (result == null) {
            return null;
        }
        int startIndex = result.indexOf("${");
        if (startIndex == -1) {
            return result;
        }
        int endIndex = result.indexOf("}");
        if (endIndex == -1 || startIndex > endIndex) {
            return result;
        }
        String propStr = result.substring(startIndex + "${".length(), endIndex);
        String prop = null;
        if (propStr != null && propStr.length() != 0 && (propObj = context.get(propStr)) != null) {
            prop = propObj.toString();
        }
        if (prop == null) {
            return result.substring(0, endIndex + "}".length()) + this.replaceContextProperty(result.substring(endIndex + "}".length()));
        }
        if ((result = result.substring(0, startIndex) + prop + result.substring(endIndex + "}".length())).indexOf("${") != -1) {
            return this.replaceContextProperty(result);
        }
        return result;
    }

    @Override
    public Set getBeanFlowKeySet() {
        HashSet result = new HashSet();
        result.addAll(this.mFlowConfigMap.keySet());
        result.addAll(this.mAliasFlowConfigMap.keySet());
        return result;
    }

    @Override
    public boolean containsFlow(String key) {
        return this.mFlowConfigMap.containsKey(key) || this.mAliasFlowConfigMap.containsKey(key);
    }

    protected void clear() {
        this.mFlowConfigMap.clear();
        this.mAliasFlowConfigMap.clear();
    }

    protected void loadXMLDefinition(File xmlfile, Map flowConfigMap, Map aliasFlowConfigMap) {
        Element root = null;
        try {
            root = this.getRoot(xmlfile);
        }
        catch (ParserConfigurationException e) {
            throw new InvalidConfigurationException(xmlfile.toString(), e);
        }
        catch (SAXException e) {
            throw new InvalidConfigurationException(xmlfile.toString(), e);
        }
        catch (IOException e) {
            throw new InvalidConfigurationException(xmlfile.toString(), e);
        }
        NodeList flowList = root.getElementsByTagName(FLOW_TAG_NAME);
        for (int rCnt = 0; rCnt < flowList.getLength(); ++rCnt) {
            Element flowElement = (Element)flowList.item(rCnt);
            BeanFlowInvokerAccess op = null;
            try {
                op = (BeanFlowInvokerAccess)this.beanFlowInvokerAccessClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new InvalidConfigurationException(e);
            }
            catch (IllegalAccessException e) {
                throw new InvalidConfigurationException(e);
            }
            op.fillInstance(flowElement, this);
            flowConfigMap.put(op.getFlowName(), op);
            List list = op.getAiliasFlowNames();
            for (String ailias : list) {
                aliasFlowConfigMap.put(ailias, op);
            }
        }
    }

    protected Element getRoot(File xmlfile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        dbfactory.setValidating(this.isValidate());
        DocumentBuilder builder = dbfactory.newDocumentBuilder();
        NimbusEntityResolver resolver = new NimbusEntityResolver();
        builder.setEntityResolver(resolver);
        MyErrorHandler handler = new MyErrorHandler();
        builder.setErrorHandler(handler);
        Document doc = builder.parse(xmlfile);
        if (handler.isError()) {
            throw new InvalidConfigurationException("Bean flow definition parse error." + xmlfile);
        }
        return doc.getDocumentElement();
    }

    @Override
    public ResourceManager createResourceManager() {
        return this.mRmFactory.createResourceManager();
    }

    public void setResourceManagerFactory(ResourceManagerFactory rmFactory) {
        this.mRmFactory = rmFactory;
    }

    @Override
    public Journal getJournal() {
        return this.mJournal;
    }

    public void setJournal(Journal journal) {
        this.mJournal = journal;
    }

    @Override
    public Logger getLogger() {
        return this.mLogger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.mLogger = logger;
    }

    @Override
    public Context getThreadContext() {
        return this.mThreadContext;
    }

    public void setThreadContext(Context threadContext) {
        this.mThreadContext = threadContext;
    }

    @Override
    public EditorFinder getEditorFinder() {
        return this.editorFinder;
    }

    public void setEditorFinder(EditorFinder editorFinder) {
        this.editorFinder = editorFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExcecFlow(BeanFlowMonitor monitor) {
        List list = this.mExecFlowList;
        synchronized (list) {
            this.mExecFlowList.add(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecFlow(BeanFlowMonitor monitor) {
        List list = this.mExecFlowList;
        synchronized (list) {
            this.mExecFlowList.remove(monitor);
        }
    }

    @Override
    public PropertyEditor findPropEditor(Class cls) {
        return super.getServiceLoader().findEditor(cls);
    }

    @Override
    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public TransactionManagerFactory getTransactionManagerFactory() {
        return this.transactionManagerFactory;
    }

    public void setTransactionManagerFactory(TransactionManagerFactory factory) {
        this.transactionManagerFactory = factory;
    }

    @Override
    public QueueHandlerContainer getAsynchInvokeQueueHandlerContainer() {
        return this.asynchInvokeQueueHandlerContainer;
    }

    public void setAsynchInvokeQueueHandlerContainer(QueueHandlerContainer container) {
        this.asynchInvokeQueueHandlerContainer = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        if (this.reloading) {
            return;
        }
        HashMap flowConfigMap = new HashMap();
        HashMap aliasFlowConfigMap = new HashMap();
        try {
            this.reloading = true;
            SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
            if (this.mDirPath != null) {
                for (int rcnt = 0; rcnt < this.mDirPath.length; ++rcnt) {
                    String tmpName = this.mDirPath[rcnt];
                    RecurciveSearchFile file = new RecurciveSearchFile(tmpName);
                    File[] files = file.listFiles(new ExtentionFileFilter(".xml"));
                    if (files == null) continue;
                    for (int fcount = 0; fcount < files.length; ++fcount) {
                        this.loadXMLDefinition(files[fcount], flowConfigMap, aliasFlowConfigMap);
                    }
                }
            }
            if (this.mPath != null) {
                for (int i = 0; i < this.mPath.length; ++i) {
                    this.loadXMLDefinition(new File(this.mPath[i]), flowConfigMap, aliasFlowConfigMap);
                }
            }
            Map map = this.mFlowConfigMap;
            synchronized (map) {
                this.mFlowConfigMap = flowConfigMap;
                this.mAliasFlowConfigMap = aliasFlowConfigMap;
                try {
                    this.mRefreshedTime = ft.parse(ft.format(new Date()));
                }
                catch (ParseException e) {
                    throw new BeanControlUncheckedException("Date ParseException", e);
                }
            }
        }
        finally {
            this.reloading = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRefreshTime(String time) {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        DefaultBeanFlowInvokerFactoryService defaultBeanFlowInvokerFactoryService = this;
        synchronized (defaultBeanFlowInvokerFactoryService) {
            try {
                this.mRefreshPlanTime = ft.parse(time);
            }
            catch (ParseException e) {
                throw new BeanControlUncheckedException("ParseException", e);
            }
        }
    }

    @Override
    public String getLastRrefreshTime() {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        return ft.format(this.mRefreshedTime);
    }

    @Override
    public String getNextRefreshTime() {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        return ft.format(this.mRefreshPlanTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend(String key) {
        Object object = this.mSuspendKeyMap;
        synchronized (object) {
            Object ret = this.mSuspendKeyMap.get(key);
            if (ret == null) {
                ret = new WaitSynchronizeMonitor();
                this.mSuspendKeyMap.put(key, ret);
            }
        }
        object = this.mExecFlowList;
        synchronized (object) {
            for (int i = 0; i < this.mExecFlowList.size(); ++i) {
                BeanFlowMonitor monitor = (BeanFlowMonitor)this.mExecFlowList.get(i);
                if (!key.equals(monitor.getFlowName())) continue;
                monitor.suspend();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(String key) {
        Object object = this.mSuspendKeyMap;
        synchronized (object) {
            SynchronizeMonitor ret = (SynchronizeMonitor)this.mSuspendKeyMap.get(key);
            if (ret != null) {
                ret.notifyAllMonitor();
                this.mSuspendKeyMap.remove(key);
            }
        }
        object = this.mExecFlowList;
        synchronized (object) {
            for (int i = 0; i < this.mExecFlowList.size(); ++i) {
                BeanFlowMonitor monitor = (BeanFlowMonitor)this.mExecFlowList.get(i);
                if (!key.equals(monitor.getFlowName())) continue;
                monitor.resume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(String key) {
        List list = this.mExecFlowList;
        synchronized (list) {
            for (int i = 0; i < this.mExecFlowList.size(); ++i) {
                BeanFlowMonitor monitor = (BeanFlowMonitor)this.mExecFlowList.get(i);
                if (!key.equals(monitor.getFlowName())) continue;
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ignore(String msgKey) {
        Map map = this.mIgnoreKeyMap;
        synchronized (map) {
            Object ret = this.mIgnoreKeyMap.get(msgKey);
            if (ret == null) {
                ret = new Object();
                this.mIgnoreKeyMap.put(msgKey, ret);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unIgnore(String key) {
        Map map = this.mIgnoreKeyMap;
        synchronized (map) {
            Object ret = this.mIgnoreKeyMap.get(key);
            if (ret != null) {
                this.mIgnoreKeyMap.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList getSuspendList() {
        CsvArrayList ret = new CsvArrayList();
        Map map = this.mSuspendKeyMap;
        synchronized (map) {
            for (String msg : this.mSuspendKeyMap.keySet()) {
                ret.add(msg);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList getIgnoreList() {
        CsvArrayList ret = new CsvArrayList();
        Map map = this.mIgnoreKeyMap;
        synchronized (map) {
            for (String msg : this.mIgnoreKeyMap.keySet()) {
                ret.add(msg);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList getExecFlowList() {
        CsvArrayList ret = new CsvArrayList();
        List list = this.mExecFlowList;
        synchronized (list) {
            ListIterator iterator = this.mExecFlowList.listIterator();
            while (iterator.hasNext()) {
                ret.add(iterator.next());
            }
        }
        return ret;
    }

    private class WrappedBeanFlowInvoker
    implements BeanFlowInvoker {
        private BeanFlowInvoker realInvoker;
        private InterceptorChain chain;

        public WrappedBeanFlowInvoker(BeanFlowInvoker realInvoker, InterceptorChain chain) {
            this.realInvoker = realInvoker;
            this.chain = chain;
        }

        @Override
        public String getFlowName() {
            return this.realInvoker.getFlowName();
        }

        @Override
        public String[] getOverwrideFlowNames() {
            return this.realInvoker.getOverwrideFlowNames();
        }

        @Override
        public BeanFlowMonitor createMonitor() {
            return this.realInvoker.createMonitor();
        }

        @Override
        public Object invokeFlow(Object obj) throws Exception {
            return this.invokeFlow(obj, null);
        }

        @Override
        public Object invokeFlow(Object obj, BeanFlowMonitor monitor) throws Exception {
            DefaultMethodInvocationContext context = new DefaultMethodInvocationContext(this.realInvoker, this.realInvoker.getClass().getMethod(DefaultBeanFlowInvokerFactoryService.INVOKE_FLOW_METHOD_NAME, INVOKE_FLOW_METHOD_PARAM), new Object[]{obj, monitor});
            try {
                return this.chain.invokeNext(context);
            }
            catch (Throwable th) {
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw (Error)th;
            }
        }

        @Override
        public Object invokeAsynchFlow(Object obj, BeanFlowMonitor monitor, boolean isReply, int maxAsynchWait) throws Exception {
            return this.realInvoker.invokeAsynchFlow(obj, monitor, isReply, maxAsynchWait);
        }

        @Override
        public Object getAsynchReply(Object context, BeanFlowMonitor monitor, long timeout, boolean isCancel) throws BeanFlowAsynchTimeoutException, Exception {
            return this.realInvoker.getAsynchReply(context, monitor, timeout, isCancel);
        }

        @Override
        public Object invokeAsynchFlow(Object obj, BeanFlowMonitor monitor, BeanFlowAsynchInvokeCallback callback, int maxAsynchWait) throws Exception {
            return this.realInvoker.invokeAsynchFlow(obj, monitor, callback, maxAsynchWait);
        }

        @Override
        public void end() {
        }
    }

    private class MyErrorHandler
    implements ErrorHandler {
        private boolean isError;

        private MyErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            DefaultBeanFlowInvokerFactoryService.this.getLogger().write("BFIF_00001", (Object)e.getMessage());
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.isError = true;
            DefaultBeanFlowInvokerFactoryService.this.getLogger().write("BFIF_00002", (Object)e.getMessage());
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.isError = true;
            DefaultBeanFlowInvokerFactoryService.this.getLogger().write("BFIF_00003", (Object)e.getMessage());
        }

        public boolean isError() {
            return this.isError;
        }
    }
}

