/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.service.aop.interceptor.servlet.SetCharacterEncodingInterceptorServiceMBean;

public class SetCharacterEncodingInterceptorService
extends ServletFilterInterceptorService
implements SetCharacterEncodingInterceptorServiceMBean {
    private static final long serialVersionUID = 6562650000038918758L;
    protected static final String ISO8859_1 = "ISO8859_1";
    protected static final String QUERY_DELIM = "&";
    protected String characterEncoding;
    protected boolean isEncodeQuery;

    @Override
    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public void setEncodeQuery(boolean isEncode) {
        this.isEncodeQuery = isEncode;
    }

    @Override
    public boolean isEncodeQuery() {
        return this.isEncodeQuery;
    }

    @Override
    public void startService() throws Exception {
        if (this.characterEncoding == null || this.characterEncoding.length() == 0) {
            throw new IllegalArgumentException("characterEncoding must be specified.");
        }
    }

    @Override
    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            HttpServletRequest httpReq;
            String query;
            ServletRequest request = context.getServletRequest();
            request.setCharacterEncoding(this.characterEncoding);
            if (this.isEncodeQuery && request instanceof HttpServletRequest && (query = (httpReq = (HttpServletRequest)request).getQueryString()) != null) {
                Map queryMap = SetCharacterEncodingInterceptorService.parseQueryString(query);
                for (String key : queryMap.keySet()) {
                    String[] vals;
                    String[] qvals = (String[])queryMap.get(key);
                    if (qvals == null || qvals.length <= 0 || (vals = request.getParameterValues(key)) == null) continue;
                    for (int i = 0; i < qvals.length; ++i) {
                        for (int j = 0; j < vals.length; ++j) {
                            if (!qvals[i].equals(vals[j])) continue;
                            vals[j] = new String(vals[j].getBytes(ISO8859_1), this.characterEncoding);
                        }
                    }
                }
            }
        }
        return chain.invokeNext(context);
    }

    protected static Map parseQueryString(String str) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        StringBuffer sb = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(str, QUERY_DELIM);
        while (tokens.hasMoreTokens()) {
            String pair = tokens.nextToken();
            int pos = pair.indexOf(61);
            String key = null;
            String val = null;
            if (pos == -1) {
                key = SetCharacterEncodingInterceptorService.parseName(pair, sb);
                val = "";
            } else {
                key = SetCharacterEncodingInterceptorService.parseName(pair.substring(0, pos), sb);
                val = SetCharacterEncodingInterceptorService.parseName(pair.substring(pos + 1, pair.length()), sb);
            }
            String[] valArray = null;
            if (params.containsKey(key)) {
                String[] oldVals = (String[])params.get(key);
                valArray = new String[oldVals.length + 1];
                for (int i = 0; i < oldVals.length; ++i) {
                    valArray[i] = oldVals[i];
                }
                valArray[oldVals.length] = val;
            } else {
                valArray = new String[]{val};
            }
            params.put(key, valArray);
        }
        return params;
    }

    protected static String parseName(String str, StringBuffer sb) {
        sb.setLength(0);
        int max = str.length();
        block7: for (int i = 0; i < max; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(str.substring(i + 1, i + 3), 16));
                        i += 2;
                    }
                    catch (NumberFormatException e) {
                        sb.append(c);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        String rest = str.substring(i);
                        sb.append(rest);
                        if (rest.length() != 2) continue block7;
                        ++i;
                    }
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

