/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import org.w3c.dom.Element;

public class DefaultLogMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = 154759319695696184L;
    public static final String DEFAULT_LOG_TAG_NAME = "default-log";
    private static final String DEBUG_TAG_NAME = "debug";
    private static final String INFORMATION_TAG_NAME = "information";
    private static final String WARNING_TAG_NAME = "warning";
    private static final String ERROR_TAG_NAME = "error";
    private static final String FATAL_TAG_NAME = "fatal";
    private static final String OUTPUT_ATTRIBUTE_NAME = "output";
    private LogCategoryMetaData debug;
    private LogCategoryMetaData information;
    private LogCategoryMetaData warning;
    private LogCategoryMetaData error;
    private LogCategoryMetaData fatal;

    public DefaultLogMetaData(MetaData parent) {
        super(parent);
    }

    public LogCategoryMetaData getDebug() {
        return this.debug;
    }

    public void setDebug(LogCategoryMetaData data) {
        this.debug = data;
    }

    public LogCategoryMetaData getInformation() {
        return this.information;
    }

    public void setInformation(LogCategoryMetaData data) {
        this.information = data;
    }

    public LogCategoryMetaData getWarning() {
        return this.warning;
    }

    public void setWarning(LogCategoryMetaData data) {
        this.warning = data;
    }

    public LogCategoryMetaData getError() {
        return this.error;
    }

    public void setError(LogCategoryMetaData data) {
        this.error = data;
    }

    public LogCategoryMetaData getFatal() {
        return this.fatal;
    }

    public void setFatal(LogCategoryMetaData data) {
        this.fatal = data;
    }

    @Override
    public void importXML(Element element) throws DeploymentException {
        Element fatalElement;
        Element errorElement;
        Element warningElement;
        Element informationElement;
        super.importXML(element);
        if (!element.getTagName().equals(DEFAULT_LOG_TAG_NAME)) {
            throw new DeploymentException("Tag must be default-log : " + element.getTagName());
        }
        Element debugElement = DefaultLogMetaData.getOptionalChild(element, DEBUG_TAG_NAME);
        if (debugElement != null) {
            this.debug = new LogCategoryMetaData(this);
            this.debug.importXML(debugElement);
        }
        if ((informationElement = DefaultLogMetaData.getOptionalChild(element, INFORMATION_TAG_NAME)) != null) {
            this.information = new LogCategoryMetaData(this);
            this.information.importXML(informationElement);
        }
        if ((warningElement = DefaultLogMetaData.getOptionalChild(element, WARNING_TAG_NAME)) != null) {
            this.warning = new LogCategoryMetaData(this);
            this.warning.importXML(warningElement);
        }
        if ((errorElement = DefaultLogMetaData.getOptionalChild(element, ERROR_TAG_NAME)) != null) {
            this.error = new LogCategoryMetaData(this);
            this.error.importXML(errorElement);
        }
        if ((fatalElement = DefaultLogMetaData.getOptionalChild(element, FATAL_TAG_NAME)) != null) {
            this.fatal = new LogCategoryMetaData(this);
            this.fatal.importXML(fatalElement);
        }
    }

    @Override
    public StringBuffer toXML(StringBuffer buf) {
        this.appendComment(buf);
        buf.append('<').append(DEFAULT_LOG_TAG_NAME).append('>');
        if (this.debug != null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.debug.toXML(new StringBuffer())));
        }
        if (this.information != null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.information.toXML(new StringBuffer())));
        }
        if (this.warning != null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.warning.toXML(new StringBuffer())));
        }
        if (this.error != null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.error.toXML(new StringBuffer())));
        }
        if (this.fatal != null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.fatal.toXML(new StringBuffer())));
        }
        buf.append(LINE_SEPARATOR);
        buf.append("</").append(DEFAULT_LOG_TAG_NAME).append('>');
        return buf;
    }

    public LogCategoryMetaData createDebugLogCategoryMetaData() {
        return new LogCategoryMetaData(this, DEBUG_TAG_NAME);
    }

    public LogCategoryMetaData createInformationLogCategoryMetaData() {
        return new LogCategoryMetaData(this, INFORMATION_TAG_NAME);
    }

    public LogCategoryMetaData createWarningLogCategoryMetaData() {
        return new LogCategoryMetaData(this, WARNING_TAG_NAME);
    }

    public LogCategoryMetaData createErrorLogCategoryMetaData() {
        return new LogCategoryMetaData(this, ERROR_TAG_NAME);
    }

    public LogCategoryMetaData createFatalLogCategoryMetaData() {
        return new LogCategoryMetaData(this, FATAL_TAG_NAME);
    }

    public static class LogCategoryMetaData
    extends MetaData
    implements Serializable {
        private static final long serialVersionUID = 7428020116195385080L;
        private String tagName;
        private boolean isOutput;

        public LogCategoryMetaData(MetaData parent) {
            super(parent);
        }

        public LogCategoryMetaData(MetaData parent, String name) {
            super(parent);
            this.tagName = name;
        }

        public boolean isOutput() {
            return this.isOutput;
        }

        public void setOutput(boolean isOutput) {
            this.isOutput = isOutput;
        }

        @Override
        public void importXML(Element element) throws DeploymentException {
            super.importXML(element);
            this.tagName = element.getTagName();
            String output = LogCategoryMetaData.getOptionalAttribute(element, DefaultLogMetaData.OUTPUT_ATTRIBUTE_NAME);
            if (output != null) {
                this.isOutput = Boolean.valueOf(output);
            }
        }

        @Override
        public StringBuffer toXML(StringBuffer buf) {
            this.appendComment(buf);
            buf.append('<').append(this.tagName);
            buf.append(' ').append(DefaultLogMetaData.OUTPUT_ATTRIBUTE_NAME).append("=\"").append(this.isOutput).append("\"");
            buf.append("/>");
            return buf;
        }
    }
}

