/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import jp.ossc.nimbus.beans.Utility;

public class MethodEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = 5524131172598421268L;

    @Override
    public void setAsText(String text) {
        if (text == null) {
            this.setValue(null);
            return;
        }
        String tmp = Utility.replaceSystemProperty(text);
        try {
            int index = tmp.indexOf(35);
            if (index == -1 || index == 0 || tmp.length() - index <= 3) {
                throw new IllegalArgumentException("format is classname#methodname(paramType1,paramType2,.....) : " + tmp);
            }
            String className = tmp.substring(0, index).trim();
            Class clazz = Utility.convertStringToClass(className);
            int startIndex = tmp.indexOf(40, index + 1);
            if (startIndex == -1 || index + 1 == startIndex) {
                throw new IllegalArgumentException("format is classname#methodname(paramType1,paramType2,.....) : " + tmp);
            }
            String methodName = tmp.substring(index + 1, startIndex).trim();
            int endIndex = tmp.indexOf(41, startIndex + 1);
            if (endIndex == -1 || endIndex != tmp.length() - 1) {
                throw new IllegalArgumentException("format is classname#methodname(paramType1,paramType2,.....) : " + tmp);
            }
            String paramTypesStr = tmp.substring(startIndex + 1, endIndex).trim();
            Class[] paramTypes = null;
            if (paramTypesStr.length() != 0) {
                ArrayList<Class> paramTypeList = new ArrayList<Class>();
                do {
                    index = paramTypesStr.indexOf(44);
                    String paramType = paramTypesStr;
                    if (index != -1) {
                        if (index == paramTypesStr.length() - 1) break;
                        paramType = paramTypesStr.substring(0, index);
                        paramTypesStr = paramTypesStr.substring(index + 1);
                    }
                    paramTypeList.add(Utility.convertStringToClass(paramType.trim()));
                } while (index != -1);
                paramTypes = paramTypeList.toArray(new Class[paramTypeList.size()]);
            }
            this.setValue(clazz.getMethod(methodName, paramTypes));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(tmp + " : " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(tmp + " : " + e.getMessage());
        }
    }

    @Override
    public String getAsText() {
        Method method = (Method)this.getValue();
        if (method == null) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        StringBuffer buf = new StringBuffer(clazz.getName());
        buf.append('#');
        buf.append(method.getName());
        buf.append('(');
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            buf.append(paramTypes[i].getName());
            if (i == paramTypes.length - 1) continue;
            buf.append(',');
        }
        buf.append(')');
        return buf.toString();
    }
}

