/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TreeMap;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.scheduler.Schedule;
import jp.ossc.nimbus.service.scheduler.ScheduleFactory;
import jp.ossc.nimbus.service.scheduler.ScheduleStateManager;
import jp.ossc.nimbus.service.scheduler.Scheduler;
import jp.ossc.nimbus.service.scheduler.TimerSchedule;
import jp.ossc.nimbus.service.scheduler.TimerSchedulerServiceMBean;

public class TimerSchedulerService
extends ServiceBase
implements Scheduler,
TimerSchedulerServiceMBean {
    private static final long serialVersionUID = -4403010534401982918L;
    protected Timer timer;
    protected boolean isDaemon = true;
    protected boolean isScheduleOnStart;
    protected Map schedules;
    protected TimerSchedule[] attrSchedules;
    protected ServiceName[] scheduleServiceNames;
    protected ServiceName scheduleFactoryServiceName;
    protected ScheduleFactory scheduleFactory;
    protected Object scheduleFactoryKey;
    protected ServiceName scheduleStateManagerServiceName;

    @Override
    public void setDaemon(boolean isDaemon) {
        this.isDaemon = isDaemon;
    }

    @Override
    public boolean isDaemon() {
        return this.isDaemon;
    }

    @Override
    public void setScheduleOnStart(boolean isSchedule) {
        this.isScheduleOnStart = isSchedule;
    }

    @Override
    public boolean isScheduleOnStart() {
        return this.isScheduleOnStart;
    }

    @Override
    public void setScheduleFactoryServiceName(ServiceName name) {
        this.scheduleFactoryServiceName = name;
    }

    @Override
    public ServiceName getScheduleFactoryServiceName() {
        return this.scheduleFactoryServiceName;
    }

    @Override
    public void setScheduleFactoryKey(Object key) {
        this.scheduleFactoryKey = key;
    }

    @Override
    public Object getScheduleFactoryKey() {
        return this.scheduleFactoryKey;
    }

    @Override
    public void setScheduleStateManagerServiceName(ServiceName name) {
        this.scheduleStateManagerServiceName = name;
    }

    @Override
    public ServiceName getScheduleStateManagerServiceName() {
        return this.scheduleStateManagerServiceName;
    }

    @Override
    public void setScheduleServiceNames(ServiceName[] names) {
        this.scheduleServiceNames = names;
    }

    @Override
    public ServiceName[] getScheduleServiceNames() {
        return this.scheduleServiceNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSchedule(TimerSchedule schedule) {
        if (this.schedules.containsKey(schedule.getName())) {
            this.removeSchedule(schedule.getName());
        }
        Map map = this.schedules;
        synchronized (map) {
            this.schedules.put(schedule.getName(), schedule);
            if (this.getState() == 3) {
                schedule.schedule(this.timer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadSchedule(String name) {
        if (!this.schedules.containsKey(name)) {
            return;
        }
        this.cancelSchedule(name);
        Map map = this.schedules;
        synchronized (map) {
            TimerSchedule schedule = (TimerSchedule)this.schedules.get(name);
            schedule.schedule(this.timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSchedule(String name) {
        if (!this.schedules.containsKey(name)) {
            return;
        }
        Map map = this.schedules;
        synchronized (map) {
            TimerSchedule schedule = (TimerSchedule)this.schedules.remove(name);
            schedule.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelSchedule(String name) {
        if (!this.schedules.containsKey(name)) {
            return;
        }
        Map map = this.schedules;
        synchronized (map) {
            TimerSchedule schedule = (TimerSchedule)this.schedules.get(name);
            schedule.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateSchedule(String name) {
        if (!this.schedules.containsKey(name)) {
            return;
        }
        Map map = this.schedules;
        synchronized (map) {
            TimerSchedule schedule = (TimerSchedule)this.schedules.get(name);
            schedule.setValid(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateSchedule(String name) {
        if (!this.schedules.containsKey(name)) {
            return;
        }
        Map map = this.schedules;
        synchronized (map) {
            TimerSchedule schedule = (TimerSchedule)this.schedules.get(name);
            schedule.setValid(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeSchedule(String name) {
        if (!this.schedules.containsKey(name)) {
            return;
        }
        Map map = this.schedules;
        synchronized (map) {
            TimerSchedule schedule = (TimerSchedule)this.schedules.get(name);
            schedule.executeForce();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeSchedule(String name, long delay) {
        if (!this.schedules.containsKey(name)) {
            return;
        }
        Map map = this.schedules;
        synchronized (map) {
            TimerSchedule schedule = (TimerSchedule)this.schedules.get(name);
            schedule.executeForce(this.timer, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeSchedule(String name, Date time) {
        if (!this.schedules.containsKey(name)) {
            return;
        }
        Map map = this.schedules;
        synchronized (map) {
            TimerSchedule schedule = (TimerSchedule)this.schedules.get(name);
            schedule.executeForce(this.timer, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection runningSchedules() {
        if (this.schedules == null) {
            return new HashSet();
        }
        TimerSchedule[] scheduleArray = null;
        Map map = this.schedules;
        synchronized (map) {
            scheduleArray = this.schedules.values().toArray(new TimerSchedule[this.schedules.size()]);
        }
        TreeMap<Date, TimerSchedule> result = new TreeMap<Date, TimerSchedule>();
        for (int i = 0; i < scheduleArray.length; ++i) {
            if (!scheduleArray[i].isRunning()) continue;
            result.put(scheduleArray[i].getScheduledExecutionTime(), scheduleArray[i]);
        }
        return result.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection runningScheduleNames() {
        if (this.schedules == null) {
            return new HashSet();
        }
        TimerSchedule[] scheduleArray = null;
        Map map = this.schedules;
        synchronized (map) {
            scheduleArray = this.schedules.values().toArray(new TimerSchedule[this.schedules.size()]);
        }
        TreeMap<Date, String> result = new TreeMap<Date, String>();
        for (int i = 0; i < scheduleArray.length; ++i) {
            if (!scheduleArray[i].isRunning()) continue;
            result.put(scheduleArray[i].getScheduledExecutionTime(), scheduleArray[i].getName());
        }
        return result.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection closedScheduleNames() {
        if (this.schedules == null) {
            return new HashSet();
        }
        TimerSchedule[] scheduleArray = null;
        Map map = this.schedules;
        synchronized (map) {
            scheduleArray = this.schedules.values().toArray(new TimerSchedule[this.schedules.size()]);
        }
        TreeMap<Date, String> result = new TreeMap<Date, String>();
        for (int i = 0; i < scheduleArray.length; ++i) {
            if (!scheduleArray[i].isClosed()) continue;
            result.put(scheduleArray[i].getLastExecutionTime(), scheduleArray[i].getName());
        }
        return result.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection closedSchedules() {
        if (this.schedules == null) {
            return new HashSet();
        }
        TimerSchedule[] scheduleArray = null;
        Map map = this.schedules;
        synchronized (map) {
            scheduleArray = this.schedules.values().toArray(new TimerSchedule[this.schedules.size()]);
        }
        TreeMap<Date, TimerSchedule> result = new TreeMap<Date, TimerSchedule>();
        for (int i = 0; i < scheduleArray.length; ++i) {
            if (!scheduleArray[i].isClosed()) continue;
            result.put(scheduleArray[i].getLastExecutionTime(), scheduleArray[i]);
        }
        return result.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection validScheduleNames() {
        if (this.schedules == null) {
            return new HashSet();
        }
        TimerSchedule[] scheduleArray = null;
        Map map = this.schedules;
        synchronized (map) {
            scheduleArray = this.schedules.values().toArray(new TimerSchedule[this.schedules.size()]);
        }
        TreeMap<Date, String> result = new TreeMap<Date, String>();
        for (int i = 0; i < scheduleArray.length; ++i) {
            if (!scheduleArray[i].isValid()) continue;
            result.put(scheduleArray[i].getScheduledExecutionTime(), scheduleArray[i].getName());
        }
        return result.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection validSchedules() {
        if (this.schedules == null) {
            return new HashSet();
        }
        TimerSchedule[] scheduleArray = null;
        Map map = this.schedules;
        synchronized (map) {
            scheduleArray = this.schedules.values().toArray(new TimerSchedule[this.schedules.size()]);
        }
        TreeMap<Date, TimerSchedule> result = new TreeMap<Date, TimerSchedule>();
        for (int i = 0; i < scheduleArray.length; ++i) {
            if (!scheduleArray[i].isValid()) continue;
            result.put(scheduleArray[i].getScheduledExecutionTime(), scheduleArray[i]);
        }
        return result.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection errorScheduleNames() {
        if (this.schedules == null) {
            return new HashSet();
        }
        TimerSchedule[] scheduleArray = null;
        Map map = this.schedules;
        synchronized (map) {
            scheduleArray = this.schedules.values().toArray(new TimerSchedule[this.schedules.size()]);
        }
        TreeMap<Date, String> result = new TreeMap<Date, String>();
        for (int i = 0; i < scheduleArray.length; ++i) {
            if (!scheduleArray[i].isError()) continue;
            result.put(scheduleArray[i].getScheduledExecutionTime(), scheduleArray[i].getName());
        }
        return result.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection errorSchedules() {
        if (this.schedules == null) {
            return new HashSet();
        }
        TimerSchedule[] scheduleArray = null;
        Map map = this.schedules;
        synchronized (map) {
            scheduleArray = this.schedules.values().toArray(new TimerSchedule[this.schedules.size()]);
        }
        TreeMap<Date, TimerSchedule> result = new TreeMap<Date, TimerSchedule>();
        for (int i = 0; i < scheduleArray.length; ++i) {
            if (!scheduleArray[i].isError()) continue;
            result.put(scheduleArray[i].getScheduledExecutionTime(), scheduleArray[i]);
        }
        return result.values();
    }

    @Override
    public void createService() throws Exception {
        this.schedules = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        if (this.isScheduleOnStart) {
            this.startSchedule(this.scheduleFactoryKey);
        }
    }

    @Override
    public void stopService() throws Exception {
        this.stopSchedule();
    }

    @Override
    public void destroyService() throws Exception {
        this.schedules = null;
    }

    @Override
    public synchronized void startSchedule(Object key) {
        if (this.getState() < 1 && this.getState() > 3) {
            throw new IllegalStateException();
        }
        this.stopSchedule();
        this.timer = new Timer(this.isDaemon);
        this.schedules.putAll(this.createScheduleMap(key));
        if (this.schedules.size() != 0) {
            ScheduleStateManager scheduleStateManager = null;
            if (this.scheduleStateManagerServiceName != null) {
                scheduleStateManager = (ScheduleStateManager)ServiceManagerFactory.getServiceObject(this.scheduleStateManagerServiceName);
            }
            for (TimerSchedule schedule : this.schedules.values()) {
                if (scheduleStateManager != null) {
                    schedule.setScheduleStateManager(scheduleStateManager);
                }
                schedule.setScheduler(this);
            }
            for (TimerSchedule schedule : this.schedules.values()) {
                schedule.schedule(this.timer);
            }
        }
    }

    @Override
    public synchronized void stopSchedule() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.schedules != null) {
            this.schedules.clear();
        }
    }

    @Override
    public synchronized void waitUntilScheduleClose() {
        this.waitUntilScheduleClose(0L);
    }

    @Override
    public synchronized boolean waitUntilScheduleClose(long timeout) {
        block7: {
            if (this.schedules == null || this.schedules.size() == 0) {
                return true;
            }
            final Thread currentThread = Thread.currentThread();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    currentThread.interrupt();
                }
            });
            long start = System.currentTimeMillis();
            long procTime = 0L;
            do {
                Iterator itr = this.schedules.values().iterator();
                boolean isExistNotClosed = false;
                while (itr.hasNext()) {
                    if (((Schedule)itr.next()).isClosed()) continue;
                    isExistNotClosed = true;
                    break;
                }
                if (!isExistNotClosed) break block7;
                try {
                    if (timeout > 0L) {
                        Thread.sleep(timeout - procTime > 500L ? 500L : timeout - procTime);
                    } else {
                        Thread.sleep(500L);
                    }
                }
                catch (InterruptedException e) {
                    break block7;
                }
                procTime = System.currentTimeMillis() - start;
            } while (timeout <= 0L || procTime < timeout);
            return false;
        }
        return true;
    }

    @Override
    public Schedule getSchedule(Object key, String name) {
        return (Schedule)this.createScheduleMap(key).get(name);
    }

    @Override
    public Schedule[] getSchedules(Object key) {
        return this.createScheduleMap(key).values().toArray(new TimerSchedule[this.schedules.size()]);
    }

    protected Map createScheduleMap(Object key) {
        TreeMap<String, TimerSchedule> schedules = new TreeMap<String, TimerSchedule>();
        if (this.scheduleFactoryServiceName != null) {
            this.scheduleFactory = (ScheduleFactory)ServiceManagerFactory.getServiceObject(this.scheduleFactoryServiceName);
            Schedule[] schs = this.scheduleFactory.getSchedules(key == null ? (this.scheduleFactoryKey == null ? new Date() : this.scheduleFactoryKey) : key);
            for (int i = 0; i < schs.length; ++i) {
                schedules.put(schs[i].getName(), (TimerSchedule)schs[i]);
            }
        }
        if (this.scheduleServiceNames != null) {
            for (int i = 0; i < this.scheduleServiceNames.length; ++i) {
                TimerSchedule schedule = (TimerSchedule)ServiceManagerFactory.getServiceObject(this.scheduleServiceNames[i]);
                schedules.put(schedule.getName(), schedule);
            }
        }
        if (this.attrSchedules != null) {
            for (int i = 0; i < this.attrSchedules.length; ++i) {
                schedules.put(this.attrSchedules[i].getName(), this.attrSchedules[i]);
            }
        }
        return schedules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schedule getSchedule(String name) {
        if (this.schedules == null) {
            return null;
        }
        Map map = this.schedules;
        synchronized (map) {
            return (TimerSchedule)this.schedules.get(name);
        }
    }

    @Override
    public Schedule[] getSchedules() {
        if (this.schedules == null) {
            return new TimerSchedule[0];
        }
        return this.schedules.values().toArray(new TimerSchedule[this.schedules.size()]);
    }

    public void setScheduleFactory(ScheduleFactory factory) {
        this.scheduleFactory = factory;
    }

    public void setSchedules(TimerSchedule[] schedules) {
        this.attrSchedules = schedules;
    }
}

