/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.proxy.invoker;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.keepalive.KeepAliveListener;
import jp.ossc.nimbus.service.performance.ResourceUsage;
import jp.ossc.nimbus.service.proxy.invoker.KeepAliveCheckInvoker;
import jp.ossc.nimbus.service.proxy.invoker.LocalClientMethodCallInvokerServiceMBean;

public class LocalClientMethodCallInvokerService
extends ServiceBase
implements LocalClientMethodCallInvokerServiceMBean,
KeepAliveCheckInvoker,
Serializable {
    private static final long serialVersionUID = -1650041776482188614L;
    private ServiceName localServiceName;
    private Object localService;
    private ServiceName resourceUsageServiceName;
    private ResourceUsage resourceUsage;

    @Override
    public void setLocalServiceName(ServiceName name) {
        this.localServiceName = name;
    }

    @Override
    public ServiceName getLocalServiceName() {
        return this.localServiceName;
    }

    @Override
    public void setResourceUsageServiceName(ServiceName name) {
        this.resourceUsageServiceName = name;
    }

    @Override
    public ServiceName getResourceUsageServiceName() {
        return this.resourceUsageServiceName;
    }

    public void setResourceUsage(ResourceUsage usage) {
        this.resourceUsage = usage;
    }

    public void setLocalService(Object localService) {
        this.localService = localService;
    }

    @Override
    public void startService() throws Exception {
        if (this.resourceUsage == null && this.resourceUsageServiceName != null) {
            this.resourceUsage = (ResourceUsage)ServiceManagerFactory.getServiceObject(this.resourceUsageServiceName);
        }
        if (this.localServiceName == null && this.localService == null) {
            throw new IllegalArgumentException("localServiceName must be specified.");
        }
    }

    @Override
    public Object invoke(InvocationContext context) throws Throwable {
        MethodInvocationContext methodContext = (MethodInvocationContext)context;
        ServiceName targetName = this.localServiceName;
        if (targetName == null) {
            targetName = (ServiceName)context.getTargetObject();
        }
        if (targetName != null) {
            this.localService = ServiceManagerFactory.getServiceObject(targetName);
        }
        if (this.localService == null) {
            throw new IllegalArgumentException("LocalServiceName or LocalService must be specified.");
        }
        try {
            return methodContext.getTargetMethod().invoke(this.localService, methodContext.getParameters());
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    @Override
    public boolean isAlive() {
        if (this.getState() != 3) {
            return false;
        }
        if (this.localServiceName != null) {
            try {
                Service service = ServiceManagerFactory.getService(this.localServiceName);
                return service.getState() == 3;
            }
            catch (ServiceNotFoundException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void addKeepAliveListener(KeepAliveListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeKeepAliveListener(KeepAliveListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearKeepAliveListener() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparable getResourceUsage() {
        return this.resourceUsage == null ? null : this.resourceUsage.getUsage();
    }
}

