/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import jp.ossc.nimbus.service.journal.editor.JournalServletResponseWrapper;
import jp.ossc.nimbus.service.journal.editor.ServletResponseJournalEditorService;
import jp.ossc.nimbus.service.journal.editor.ServletResponseWrapperJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class ServletResponseWrapperJournalEditorService
extends ServletResponseJournalEditorService
implements ServletResponseWrapperJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 6136120907874155531L;
    private static final String CONTENT_LENGTH_HEADER = "Content Length : ";
    private static final String CONTENT_HEADER = "Content : ";
    private static final String HEADER = "[ServletResponse]";
    private boolean isOutputContentLength = true;
    private boolean isOutputContent = true;

    public ServletResponseWrapperJournalEditorService() {
        this.setHeader(HEADER);
    }

    @Override
    public void setOutputContentLength(boolean isOutput) {
        this.isOutputContentLength = isOutput;
    }

    @Override
    public boolean isOutputContentLength() {
        return this.isOutputContentLength;
    }

    @Override
    public void setOutputContent(boolean isOutput) {
        this.isOutputContent = isOutput;
    }

    @Override
    public boolean isOutputContent() {
        return this.isOutputContent;
    }

    @Override
    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        boolean isMake = super.processBlock(finder, key, value, buf);
        JournalServletResponseWrapper response = (JournalServletResponseWrapper)value;
        if (this.isOutputContentLength()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeContentLengthFormat(finder, key, response, buf);
            isMake = true;
        }
        if (this.isOutputContent()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeContentFormat(finder, key, response, buf);
            isMake = true;
        }
        return isMake;
    }

    protected StringBuffer makeContentLengthFormat(EditorFinder finder, Object key, JournalServletResponseWrapper response, StringBuffer buf) {
        return buf.append(CONTENT_LENGTH_HEADER).append(response.getContentLength());
    }

    protected StringBuffer makeContentFormat(EditorFinder finder, Object key, JournalServletResponseWrapper response, StringBuffer buf) {
        return buf.append(CONTENT_HEADER).append(response.getContent());
    }
}

