/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.service.graph.DatasetCondition;
import jp.ossc.nimbus.service.graph.DatasetConditionImpl;
import jp.ossc.nimbus.service.graph.PlotCondition;

public class PlotConditionImpl
implements PlotCondition,
Serializable {
    private static final long serialVersionUID = -5120322206925145655L;
    private String name;
    private Map dsConditionMap = null;
    private List dsConditionList = null;
    private LinkedHashSet dsNameOrderSet = null;
    private Set enableDsNameSet = null;

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addDatasetCondition(DatasetCondition dsCondition) {
        if (this.dsConditionMap == null) {
            this.dsConditionMap = new HashMap();
        }
        if (this.dsConditionList == null) {
            this.dsConditionList = new ArrayList();
        }
        if (this.dsConditionMap.containsKey(dsCondition.getName())) {
            List conditions = (List)this.dsConditionMap.get(dsCondition.getName());
            conditions.add(dsCondition);
            this.dsConditionList.add(dsCondition);
        } else {
            ArrayList<DatasetCondition> conditions = new ArrayList<DatasetCondition>();
            conditions.add(dsCondition);
            this.dsConditionMap.put(dsCondition.getName(), conditions);
            this.dsConditionList.add(dsCondition);
        }
    }

    @Override
    public DatasetCondition[] getDatasetConditions(String dsName) {
        if (this.dsConditionMap == null) {
            return new DatasetConditionImpl[0];
        }
        if (this.dsConditionMap.containsKey(dsName)) {
            List conditions = (List)this.dsConditionMap.get(dsName);
            return conditions.toArray(new DatasetCondition[conditions.size()]);
        }
        return new DatasetConditionImpl[0];
    }

    @Override
    public DatasetCondition[] getDatasetConditions() {
        if (this.dsConditionList == null) {
            return new DatasetConditionImpl[0];
        }
        return this.dsConditionList.toArray(new DatasetCondition[this.dsConditionList.size()]);
    }

    public Map getDatasetConditionMap() {
        if (this.dsConditionMap == null) {
            return null;
        }
        return this.dsConditionMap;
    }

    public void addDatasetConditionMap(Map map) {
        if (map == null || map.size() == 0) {
            return;
        }
        if (this.dsConditionMap == null) {
            this.dsConditionMap = new HashMap();
        }
        if (this.dsConditionList == null) {
            this.dsConditionList = new ArrayList();
        }
        for (String dsName : map.keySet()) {
            this.dsConditionList.addAll((List)map.get(dsName));
            if (this.dsConditionMap.containsKey(dsName)) {
                List list = (List)this.dsConditionMap.get(dsName);
                list.addAll((Collection)map.get(dsName));
                continue;
            }
            this.dsConditionMap.put(dsName, map.get(dsName));
        }
    }

    @Override
    public void addDatasetNameOrder(String dsName) {
        if (this.dsNameOrderSet == null) {
            this.dsNameOrderSet = new LinkedHashSet();
        }
        this.dsNameOrderSet.add(dsName);
    }

    @Override
    public String[] getDatasetNameOrder() {
        if (this.dsNameOrderSet == null) {
            return new String[0];
        }
        return this.dsNameOrderSet.toArray(new String[this.dsNameOrderSet.size()]);
    }

    public void setDatasetNameOrderSet(LinkedHashSet orders) {
        this.dsNameOrderSet = orders;
    }

    public LinkedHashSet getDatasetNameOrderSet() {
        return this.dsNameOrderSet;
    }

    @Override
    public void addEnableDatasetName(String dsName) {
        if (this.enableDsNameSet == null) {
            this.enableDsNameSet = new HashSet();
        }
        this.enableDsNameSet.add(dsName);
    }

    @Override
    public String[] getEnableDatasetNames() {
        if (this.enableDsNameSet == null) {
            return new String[0];
        }
        return this.enableDsNameSet.toArray(new String[this.enableDsNameSet.size()]);
    }

    public void setEnableDatasetNameSet(Set names) {
        this.enableDsNameSet = names;
    }

    public Set getEnableDatasetNameSet() {
        return this.enableDsNameSet;
    }

    @Override
    public Iterator getDatasetNames() {
        if (this.dsConditionMap == null) {
            this.dsConditionMap = new HashMap();
        }
        return this.dsConditionMap.keySet().iterator();
    }
}

