/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.connection;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.WrappedDataSourceServiceMBean;
import jp.ossc.nimbus.service.repository.JNDIRepositoryService;
import jp.ossc.nimbus.service.repository.Repository;

public class WrappedDataSourceService
extends ServiceBase
implements DataSource,
Referenceable,
WrappedDataSourceServiceMBean,
Serializable {
    private static final long serialVersionUID = 1524707347811252995L;
    private ServiceName jndiRepositoryServiceName;
    private Repository jndiRepository;
    private String sourceJNDIName;
    private String wrappedJNDIName;
    private String connectionWrapperClassName;
    private Class connectionWrapperClass;
    private Map connectionWrapperProperties;
    private Map properties;
    private Reference reference;

    @Override
    public void setJNDIRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    @Override
    public ServiceName getJNDIRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    @Override
    public void setSourceJNDIName(String name) {
        this.sourceJNDIName = name;
    }

    @Override
    public String getSourceJNDIName() {
        return this.sourceJNDIName;
    }

    @Override
    public void setWrappedJNDIName(String name) {
        this.wrappedJNDIName = name;
    }

    @Override
    public String getWrappedJNDIName() {
        return this.wrappedJNDIName;
    }

    @Override
    public void setConnectionWrapperClassName(String className) {
        this.connectionWrapperClassName = className;
    }

    @Override
    public String getConnectionWrapperClassName() {
        return this.connectionWrapperClassName;
    }

    @Override
    public void setConnectionWrapperProperties(Map prop) {
        this.connectionWrapperProperties = prop;
    }

    @Override
    public Map getConnectionWrapperProperties() {
        return this.connectionWrapperProperties;
    }

    @Override
    public void startService() throws Exception {
        if (this.sourceJNDIName == null) {
            throw new IllegalArgumentException("SourceJNDIName is null.");
        }
        if (this.wrappedJNDIName == null) {
            throw new IllegalArgumentException("WrappedJNDIName is null.");
        }
        if (this.jndiRepositoryServiceName != null) {
            this.jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(this.jndiRepositoryServiceName);
        }
        if (this.jndiRepository == null) {
            JNDIRepositoryService jndiRepositoryService = new JNDIRepositoryService();
            jndiRepositoryService.create();
            jndiRepositoryService.start();
            this.jndiRepository = jndiRepositoryService;
        }
        if (this.getConnectionWrapperClassName() != null) {
            this.connectionWrapperClass = Class.forName(this.getConnectionWrapperClassName(), true, NimbusClassLoader.getInstance());
        }
        if (this.connectionWrapperProperties != null && this.connectionWrapperProperties.size() != 0) {
            this.properties = new LinkedHashMap();
            for (String propName : this.connectionWrapperProperties.keySet()) {
                Object val = this.connectionWrapperProperties.get(propName);
                Property property = PropertyFactory.createProperty(propName);
                this.properties.put(property, val);
            }
        }
        if (this.getSourceDataSource() == null) {
            throw new IllegalArgumentException("SourceJNDIName can not get from JNDIRepository.");
        }
        StringRefAddr addr = new StringRefAddr("nimbus/service", this.getServiceNameObject().toString());
        this.reference = new Reference(this.getClass().getName(), addr, WrappedDataSourceObjectFactory.class.getName(), null);
        if (!this.jndiRepository.register(this.wrappedJNDIName, this.reference)) {
            throw new IllegalArgumentException("WrappedJNDIName can not register to JNDIRepository.");
        }
    }

    @Override
    public void stopService() throws Exception {
        this.jndiRepository.unregister(this.wrappedJNDIName);
    }

    private DataSource getSourceDataSource() {
        return (DataSource)this.jndiRepository.get(this.sourceJNDIName);
    }

    private Connection wrapConnection(Connection con) throws SQLException {
        if (con != null && this.connectionWrapperClass != null) {
            try {
                Constructor constructor = this.connectionWrapperClass.getConstructor(Connection.class);
                con = (Connection)constructor.newInstance(con);
                if (this.properties != null) {
                    for (Property prop : this.properties.keySet()) {
                        Object val = this.properties.get(prop);
                        prop.setProperty(con, val);
                    }
                }
            }
            catch (InstantiationException e) {
                throw new SQLException(e.toString());
            }
            catch (IllegalAccessException e) {
                throw new SQLException(e.toString());
            }
            catch (InvocationTargetException e) {
                throw new SQLException(e.getTargetException().toString());
            }
            catch (NoSuchMethodException e) {
                throw new SQLException(e.toString());
            }
            catch (NoSuchPropertyException e) {
                throw new SQLException(e.toString());
            }
        }
        return con;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection con = this.getSourceDataSource().getConnection();
        return this.wrapConnection(con);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection con = this.getSourceDataSource().getConnection(username, password);
        return this.wrapConnection(con);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getSourceDataSource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getSourceDataSource().setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getSourceDataSource().setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getSourceDataSource().getLoginTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getSourceDataSource().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getSourceDataSource().isWrapperFor(iface);
    }

    public void setJNDIRepository(Repository repository) {
        this.jndiRepository = repository;
    }

    @Override
    public Reference getReference() throws NamingException {
        return this.reference;
    }

    public static class WrappedDataSourceObjectFactory
    implements ObjectFactory {
        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
            Reference ref = (Reference)obj;
            RefAddr addr = ref.get("nimbus/service");
            String serviceNameStr = (String)addr.getContent();
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setAsText(serviceNameStr);
            ServiceName serviceName = (ServiceName)editor.getValue();
            return ServiceManagerFactory.getServiceObject(serviceName);
        }
    }
}

