/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.DefaultCachedReference;
import jp.ossc.nimbus.service.cache.IllegalCachedReferenceException;
import jp.ossc.nimbus.service.io.Externalizer;

public class SerializeCachedReference
extends DefaultCachedReference
implements Serializable {
    private static final long serialVersionUID = -1425349493190241680L;
    private transient Externalizer externalizer;

    public SerializeCachedReference(Object obj) throws IOException {
        super(null);
        this.serializeObject(obj);
    }

    public SerializeCachedReference(Object obj, Externalizer ext) throws IOException {
        super(null);
        this.externalizer = ext;
        this.serializeObject(obj);
    }

    protected void serializeObject(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.externalizer == null) {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.flush();
        } else {
            this.externalizer.writeExternal(obj, baos);
        }
        this.cacheObj = baos.toByteArray();
    }

    protected Object deserializeObject(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        Object entry = null;
        if (this.externalizer == null) {
            ObjectInputStream ois = new ObjectInputStream(bais);
            entry = ois.readObject();
        } else {
            entry = this.externalizer.readExternal(bais);
        }
        return entry;
    }

    public byte[] getBytes() {
        return (byte[])super.get(null, false);
    }

    @Override
    public Object get(Object source, boolean notify) {
        Object obj = super.get(source, notify);
        if (obj instanceof byte[]) {
            try {
                return this.deserializeObject((byte[])obj);
            }
            catch (IOException e) {
                return null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return obj;
    }

    @Override
    public void set(Object source, Object obj) throws IllegalCachedReferenceException {
        this.notifyChange(source, obj);
        if (obj != null) {
            try {
                this.serializeObject(obj);
            }
            catch (IOException e) {
                throw new IllegalCachedReferenceException(e);
            }
        } else {
            this.cacheObj = null;
        }
    }

    @Override
    public void remove(Object source) {
        if (this.cacheObj != null) {
            this.notifyRemoved(source);
            this.cacheObj = null;
            if (this.linkedReferences != null) {
                this.linkedReferences.clear();
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeSet(out, this.linkedReferences);
        this.writeSet(out, this.removeListeners);
        this.writeSet(out, this.accessListeners);
        this.writeSet(out, this.changeListeners);
        ServiceName name = null;
        if (this.externalizer != null) {
            name = this.getServiceName(this.externalizer);
        }
        if (name != null) {
            out.writeObject(name);
        } else {
            out.writeObject(this.externalizer);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.linkedReferences = this.readSet(in);
        this.removeListeners = this.readSet(in);
        this.accessListeners = this.readSet(in);
        this.changeListeners = this.readSet(in);
        Object obj = in.readObject();
        if (obj != null) {
            this.externalizer = obj instanceof ServiceName ? (Externalizer)ServiceManagerFactory.getServiceObject((ServiceName)obj) : (Externalizer)obj;
        }
    }
}

