/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.AbstractCacheServiceMBean;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.OverflowController;

public abstract class AbstractCacheService
extends ServiceBase
implements CacheRemoveListener,
AbstractCacheServiceMBean {
    private static final long serialVersionUID = 4327482025283418963L;
    protected Set references;
    protected ServiceName[] overflowControllerServiceNames;
    protected List overflowControllers;
    protected boolean isClearOnStop;
    protected boolean isClearOnDestroy = true;

    @Override
    public void setOverflowControllerServiceNames(ServiceName[] names) {
        this.overflowControllerServiceNames = names;
    }

    @Override
    public ServiceName[] getOverflowControllerServiceNames() {
        return this.overflowControllerServiceNames;
    }

    @Override
    public void setClearOnStop(boolean isClear) {
        this.isClearOnStop = isClear;
    }

    @Override
    public boolean isClearOnStop() {
        return this.isClearOnStop;
    }

    @Override
    public void setClearOnDestroy(boolean isClear) {
        this.isClearOnDestroy = isClear;
    }

    @Override
    public boolean isClearOnDestroy() {
        return this.isClearOnDestroy;
    }

    public void setOverflowControllers(List overflowControllers) {
        this.overflowControllers = overflowControllers;
    }

    @Override
    public void preCreateService() throws Exception {
        super.preCreateService();
        this.references = Collections.synchronizedSet(new HashSet());
        this.overflowControllers = new ArrayList();
    }

    @Override
    public void preStartService() throws Exception {
        super.preStartService();
        if (this.overflowControllerServiceNames != null) {
            for (int i = 0; i < this.overflowControllerServiceNames.length; ++i) {
                this.overflowControllers.add((OverflowController)ServiceManagerFactory.getServiceObject(this.overflowControllerServiceNames[i]));
            }
        }
    }

    @Override
    public void postStopService() throws Exception {
        if (this.isClearOnStop()) {
            this.clear();
        }
        if (this.overflowControllers != null) {
            this.overflowControllers.clear();
        }
        super.postStopService();
    }

    @Override
    public void postDestroyService() throws Exception {
        if (this.isClearOnDestroy()) {
            this.clear();
        }
        this.references = null;
        this.overflowControllers = null;
        super.postDestroyService();
    }

    @Override
    public CachedReference add(Object obj) {
        CachedReference ref = this.createCachedReference(obj);
        this.add(ref);
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(CachedReference ref) {
        if (ref == null || this.references == null || this.getState() > 5) {
            return;
        }
        Set set = this.references;
        synchronized (set) {
            ref.addCacheRemoveListener(this);
            this.references.add(ref);
            if (this.overflowControllers.size() != 0) {
                Object[] controllers = this.overflowControllers.toArray();
                int max = controllers.length;
                for (int i = 0; i < max; ++i) {
                    OverflowController controller = (OverflowController)controllers[i];
                    controller.control(ref);
                }
            }
        }
    }

    protected abstract CachedReference createCachedReference(Object var1);

    @Override
    public Iterator iterator() {
        return new CachedReferenceIterator();
    }

    @Override
    public boolean contains(CachedReference ref) {
        if (this.references == null) {
            return false;
        }
        return this.references.contains(ref);
    }

    @Override
    public boolean containsAll(Collection c) {
        if (this.references == null) {
            return false;
        }
        return this.references.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        if (this.references == null) {
            return true;
        }
        return this.references.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(CachedReference ref) {
        boolean result = false;
        if (this.references != null) {
            Set set = this.references;
            synchronized (set) {
                result = this.references.remove(ref);
                if (result) {
                    ref.remove(this);
                }
            }
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection c) {
        Iterator refs = c.iterator();
        boolean result = false;
        while (refs.hasNext()) {
            Object obj = refs.next();
            if (!(obj instanceof CachedReference)) continue;
            result |= this.remove((CachedReference)obj);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection c) {
        if (this.references == null) {
            return false;
        }
        boolean result = false;
        Set set = this.references;
        synchronized (set) {
            for (CachedReference ref : this.references) {
                if (c.contains(ref)) continue;
                result |= this.remove(ref);
            }
        }
        return result;
    }

    @Override
    public int size() {
        if (this.references == null) {
            return 0;
        }
        return this.references.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.references != null) {
            Set set = this.references;
            synchronized (set) {
                Object[] refs = this.references.toArray();
                for (int i = 0; i < refs.length; ++i) {
                    this.remove((CachedReference)refs[i]);
                }
            }
        }
    }

    @Override
    public CachedReference[] toArray() {
        if (this.references == null) {
            return new CachedReference[0];
        }
        return this.references.toArray(new CachedReference[this.references.size()]);
    }

    @Override
    public CachedReference[] toArray(CachedReference[] refs) {
        if (this.references == null) {
            return new CachedReference[0];
        }
        return this.references.toArray(refs);
    }

    @Override
    public void removed(CachedReference ref) {
        if (this.references != null && this.references.contains(ref)) {
            this.references.remove(ref);
        }
    }

    private class CachedReferenceIterator
    implements Iterator,
    Serializable {
        private static final long serialVersionUID = -6125109804226184416L;
        private Iterator iterator;
        private Object current;

        public CachedReferenceIterator() {
            if (AbstractCacheService.this.references != null) {
                this.iterator = new HashSet(AbstractCacheService.this.references).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterator == null ? false : this.iterator.hasNext();
        }

        public Object next() {
            if (this.iterator == null) {
                throw new NoSuchElementException();
            }
            this.current = null;
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.iterator.remove();
            AbstractCacheService.this.remove((CachedReference)this.current);
            if (!this.iterator.hasNext()) {
                this.current = null;
            }
        }
    }
}

