/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceFactoryServiceBase;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.AbstractCacheFactoryServiceMBean;
import jp.ossc.nimbus.service.cache.AbstractCacheService;

public abstract class AbstractCacheFactoryService
extends ServiceFactoryServiceBase
implements AbstractCacheFactoryServiceMBean {
    private static final long serialVersionUID = 5428773891480587972L;
    private AbstractCacheService template;

    protected abstract AbstractCacheService createAbstractCacheService() throws Exception;

    @Override
    protected Service createServiceInstance() throws Exception {
        AbstractCacheService templateCache = this.getTemplate();
        if (templateCache == null) {
            return null;
        }
        AbstractCacheService cache = this.createAbstractCacheService();
        if (cache == null) {
            return null;
        }
        cache.setOverflowControllerServiceNames(templateCache.getOverflowControllerServiceNames());
        cache.setClearOnStop(templateCache.isClearOnStop());
        cache.setClearOnDestroy(templateCache.isClearOnDestroy());
        return cache;
    }

    @Override
    public void setOverflowControllerServiceNames(ServiceName[] names) {
        AbstractCacheService templateCache = this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setOverflowControllerServiceNames(names);
        Set instanceSet = this.getManagedInstanceSet();
        for (AbstractCacheService cache : instanceSet) {
            cache.setOverflowControllerServiceNames(names);
        }
    }

    @Override
    public ServiceName[] getOverflowControllerServiceNames() {
        AbstractCacheService templateCache = this.getTemplate();
        if (templateCache == null) {
            return null;
        }
        return templateCache.getOverflowControllerServiceNames();
    }

    @Override
    public void setClearOnStop(boolean isClear) {
        AbstractCacheService templateCache = this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setClearOnStop(isClear);
        Set instanceSet = this.getManagedInstanceSet();
        for (AbstractCacheService cache : instanceSet) {
            cache.setClearOnStop(isClear);
        }
    }

    @Override
    public boolean isClearOnStop() {
        AbstractCacheService templateCache = this.getTemplate();
        if (templateCache == null) {
            return false;
        }
        return templateCache.isClearOnStop();
    }

    @Override
    public void setClearOnDestroy(boolean isClear) {
        AbstractCacheService templateCache = this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setClearOnDestroy(isClear);
        Set instanceSet = this.getManagedInstanceSet();
        for (AbstractCacheService cache : instanceSet) {
            cache.setClearOnDestroy(isClear);
        }
    }

    @Override
    public boolean isClearOnDestroy() {
        AbstractCacheService templateCache = this.getTemplate();
        if (templateCache == null) {
            return false;
        }
        return templateCache.isClearOnDestroy();
    }

    @Override
    public void clear() {
        Set instanceSet = this.getManagedInstanceSet();
        for (AbstractCacheService cache : instanceSet) {
            cache.clear();
        }
    }

    protected synchronized AbstractCacheService getTemplate() {
        if (this.template == null) {
            try {
                this.template = this.createAbstractCacheService();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.template;
    }
}

