/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.beancontrol.BeanFlowAsynchInvokeCallback;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerServer;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitor;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitorImpl;
import jp.ossc.nimbus.service.beancontrol.ClientBeanFlowInvokerFactoryServiceMBean;
import jp.ossc.nimbus.service.beancontrol.NoSuchBeanFlowIdException;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowAsynchTimeoutException;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.beancontrol.interfaces.InvalidConfigurationException;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.keepalive.ClusterListener;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.queue.BeanFlowAsynchContext;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainer;

public class ClientBeanFlowInvokerFactoryService
extends ServiceBase
implements BeanFlowInvokerFactory,
ClusterListener,
ClientBeanFlowInvokerFactoryServiceMBean {
    private static final long serialVersionUID = 6401533155172726865L;
    private ServiceName clusterServiceName;
    private ClusterService cluster;
    private ServiceName contextServiceName;
    private String[] contextKeys;
    private Map flowMap;
    private ServiceName asynchInvokeQueueHandlerContainerServiceName;
    private QueueHandlerContainer asynchInvokeQueueHandlerContainer;
    private String asynchInvokeErrorMessageId = "CBFI_00001";

    @Override
    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    @Override
    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    @Override
    public void setContextServiceName(ServiceName name) {
        this.contextServiceName = name;
    }

    @Override
    public ServiceName getContextServiceName() {
        return this.contextServiceName;
    }

    @Override
    public void setContextKeys(String[] keys) {
        this.contextKeys = keys;
    }

    @Override
    public String[] getContextKeys() {
        return this.contextKeys;
    }

    @Override
    public void setAsynchInvokeQueueHandlerContainerServiceName(ServiceName name) {
        this.asynchInvokeQueueHandlerContainerServiceName = name;
    }

    @Override
    public ServiceName getAsynchInvokeQueueHandlerContainerServiceName() {
        return this.asynchInvokeQueueHandlerContainerServiceName;
    }

    @Override
    public void setAsynchInvokeErrorMessageId(String id) {
        this.asynchInvokeErrorMessageId = id;
    }

    @Override
    public String getAsynchInvokeErrorMessageId() {
        return this.asynchInvokeErrorMessageId;
    }

    @Override
    public void startService() throws Exception {
        if (this.clusterServiceName == null) {
            throw new IllegalArgumentException("ClusterServiceName must be specified.");
        }
        this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
        this.cluster.addClusterListener(this);
        if (this.asynchInvokeQueueHandlerContainerServiceName != null) {
            this.asynchInvokeQueueHandlerContainer = (QueueHandlerContainer)ServiceManagerFactory.getServiceObject(this.asynchInvokeQueueHandlerContainerServiceName);
            AsynchInvokeQueueHandler queueHandler = new AsynchInvokeQueueHandler();
            this.asynchInvokeQueueHandlerContainer.setQueueHandler(queueHandler);
            this.asynchInvokeQueueHandlerContainer.accept();
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.asynchInvokeQueueHandlerContainer != null) {
            this.asynchInvokeQueueHandlerContainer.release();
            this.asynchInvokeQueueHandlerContainer = null;
        }
        if (this.cluster != null) {
            this.cluster.removeClusterListener(this);
            this.cluster = null;
        }
    }

    private BeanFlowInvokerServer selectBeanFlowInvokerServer(String flowName) {
        Map currentFlowMap = this.flowMap;
        if (currentFlowMap == null || !currentFlowMap.containsKey(flowName)) {
            return null;
        }
        List serverList = (List)currentFlowMap.get(flowName);
        BeanFlowInvokerServer result = null;
        Comparable resourceUsage = null;
        for (int i = 0; i < serverList.size(); ++i) {
            block5: {
                BeanFlowInvokerServer server = (BeanFlowInvokerServer)serverList.get(i);
                try {
                    if (!server.isAcceptable()) continue;
                    if (result == null) {
                        resourceUsage = server.getResourceUsage();
                        result = server;
                        break block5;
                    }
                    Comparable cmpResourceUsage = server.getResourceUsage();
                    if (cmpResourceUsage != null && cmpResourceUsage.compareTo(resourceUsage) >= 0) break block5;
                    resourceUsage = cmpResourceUsage;
                    result = server;
                }
                catch (RemoteException e) {
                    continue;
                }
            }
            if (resourceUsage == null) break;
        }
        return result;
    }

    @Override
    public BeanFlowInvoker createFlow(String flowName) {
        return this.createFlow(flowName, null, true);
    }

    @Override
    public BeanFlowInvoker createFlow(String flowName, String caller, boolean isOverwride) {
        BeanFlowInvokerServer server = this.selectBeanFlowInvokerServer(flowName);
        if (server == null) {
            throw new InvalidConfigurationException(flowName + " no mapped FLOW");
        }
        try {
            return new BeanFlowInvokerImpl(server.createFlow(flowName, caller, isOverwride), server, this.contextServiceName, this.contextKeys, this.asynchInvokeQueueHandlerContainer);
        }
        catch (RemoteException e) {
            throw new InvalidConfigurationException(flowName + " remote error.", e);
        }
        catch (NoSuchBeanFlowIdException e) {
            throw new InvalidConfigurationException(flowName + " no mapped FLOW", e);
        }
    }

    @Override
    public Set getBeanFlowKeySet() {
        Map currentFlowMap = this.flowMap;
        return currentFlowMap == null ? new HashSet() : new HashSet(currentFlowMap.keySet());
    }

    @Override
    public boolean containsFlow(String key) {
        Map currentFlowMap = this.flowMap;
        return currentFlowMap == null ? false : currentFlowMap.containsKey(key);
    }

    private Map createFlowMap(List members) {
        HashMap<String, ArrayList<BeanFlowInvokerServer>> result = new HashMap<String, ArrayList<BeanFlowInvokerServer>>();
        for (int i = 0; i < members.size(); ++i) {
            ClusterService.GlobalUID uid = (ClusterService.GlobalUID)members.get(i);
            Object option = uid.getOption();
            if (!(option instanceof BeanFlowInvokerServer)) continue;
            BeanFlowInvokerServer server = (BeanFlowInvokerServer)option;
            Set flowNames = null;
            try {
                flowNames = server.getBeanFlowNameSet();
            }
            catch (RemoteException e) {
                continue;
            }
            if (flowNames == null || flowNames.size() == 0) continue;
            for (String flowName : flowNames) {
                ArrayList<BeanFlowInvokerServer> servers = (ArrayList<BeanFlowInvokerServer>)result.get(flowName);
                if (servers == null) {
                    servers = new ArrayList<BeanFlowInvokerServer>();
                    result.put(flowName, servers);
                }
                servers.add(server);
            }
        }
        return result;
    }

    @Override
    public void memberInit(Object myId, List members) {
        this.flowMap = this.createFlowMap(members);
    }

    @Override
    public void memberChange(List oldMembers, List newMembers) {
        this.flowMap = this.createFlowMap(newMembers);
    }

    @Override
    public void changeMain() throws Exception {
    }

    @Override
    public void changeSub() {
    }

    private class AsynchInvokeQueueHandler
    implements QueueHandler {
        private AsynchInvokeQueueHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleDequeuedObject(Object obj) throws Throwable {
            if (obj == null) {
                return;
            }
            Object[] args = (Object[])obj;
            BeanFlowInvokerImpl invoker = (BeanFlowInvokerImpl)args[0];
            Object id = args[1];
            Object input = args[2];
            Map ctx = (Map)args[3];
            BeanFlowAsynchInvokeCallback callback = (BeanFlowAsynchInvokeCallback)args[4];
            int maxAsynchWait = (Integer)args[5];
            try {
                invoker.getBeanFlowInvokerServer().invokeAsynchFlow(id, input, ctx, callback, maxAsynchWait);
            }
            finally {
                invoker.setEndTime(System.currentTimeMillis());
            }
        }

        @Override
        public boolean handleError(Object obj, Throwable th) throws Throwable {
            return true;
        }

        @Override
        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
            Object[] args = (Object[])obj;
            BeanFlowInvokerImpl invoker = (BeanFlowInvokerImpl)args[0];
            if (ClientBeanFlowInvokerFactoryService.this.asynchInvokeErrorMessageId != null) {
                ClientBeanFlowInvokerFactoryService.this.getLogger().write(ClientBeanFlowInvokerFactoryService.this.asynchInvokeErrorMessageId, (Object)invoker.getFlowName(), th);
            }
        }
    }

    public static class BeanFlowAsynchInvokeCallbackImpl
    extends UnicastRemoteObject
    implements BeanFlowAsynchInvokeCallback {
        private static final long serialVersionUID = 9186317666094612196L;
        protected BeanFlowAsynchContext context;
        protected BeanFlowAsynchInvokeCallback callback;

        public BeanFlowAsynchInvokeCallbackImpl(BeanFlowAsynchContext context) throws RemoteException {
            this.context = context;
        }

        public BeanFlowAsynchInvokeCallbackImpl(BeanFlowAsynchInvokeCallback callback) throws RemoteException {
            this.callback = callback;
        }

        @Override
        public void reply(Object output, Throwable th) throws RemoteException {
            if (this.context != null) {
                if (th == null) {
                    this.context.setOutput(output);
                } else {
                    this.context.setThrowable(th);
                }
                if (this.context.getResponseQueue() != null) {
                    this.context.getResponseQueue().push(this.context);
                }
            } else if (this.callback != null) {
                this.callback.reply(output, th);
            }
        }
    }

    private static class BeanFlowInvokerImpl
    implements BeanFlowInvoker {
        private BeanFlowInvokerServer server;
        private Object id;
        private String flowName;
        private long startTime = -1L;
        private long endTime = -1L;
        private ServiceName contextServiceName;
        private String[] contextKeys;
        private ServerBeanFlowMonitor serverMonitor = new ServerBeanFlowMonitor();
        private QueueHandlerContainer asynchInvokeQueueHandlerContainer;

        public BeanFlowInvokerImpl() {
        }

        public BeanFlowInvokerImpl(Object id, BeanFlowInvokerServer server, ServiceName contextServiceName, String[] contextKeys, QueueHandlerContainer qhc) throws RemoteException, NoSuchBeanFlowIdException {
            this.flowName = server.getFlowName(id);
            this.id = id;
            this.server = server;
            this.contextServiceName = contextServiceName;
            this.contextKeys = contextKeys;
            this.asynchInvokeQueueHandlerContainer = qhc;
        }

        @Override
        public Object invokeFlow(Object obj) throws Exception {
            return this.invokeFlow(obj, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invokeFlow(Object obj, BeanFlowMonitor monitor) throws Exception {
            this.startTime = System.currentTimeMillis();
            HashMap<String, Object> ctx = null;
            if (this.contextServiceName != null) {
                Context context = (Context)ServiceManagerFactory.getServiceObject(this.contextServiceName);
                if (this.contextKeys != null && this.contextKeys.length != 0) {
                    for (int i = 0; i < this.contextKeys.length; ++i) {
                        Object val = context.get(this.contextKeys[i]);
                        if (val == null) continue;
                        if (ctx == null) {
                            ctx = new HashMap();
                        }
                        ctx.put(this.contextKeys[i], val);
                    }
                } else if (context.size() != 0) {
                    ctx = new HashMap<String, Object>();
                    ctx.putAll(context);
                }
            }
            if (monitor != null) {
                ((BeanFlowMonitorImpl)monitor).addBeanFlowMonitor(this.serverMonitor);
            }
            try {
                Object object = this.server.invokeFlow(this.id, obj, ctx);
                return object;
            }
            finally {
                this.endTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invokeAsynchFlow(Object obj, BeanFlowMonitor monitor, boolean isReply, int maxAsynchWait) throws Exception {
            this.startTime = System.currentTimeMillis();
            BeanFlowAsynchContext context = null;
            if (monitor != null) {
                ((BeanFlowMonitorImpl)monitor).addBeanFlowMonitor(this.serverMonitor);
            }
            if (isReply) {
                DefaultQueueService replyQueue = new DefaultQueueService();
                replyQueue.create();
                replyQueue.start();
                context = new BeanFlowAsynchContext((BeanFlowInvoker)this, obj, (BeanFlowMonitor)this.serverMonitor, replyQueue);
                try {
                    this.invokeAsynchFlow(obj, monitor, new BeanFlowAsynchInvokeCallbackImpl(context), maxAsynchWait);
                }
                finally {
                    this.endTime = System.currentTimeMillis();
                }
            }
            context = new BeanFlowAsynchContext(this, obj, this.serverMonitor);
            try {
                this.invokeAsynchFlow(obj, monitor, null, maxAsynchWait);
            }
            finally {
                this.endTime = System.currentTimeMillis();
            }
            return context;
        }

        @Override
        public Object getAsynchReply(Object context, BeanFlowMonitor monitor, long timeout, boolean isCancel) throws BeanFlowAsynchTimeoutException, Exception {
            BeanFlowAsynchContext asynchContext = (BeanFlowAsynchContext)context;
            Queue queue = asynchContext.getResponseQueue();
            if (queue == null) {
                return null;
            }
            asynchContext = (BeanFlowAsynchContext)queue.get(timeout);
            if (asynchContext == null) {
                if (isCancel) {
                    BeanFlowInvoker invoker;
                    if (monitor != null) {
                        monitor.cancel();
                        monitor.stop();
                    }
                    if ((invoker = ((BeanFlowAsynchContext)context).getBeanFlowInvoker()) != null) {
                        invoker.end();
                    }
                }
                throw new BeanFlowAsynchTimeoutException(this.flowName);
            }
            try {
                asynchContext.checkError();
            }
            catch (Throwable th) {
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw (Error)th;
            }
            return asynchContext.getOutput();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invokeAsynchFlow(Object obj, BeanFlowMonitor monitor, BeanFlowAsynchInvokeCallback callback, int maxAsynchWait) throws Exception {
            this.startTime = System.currentTimeMillis();
            if (monitor != null) {
                ((BeanFlowMonitorImpl)monitor).addBeanFlowMonitor(this.serverMonitor);
            }
            if (!(callback instanceof BeanFlowAsynchInvokeCallbackImpl)) {
                callback = new BeanFlowAsynchInvokeCallbackImpl(callback);
            }
            HashMap<String, Object> ctx = null;
            if (this.contextServiceName != null) {
                Context context = (Context)ServiceManagerFactory.getServiceObject(this.contextServiceName);
                if (this.contextKeys != null && this.contextKeys.length != 0) {
                    for (int i = 0; i < this.contextKeys.length; ++i) {
                        Object val = context.get(this.contextKeys[i]);
                        if (val == null) continue;
                        if (ctx == null) {
                            ctx = new HashMap();
                        }
                        ctx.put(this.contextKeys[i], val);
                    }
                } else if (context.size() != 0) {
                    ctx = new HashMap<String, Object>();
                    ctx.putAll(context);
                }
            }
            if (this.asynchInvokeQueueHandlerContainer == null) {
                try {
                    this.server.invokeAsynchFlow(this.id, obj, ctx, callback, maxAsynchWait);
                }
                finally {
                    this.endTime = System.currentTimeMillis();
                }
            } else {
                this.asynchInvokeQueueHandlerContainer.push(new Object[]{this, this.id, obj, ctx, callback, new Integer(maxAsynchWait)});
            }
            return null;
        }

        protected BeanFlowInvokerServer getBeanFlowInvokerServer() {
            return this.server;
        }

        protected void setEndTime(long time) {
            this.endTime = time;
        }

        @Override
        public BeanFlowMonitor createMonitor() {
            return this.serverMonitor;
        }

        @Override
        public String getFlowName() {
            return this.flowName;
        }

        @Override
        public String[] getOverwrideFlowNames() {
            try {
                return this.server.getOverwrideFlowNames(this.id);
            }
            catch (RemoteException e) {
                return new String[0];
            }
            catch (NoSuchBeanFlowIdException e) {
                return new String[0];
            }
        }

        @Override
        public void end() {
            try {
                this.server.end(this.id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public class ServerBeanFlowMonitor
        implements BeanFlowMonitor {
            @Override
            public void suspend() {
                try {
                    BeanFlowInvokerImpl.this.server.suspendFlow(BeanFlowInvokerImpl.this.id);
                }
                catch (RemoteException e) {
                }
                catch (NoSuchBeanFlowIdException noSuchBeanFlowIdException) {
                    // empty catch block
                }
            }

            @Override
            public boolean isSuspend() {
                try {
                    return BeanFlowInvokerImpl.this.server.isSuspendFlow(BeanFlowInvokerImpl.this.id);
                }
                catch (RemoteException e) {
                    return false;
                }
                catch (NoSuchBeanFlowIdException e) {
                    return false;
                }
            }

            @Override
            public boolean isSuspended() {
                try {
                    return BeanFlowInvokerImpl.this.server.isSuspendedFlow(BeanFlowInvokerImpl.this.id);
                }
                catch (RemoteException e) {
                    return false;
                }
                catch (NoSuchBeanFlowIdException e) {
                    return false;
                }
            }

            @Override
            public void resume() {
                try {
                    BeanFlowInvokerImpl.this.server.resumeFlow(BeanFlowInvokerImpl.this.id);
                }
                catch (RemoteException e) {
                }
                catch (NoSuchBeanFlowIdException noSuchBeanFlowIdException) {
                    // empty catch block
                }
            }

            @Override
            public void cancel() {
                try {
                    BeanFlowInvokerImpl.this.server.cancel(BeanFlowInvokerImpl.this.id);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }

            @Override
            public void stop() {
                try {
                    BeanFlowInvokerImpl.this.server.stopFlow(BeanFlowInvokerImpl.this.id);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                BeanFlowInvokerImpl.this.end();
            }

            @Override
            public boolean isStop() {
                try {
                    return BeanFlowInvokerImpl.this.server.isStopFlow(BeanFlowInvokerImpl.this.id);
                }
                catch (RemoteException e) {
                    return false;
                }
            }

            @Override
            public boolean isStopped() {
                try {
                    return BeanFlowInvokerImpl.this.server.isStoppedFlow(BeanFlowInvokerImpl.this.id);
                }
                catch (RemoteException e) {
                    return false;
                }
            }

            @Override
            public boolean isEnd() {
                try {
                    return BeanFlowInvokerImpl.this.server.isExistsFlow(BeanFlowInvokerImpl.this.id);
                }
                catch (RemoteException e) {
                    return false;
                }
            }

            @Override
            public String getFlowName() {
                return BeanFlowInvokerImpl.this.flowName;
            }

            @Override
            public String getCurrentFlowName() {
                try {
                    return BeanFlowInvokerImpl.this.server.getCurrentFlowName(BeanFlowInvokerImpl.this.id);
                }
                catch (RemoteException e) {
                    return null;
                }
                catch (NoSuchBeanFlowIdException e) {
                    return null;
                }
            }

            @Override
            public String getCurrentStepName() {
                try {
                    return BeanFlowInvokerImpl.this.server.getCurrentStepName(BeanFlowInvokerImpl.this.id);
                }
                catch (RemoteException e) {
                    return null;
                }
                catch (NoSuchBeanFlowIdException e) {
                    return null;
                }
            }

            @Override
            public long getStartTime() {
                return BeanFlowInvokerImpl.this.startTime == -1L ? 0L : BeanFlowInvokerImpl.this.startTime;
            }

            @Override
            public long getCurrentProcessTime() {
                if (BeanFlowInvokerImpl.this.startTime == -1L) {
                    return 0L;
                }
                if (BeanFlowInvokerImpl.this.endTime != -1L) {
                    return BeanFlowInvokerImpl.this.endTime - BeanFlowInvokerImpl.this.startTime;
                }
                return System.currentTimeMillis() - BeanFlowInvokerImpl.this.startTime;
            }

            @Override
            public void clear() {
                try {
                    BeanFlowInvokerImpl.this.server.clearMonitor(BeanFlowInvokerImpl.this.id);
                }
                catch (RemoteException e) {
                }
                catch (NoSuchBeanFlowIdException noSuchBeanFlowIdException) {
                    // empty catch block
                }
            }
        }
    }
}

