/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class OperateFile
extends File
implements Serializable {
    private static final long serialVersionUID = -3537857563620684853L;

    public OperateFile(File file) {
        super(file.getPath());
    }

    public OperateFile(String pathname) {
        super(pathname);
    }

    public OperateFile(String parent, String child) {
        super(parent, child);
    }

    public OperateFile(File parent, String child) {
        super(parent, child);
    }

    public void appendTo(String filePath) throws IOException {
        File toFile = new File(filePath);
        if (!this.exists()) {
            throw new FileNotFoundException(this.getAbsolutePath());
        }
        if (!toFile.exists()) {
            toFile.createNewFile();
        }
        this.dataMove(toFile, true);
    }

    public void copyTo(String filePath) throws IOException {
        File toFile = new File(filePath);
        if (!this.exists()) {
            throw new FileNotFoundException(this.getAbsolutePath());
        }
        if (toFile.exists()) {
            toFile.delete();
        }
        toFile.createNewFile();
        this.dataMove(toFile, false);
    }

    public boolean deleteAll() {
        return OperateFile.deleteAll(this);
    }

    public static boolean deleteAll(File file) {
        if (!file.exists()) {
            return true;
        }
        boolean result = true;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                result &= OperateFile.deleteAll(files[i]);
            }
            result &= file.delete();
        } else if (file.isFile()) {
            result &= file.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataMove(File toFile, boolean append) throws IOException {
        InputStream is = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        try {
            is = this.toURL().openStream();
            bis = new BufferedInputStream(is);
            fos = new FileOutputStream(toFile, append);
            byte[] bytes = new byte[1024];
            int length = 0;
            while ((length = bis.read(bytes, 0, 1024)) != -1) {
                fos.write(bytes, 0, length);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void splitFile(int splitSize, int startIndex) throws IOException {
        this.splitFile(null, null, null, splitSize, startIndex);
    }

    public void splitFile(String dir, int splitSize, int startIndex) throws IOException {
        this.splitFile(dir, null, null, splitSize, startIndex);
    }

    public void splitFile(String prefix, String suffix, int splitSize, int startIndex) throws IOException {
        this.splitFile(null, prefix, suffix, splitSize, startIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void splitFile(String dir, String prefix, String suffix, int splitSize, int startIndex) throws IOException {
        int index;
        File tmpDir;
        InputStream is = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        int readedSize = -1;
        int readSize = -1;
        File toFile = null;
        if (!this.exists()) {
            throw new FileNotFoundException(this.getAbsolutePath());
        }
        String tmpPath = dir;
        if (tmpPath == null && this.getParentFile() != null) {
            tmpPath = this.getParentFile().getAbsolutePath();
        }
        if (!(tmpDir = new File(tmpPath)).exists()) {
            tmpDir.mkdirs();
        }
        String tmpPrefix = prefix;
        String tmpSuffix = suffix;
        if (tmpPrefix == null && (index = (tmpPrefix = this.getName()).lastIndexOf(46)) != -1) {
            tmpPrefix = tmpPrefix.substring(0, index);
        }
        if (tmpSuffix == null && (index = this.getName().lastIndexOf(46)) != -1 && index == this.getName().length() - 1) {
            tmpSuffix = this.getName().substring(index + 1);
        }
        try {
            is = this.toURL().openStream();
            bis = new BufferedInputStream(is);
            boolean isEOF = false;
            int index2 = startIndex;
            byte[] bytes = new byte[1024];
            while (!isEOF) {
                if (readedSize == -1) {
                    StringBuffer fileName = new StringBuffer(tmpPrefix);
                    fileName.append(index2);
                    if (tmpSuffix != null) {
                        fileName.append(tmpSuffix);
                    }
                    if ((toFile = new File(tmpPath, fileName.toString())).exists()) {
                        toFile.delete();
                    }
                    ++index2;
                    readedSize = 0;
                    fos = new FileOutputStream(toFile);
                }
                readSize = splitSize - readedSize < 1024 ? splitSize - readedSize : 1024;
                int length = bis.read(bytes, 0, readSize);
                boolean bl = isEOF = length == -1;
                if (!isEOF) {
                    fos.write(bytes, 0, length);
                    if ((readedSize += length) < splitSize) continue;
                    fos.close();
                    fos = null;
                    readedSize = -1;
                    continue;
                }
                fos.close();
                fos = null;
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

