/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.util.Set;
import jp.ossc.nimbus.core.FactoryServiceBase;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceName;

public abstract class ServiceFactoryServiceBase
extends FactoryServiceBase {
    private static final long serialVersionUID = 3957308112143950640L;

    @Override
    public void release(Object obj) {
        Service service = (Service)obj;
        service.stop();
        service.destroy();
        super.release(service);
    }

    @Override
    protected final Object createInstance() throws Exception {
        return this.createInstance(false);
    }

    @Override
    protected Object createTemplate() throws Exception {
        return this.createInstance(true);
    }

    protected final Object createInstance(boolean isTemplate) throws Exception {
        Service service = this.createServiceInstance();
        if (service == null) {
            return null;
        }
        if (!isTemplate && this.isManagement() && this.getServiceManagerName() != null) {
            service.setServiceName(this.getServiceName() + '$' + this.getManagedInstanceSet().size());
            service.setServiceManagerName(this.getServiceManagerName());
        }
        if (service.getState() == 7) {
            service.create();
        }
        if (service instanceof ServiceBase) {
            ServiceBase base = (ServiceBase)service;
            if (this.manager != null) {
                base.logger.setDefaultLogger(this.manager.getLogger());
                if (this.getSystemLoggerServiceName() == null) {
                    base.logger.setLogger(this.manager.getLogger());
                }
                base.message.setDefaultMessageRecordFactory(this.manager.getMessageRecordFactory());
                if (this.getSystemMessageRecordFactoryServiceName() == null) {
                    base.message.setMessageRecordFactory(this.manager.getMessageRecordFactory());
                }
            }
            if (this.getSystemLoggerServiceName() != null) {
                base.setSystemLoggerServiceName(this.getSystemLoggerServiceName());
            }
            if (this.getSystemMessageRecordFactoryServiceName() != null) {
                base.setSystemMessageRecordFactoryServiceName(this.getSystemMessageRecordFactoryServiceName());
            }
        }
        if (service.getState() == 1) {
            service.start();
        }
        return service;
    }

    protected abstract Service createServiceInstance() throws Exception;

    @Override
    protected void postStartService() throws Exception {
        super.postStartService();
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            for (Service service : managedInstances) {
                service.start();
            }
        }
    }

    @Override
    protected void postStopService() throws Exception {
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            for (Service service : managedInstances) {
                service.stop();
            }
        }
        super.postStopService();
    }

    @Override
    protected void postDestroyService() throws Exception {
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            for (Service service : managedInstances) {
                service.destroy();
            }
        }
        super.postDestroyService();
    }

    @Override
    public void setSystemLoggerServiceName(ServiceName name) {
        super.setSystemLoggerServiceName(name);
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            for (Service service : managedInstances) {
                if (!(service instanceof ServiceBase)) continue;
                ((ServiceBase)service).setSystemLoggerServiceName(name);
            }
        }
    }

    @Override
    public void setSystemMessageRecordFactoryServiceName(ServiceName name) {
        super.setSystemMessageRecordFactoryServiceName(name);
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            for (Service service : managedInstances) {
                if (!(service instanceof ServiceBase)) continue;
                ((ServiceBase)service).setSystemMessageRecordFactoryServiceName(name);
            }
        }
    }
}

