/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class NimbusEntityResolver
implements EntityResolver {
    private static Map dtds = new Hashtable();

    public static void registerDTD(String publicId, String resource) {
        dtds.put(publicId, resource);
    }

    public static void unregisterDTD(String publicId) {
        dtds.remove(publicId);
    }

    public static boolean isRegisteredDTD(String publicId) {
        return dtds.containsKey(publicId);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (publicId == null || !dtds.containsKey(publicId)) {
            return this.resolveEntity(systemId);
        }
        String dtd = (String)dtds.get(publicId);
        if (dtd == null) {
            return this.resolveEntity(systemId);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream dtdStream = loader.getResourceAsStream(dtd);
        if (dtdStream == null) {
            return this.resolveEntity(systemId);
        }
        InputSource inputSource = new InputSource(dtdStream);
        return inputSource;
    }

    private InputSource resolveEntity(String systemId) {
        if (systemId == null) {
            return null;
        }
        try {
            URL url = new URL(systemId);
            InputStream dtdStream = url.openStream();
            InputSource inputSource = new InputSource(dtdStream);
            return inputSource;
        }
        catch (MalformedURLException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static {
        NimbusEntityResolver.registerDTD("-//Nimbus//DTD Nimbus 1.0//JA", "jp/ossc/nimbus/core/nimbus-service_1_0.dtd");
    }
}

