/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import jp.ossc.nimbus.beans.Utility;

public class StringArrayEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = 1849102862712070203L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsText(String text) {
        if (text == null) {
            this.setValue(null);
            return;
        }
        String tmpText = Utility.replaceSystemProperty(Utility.xmlComentOut(text));
        int length = tmpText.length();
        if (length == 0) {
            this.setValue(new String[0]);
            return;
        }
        StringReader sr = new StringReader(tmpText);
        BufferedReader br = new BufferedReader(sr, length);
        ArrayList<String> list = new ArrayList<String>();
        try {
            StringBuffer buf = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                String val = Utility.trim(line);
                boolean isEscape = false;
                int max = val.length();
                block16: for (int i = 0; i < max; ++i) {
                    char c = val.charAt(i);
                    switch (c) {
                        case ',': {
                            if (isEscape) {
                                buf.append(c);
                                isEscape = false;
                                continue block16;
                            }
                            if (buf.length() == 0) continue block16;
                            String tmp = this.trimDoubleQuote(buf);
                            if (tmp.indexOf(92) != -1) {
                                tmp = Utility.unicodeConvert(tmp);
                            }
                            list.add(tmp);
                            buf.setLength(0);
                            continue block16;
                        }
                        case '\\': {
                            if (isEscape) {
                                buf.append(c);
                                isEscape = false;
                                continue block16;
                            }
                            isEscape = true;
                            continue block16;
                        }
                        default: {
                            if (isEscape) {
                                buf.append('\\');
                                isEscape = false;
                            }
                            buf.append(c);
                        }
                    }
                }
            }
            if (buf.length() != 0) {
                String tmp = this.trimDoubleQuote(buf);
                if (tmp.indexOf(92) != -1) {
                    tmp = Utility.unicodeConvert(tmp);
                }
                list.add(tmp);
                buf.setLength(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            sr.close();
        }
        this.setValue(list.toArray(new String[list.size()]));
    }

    private String trimDoubleQuote(StringBuffer buf) {
        if (buf != null && buf.length() > 1 && buf.charAt(0) == '\"' && buf.charAt(buf.length() - 1) == '\"') {
            return buf.substring(1, buf.length() - 1);
        }
        return buf.toString();
    }

    @Override
    public String getAsText() {
        String[] strArray = (String[])this.getValue();
        if (strArray == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int max = strArray.length;
        for (int i = 0; i < max; ++i) {
            String str = strArray[i];
            str = str.replaceAll(",", "\\\\,");
            buf.append(str);
            if (i == max - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }
}

