/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import jp.ossc.nimbus.beans.Utility;

public class FloatEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = -4548783181711431861L;

    @Override
    public void setAsText(String text) {
        if (text == null) {
            this.setValue(null);
            return;
        }
        this.setValue(new Float(FloatEditor.toFloat(text, true)));
    }

    public static final float toFloat(String text, boolean replace) throws NumberFormatException {
        String str = replace ? Utility.replaceSystemProperty(text) : text;
        float floatValue = 0.0f;
        try {
            floatValue = Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            if ("MAX_VALUE".equals(str)) {
                floatValue = Float.MAX_VALUE;
            }
            if ("MIN_VALUE".equals(str)) {
                floatValue = Float.MIN_VALUE;
            }
            if ("NaN".equals(str)) {
                floatValue = Float.NaN;
            }
            if ("NEGATIVE_INFINITY".equals(str)) {
                floatValue = Float.NEGATIVE_INFINITY;
            }
            if ("POSITIVE_INFINITY".equals(str)) {
                floatValue = Float.POSITIVE_INFINITY;
            }
            throw e;
        }
        return floatValue;
    }

    @Override
    public String getAsText() {
        Float val = (Float)this.getValue();
        return val == null ? null : val.toString();
    }
}

