/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.net;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.util.net.ServerSocket;

public class ServerSocketFactory
extends javax.net.ServerSocketFactory
implements RMIServerSocketFactory {
    protected Map serverSocketProperties;
    protected Map socketProperties;

    public static javax.net.ServerSocketFactory getDefault() {
        return new ServerSocketFactory();
    }

    public java.net.ServerSocket createServerSocket() throws IOException {
        return this.applyServerSocketProperties(new ServerSocket());
    }

    public java.net.ServerSocket createServerSocket(int port) throws IOException {
        return this.applyServerSocketProperties(new ServerSocket(port));
    }

    public java.net.ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.applyServerSocketProperties(new ServerSocket(port, backlog));
    }

    public java.net.ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        return this.applyServerSocketProperties(new ServerSocket(port, backlog, bindAddr));
    }

    public void setServerSocketProperties(Map props) {
        if (props == null || props.size() == 0) {
            if (this.serverSocketProperties != null) {
                this.serverSocketProperties = null;
            }
            return;
        }
        Iterator names = props.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            this.setServerSocketProperty(name, props.get(name));
        }
    }

    public void setServerSocketProperty(String name, Object value) {
        if (this.serverSocketProperties == null) {
            this.serverSocketProperties = new LinkedHashMap();
        }
        Property prop = PropertyFactory.createProperty(name);
        this.serverSocketProperties.put(prop, value);
    }

    public Object getServerSocketProperty(String name) {
        if (this.serverSocketProperties == null) {
            return null;
        }
        Iterator props = this.serverSocketProperties.keySet().iterator();
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            if (!prop.getPropertyName().equals(name)) continue;
            return this.serverSocketProperties.get(prop);
        }
        return null;
    }

    public ServerSocket applyServerSocketProperties(ServerSocket serverSocket) throws IOException {
        try {
            if (this.socketProperties != null && this.socketProperties.size() != 0) {
                Iterator names = this.socketProperties.keySet().iterator();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    serverSocket.setSocketProperty(name, this.socketProperties.get(name));
                }
            }
            if (this.serverSocketProperties != null && this.serverSocketProperties.size() != 0) {
                Iterator props = this.serverSocketProperties.keySet().iterator();
                while (props.hasNext()) {
                    Property prop = (Property)props.next();
                    prop.setProperty(serverSocket, this.serverSocketProperties.get(prop));
                }
            }
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new UndeclaredThrowableException(target);
        }
        catch (NoSuchPropertyException e) {
            throw new UndeclaredThrowableException(e);
        }
        return serverSocket;
    }
}

