/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StringConverter;

public class PatternStringConverter
implements StringConverter,
Serializable {
    private static final long serialVersionUID = 9056240502325078689L;
    protected Object[][] convertObjects;
    protected int matchingFlag = -1;

    public PatternStringConverter() {
    }

    public PatternStringConverter(int flags) {
        this.setMatchingFlag(flags);
    }

    public PatternStringConverter(int flags, String[] fromStrs, String[] toStrs) {
        this.setMatchingFlag(flags);
        this.setConvertStrings(fromStrs, toStrs);
    }

    public void setMatchingFlag(int flags) {
        if (this.matchingFlag != flags && this.convertObjects != null) {
            for (int i = 0; i < this.convertObjects.length; ++i) {
                Pattern pattern = (Pattern)this.convertObjects[i][0];
                Pattern newPattern = null;
                newPattern = flags != -1 ? Pattern.compile(pattern.pattern(), flags) : Pattern.compile(pattern.pattern());
                this.convertObjects[i][0] = newPattern;
            }
        }
        this.matchingFlag = flags;
    }

    public int getMatchingFlag() {
        return this.matchingFlag;
    }

    public void setConvertStrings(String[] fromStrs, String[] toStrs) {
        if (toStrs == null && fromStrs == null) {
            this.convertObjects = null;
        } else {
            if (toStrs == null || fromStrs == null || toStrs.length != fromStrs.length) {
                throw new IllegalArgumentException("Invalid ConvertStrings.");
            }
            Object[][] convObjs = new Object[toStrs.length][];
            try {
                for (int i = 0; i < toStrs.length; ++i) {
                    if (fromStrs[i] == null || toStrs[i] == null) {
                        throw new IllegalArgumentException("Invalid ConvertStrings.");
                    }
                    Pattern pattern = null;
                    pattern = this.matchingFlag != -1 ? Pattern.compile(fromStrs[i], this.matchingFlag) : Pattern.compile(fromStrs[i]);
                    convObjs[i] = new Object[]{pattern, toStrs[i]};
                }
            }
            catch (PatternSyntaxException pe) {
                throw new IllegalArgumentException("Invalid ConvertStrings.");
            }
            catch (IllegalArgumentException ie) {
                throw new IllegalArgumentException("Invalid ConvertStrings.");
            }
            this.convertObjects = convObjs;
        }
    }

    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        return this.convert((String)(obj instanceof String ? obj : String.valueOf(obj)));
    }

    public String convert(String str) throws ConvertException {
        String result = str;
        Object[][] convObjects = this.convertObjects;
        if (convObjects != null) {
            for (int i = 0; i < convObjects.length; ++i) {
                Pattern pattern = (Pattern)convObjects[i][0];
                Matcher matcher = pattern.matcher(result);
                result = matcher.replaceAll((String)convObjects[i][1]);
            }
        }
        return result;
    }
}

