/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.Converter;

public class NumberCastConverter
implements Converter {
    private Class returnType = Double.class;

    public NumberCastConverter() {
    }

    public NumberCastConverter(Class type) {
        this.setReturnType(type);
    }

    public void setReturnType(Class type) {
        if (!(type == null || type.equals(BigDecimal.class) || type.equals(BigInteger.class) || type.equals(Double.class) || type.equals(Float.class) || type.equals(Long.class) || type.equals(Integer.class) || type.equals(Short.class) || type.equals(Byte.class) || type.isPrimitive() || !type.isPrimitive() || !type.equals(Boolean.TYPE) && !type.equals(Character.TYPE))) {
            throw new IllegalArgumentException("Unsupported type." + type.getName());
        }
        if (type.isPrimitive()) {
            if (type.equals(Byte.TYPE)) {
                this.returnType = Byte.class;
            } else if (type.equals(Short.TYPE)) {
                this.returnType = Short.class;
            } else if (type.equals(Integer.TYPE)) {
                this.returnType = Integer.class;
            } else if (type.equals(Long.TYPE)) {
                this.returnType = Long.class;
            } else if (type.equals(Float.TYPE)) {
                this.returnType = Float.class;
            } else if (type.equals(Double.TYPE)) {
                this.returnType = Double.class;
            }
        } else {
            this.returnType = type;
        }
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.equals(this.returnType)) {
            return obj;
        }
        Number retVal = null;
        if (obj instanceof Number) {
            retVal = (Number)obj;
        } else if (obj instanceof String) {
            try {
                retVal = new BigDecimal((String)obj);
            }
            catch (NumberFormatException e) {
                throw new ConvertException(e);
            }
        } else {
            return obj;
        }
        if (this.returnType.equals(BigDecimal.class)) {
            if (clazz.equals(BigInteger.class)) {
                return new BigDecimal((BigInteger)retVal);
            }
            if (clazz.equals(Double.class) || clazz.equals(Float.class)) {
                return new BigDecimal(retVal.doubleValue());
            }
            return BigDecimal.valueOf(retVal.longValue());
        }
        if (this.returnType.equals(BigInteger.class)) {
            if (clazz.equals(BigDecimal.class)) {
                return ((BigDecimal)retVal).toBigInteger();
            }
            return BigInteger.valueOf(retVal.longValue());
        }
        if (this.returnType.equals(Double.class)) {
            return new Double(retVal.doubleValue());
        }
        if (this.returnType.equals(Float.class)) {
            return new Float(retVal.floatValue());
        }
        if (this.returnType.equals(Long.class)) {
            return new Long(retVal.longValue());
        }
        if (this.returnType.equals(Integer.class)) {
            return new Integer(retVal.intValue());
        }
        if (this.returnType.equals(Short.class)) {
            return new Short(retVal.shortValue());
        }
        return new Byte(retVal.byteValue());
    }
}

