/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.beans.PropertyEditor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.IndexedProperty;
import jp.ossc.nimbus.beans.MappedProperty;
import jp.ossc.nimbus.beans.NimbusPropertyEditorManager;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.DefaultPropertySchema;
import jp.ossc.nimbus.beans.dataset.Header;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordListPropertySchema;
import jp.ossc.nimbus.beans.dataset.RecordPropertySchema;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.util.ClassMappingTree;
import jp.ossc.nimbus.util.converter.BindingStreamConverter;
import jp.ossc.nimbus.util.converter.BufferedStreamConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.Converter;
import jp.ossc.nimbus.util.converter.StreamStringConverter;

public class BeanJSONConverter
extends BufferedStreamConverter
implements BindingStreamConverter,
StreamStringConverter {
    private static final String STRING_ENCLOSURE = "\"";
    private static final String ARRAY_SEPARATOR = ",";
    private static final String ARRAY_ENCLOSURE_START = "[";
    private static final String ARRAY_ENCLOSURE_END = "]";
    private static final String OBJECT_ENCLOSURE_START = "{";
    private static final String OBJECT_ENCLOSURE_END = "}";
    private static final String PROPERTY_SEPARATOR = ":";
    private static final String NULL_VALUE = "null";
    private static final String BOOLEAN_VALUE_TRUE = "true";
    private static final String BOOLEAN_VALUE_FALSE = "false";
    private static final char ESCAPE = '\\';
    private static final char QUOTE = '\"';
    private static final char BACK_SLASH = '\\';
    private static final char SLASH = '/';
    private static final char BACK_SPACE = '\b';
    private static final char BACK_SPACE_CHAR = 'b';
    private static final char CHANGE_PAGE = '\f';
    private static final char CHANGE_PAGE_CHAR = 'f';
    private static final char LF = '\n';
    private static final char LF_CHAR = 'n';
    private static final char CR = '\r';
    private static final char CR_CHAR = 'r';
    private static final char TAB = '\t';
    private static final char TAB_CHAR = 't';
    private static final String ESCAPE_QUOTE = "\\\"";
    private static final String ESCAPE_BACK_SLASH = "\\\\";
    private static final String ESCAPE_SLASH = "\\/";
    private static final String ESCAPE_BACK_SPACE = "\\b";
    private static final String ESCAPE_CHANGE_PAGE = "\\f";
    private static final String ESCAPE_LF = "\\n";
    private static final String ESCAPE_CR = "\\r";
    private static final String ESCAPE_TAB = "\\t";
    private static final String UTF8 = "UTF-8";
    private static final String UTF16 = "UTF-16";
    private static final String UTF16BE = "UTF-16BE";
    private static final String UTF16LE = "UTF-16LE";
    private static String UTF8_BOM;
    private static String UTF16_BOM_LE;
    private static String UTF16_BOM_BE;
    public static final int OBJECT_FROM_JSON = 1;
    public static final int JSON_FROM_OBJECT = 2;
    protected int convertType;
    protected String characterEncodingToStream;
    protected String characterEncodingToObject;
    protected PropertyAccess propertyAccess = new PropertyAccess();
    protected boolean isIgnoreUnknownProperty;
    protected boolean isCloneBindingObject;
    protected Set disableClassNameSet;
    protected boolean isJSONP;
    protected boolean isWrappedDataSet;
    protected boolean isCapitalizeBeanProperty;
    protected boolean isOutputNullProperty = true;
    protected static final ClassMappingTree parseConverterMap;
    protected static final ClassMappingTree formatConverterMap;

    public BeanJSONConverter() {
        this(1);
    }

    public BeanJSONConverter(int type) {
        this.convertType = type;
        this.disableClassNameSet = new HashSet();
        this.disableClassNameSet.add(Class.class.getName());
        this.disableClassNameSet.add(Method.class.getName());
        this.disableClassNameSet.add(Field.class.getName());
        this.disableClassNameSet.add(Constructor.class.getName());
        this.disableClassNameSet.add(Object.class.getName());
    }

    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void setCharacterEncodingToStream(String encoding) {
        this.characterEncodingToStream = encoding;
    }

    public String getCharacterEncodingToStream() {
        return this.characterEncodingToStream;
    }

    public void setCharacterEncodingToObject(String encoding) {
        this.characterEncodingToObject = encoding;
    }

    public String getCharacterEncodingToObject() {
        return this.characterEncodingToObject;
    }

    public void setIgnoreUnknownProperty(boolean isIgnore) {
        this.isIgnoreUnknownProperty = isIgnore;
    }

    public boolean isIgnoreUnknownProperty() {
        return this.isIgnoreUnknownProperty;
    }

    public void setCloneBindingObject(boolean isClone) {
        this.isCloneBindingObject = isClone;
    }

    public boolean isCloneBindingObject() {
        return this.isCloneBindingObject;
    }

    public void addDisableClassName(String className) {
        this.disableClassNameSet.add(className);
    }

    public void addDisableClassNames(String[] classNames) {
        for (int i = 0; i < classNames.length; ++i) {
            this.disableClassNameSet.add(classNames[i]);
        }
    }

    public Set getDisableClassNameSet() {
        return this.disableClassNameSet;
    }

    public void setJSONP(boolean isJSONP) {
        this.isJSONP = isJSONP;
    }

    public boolean isJSONP() {
        return this.isJSONP;
    }

    public void setWrappedDataSet(boolean isWrapped) {
        this.isWrappedDataSet = isWrapped;
    }

    public boolean isWrappedDataSet() {
        return this.isWrappedDataSet;
    }

    public void setCapitalizeBeanProperty(boolean isCapitalize) {
        this.isCapitalizeBeanProperty = isCapitalize;
    }

    public boolean isCapitalizeBeanProperty() {
        return this.isCapitalizeBeanProperty;
    }

    public void setOutputNullProperty(boolean isOutput) {
        this.isOutputNullProperty = isOutput;
    }

    public boolean isOutputNullProperty() {
        return this.isOutputNullProperty;
    }

    public void setParseConverter(String className, Converter converter) throws ClassNotFoundException {
        this.setParseConverter(Utility.convertStringToClass(className), converter);
    }

    public void setParseConverter(Class type, Converter converter) {
        parseConverterMap.add(type, converter);
    }

    public void setFormatConverter(String className, Converter converter) throws ClassNotFoundException {
        this.setFormatConverter(Utility.convertStringToClass(className), converter);
    }

    public void setFormatConverter(Class type, Converter converter) {
        formatConverterMap.add(type, converter);
    }

    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        switch (this.convertType) {
            case 1: {
                return this.convertToStream(obj);
            }
            case 2: {
                if (obj instanceof File) {
                    return this.toObject((File)obj);
                }
                if (obj instanceof InputStream) {
                    return this.toObject((InputStream)obj);
                }
                throw new ConvertException("Invalid input type : " + obj.getClass());
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }

    protected byte[] convertToByteArray(Object obj) throws ConvertException {
        return this.toJSON(obj);
    }

    public Object convertToObject(InputStream is) throws ConvertException {
        return this.toObject(is);
    }

    public Object convertToObject(InputStream is, Object returnType) throws ConvertException {
        return this.toObject(is, returnType);
    }

    protected byte[] toJSON(Object obj) throws ConvertException {
        byte[] result = null;
        try {
            StringBuffer buf = new StringBuffer();
            this.appendValue(buf, null, obj, new HashSet());
            String str = buf.toString();
            result = this.characterEncodingToStream == null ? str.getBytes() : str.getBytes(this.characterEncodingToStream);
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        return result;
    }

    private StringBuffer appendName(StringBuffer buf, String name) {
        buf.append(STRING_ENCLOSURE);
        buf.append(this.escape(name));
        buf.append(STRING_ENCLOSURE);
        return buf;
    }

    private StringBuffer appendValue(StringBuffer buf, Class type, Object value, Set instanceSet) {
        Converter converter;
        if (type == null && value != null) {
            type = value.getClass();
        }
        if (type != null && (converter = (Converter)formatConverterMap.getValue(type)) != null) {
            value = converter.convert(value);
            if (Number.class.isAssignableFrom(type) || type.isPrimitive()) {
                if (value == null) {
                    buf.append(NULL_VALUE);
                } else {
                    buf.append(value);
                }
            } else if (value == null) {
                buf.append(NULL_VALUE);
            } else {
                buf.append(STRING_ENCLOSURE);
                buf.append(this.escape(value.toString()));
                buf.append(STRING_ENCLOSURE);
            }
            return buf;
        }
        if (value == null) {
            if (type == null) {
                buf.append(NULL_VALUE);
            } else if (type.isPrimitive() && (Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Float.TYPE.equals(type) || Double.TYPE.equals(type))) {
                buf.append('0');
            } else if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
                buf.append(BOOLEAN_VALUE_FALSE);
            } else {
                buf.append(NULL_VALUE);
            }
        } else if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    buf.append(BOOLEAN_VALUE_TRUE);
                } else {
                    buf.append(BOOLEAN_VALUE_FALSE);
                }
            } else {
                buf.append(value);
            }
        } else if (Number.class.isAssignableFrom(type) || type.isPrimitive() && (Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Float.TYPE.equals(type) || Double.TYPE.equals(type))) {
            if (value instanceof Float && (((Float)value).isNaN() || ((Float)value).isInfinite()) || value instanceof Double && (((Double)value).isNaN() || ((Double)value).isInfinite())) {
                buf.append(STRING_ENCLOSURE);
                buf.append(this.escape(value.toString()));
                buf.append(STRING_ENCLOSURE);
            } else {
                buf.append(value);
            }
        } else if (type.isArray() || Collection.class.isAssignableFrom(type)) {
            this.appendArray(buf, value, instanceSet);
        } else if (DataSet.class.isAssignableFrom(type)) {
            if (instanceSet.contains(value)) {
                return buf;
            }
            DataSet dataSet = (DataSet)value;
            if (this.isWrappedDataSet) {
                Header header = dataSet.getHeader();
                if (header != null) {
                    this.appendValue(buf, null, header, instanceSet);
                } else {
                    RecordList list = dataSet.getRecordList();
                    if (list != null) {
                        this.appendValue(buf, null, list, instanceSet);
                    }
                }
            } else {
                int i;
                instanceSet.add(value);
                buf.append(OBJECT_ENCLOSURE_START);
                String[] names = dataSet.getHeaderNames();
                boolean isAppend = names.length != 0;
                int imax = names.length;
                for (i = 0; i < imax; ++i) {
                    String headerName = names[i];
                    Header header = dataSet.getHeader(headerName);
                    this.appendName(buf, headerName);
                    buf.append(PROPERTY_SEPARATOR);
                    this.appendValue(buf, null, header, instanceSet);
                    if (i == imax - 1) continue;
                    buf.append(ARRAY_SEPARATOR);
                }
                names = dataSet.getRecordListNames();
                if (isAppend && names.length != 0) {
                    buf.append(ARRAY_SEPARATOR);
                }
                imax = names.length;
                for (i = 0; i < imax; ++i) {
                    String recListName = names[i];
                    RecordList recList = dataSet.getRecordList(recListName);
                    this.appendName(buf, recListName);
                    buf.append(PROPERTY_SEPARATOR);
                    this.appendValue(buf, null, recList, instanceSet);
                    if (i == imax - 1) continue;
                    buf.append(ARRAY_SEPARATOR);
                }
                buf.append(OBJECT_ENCLOSURE_END);
                instanceSet.remove(value);
            }
        } else if (Record.class.isAssignableFrom(type)) {
            if (instanceSet.contains(value)) {
                return buf;
            }
            instanceSet.add(value);
            Record record = (Record)value;
            RecordSchema schema = record.getRecordSchema();
            if (schema == null) {
                throw new ConvertException("Schema is null.");
            }
            PropertySchema[] propSchemata = schema.getPropertySchemata();
            boolean isOutput = false;
            buf.append(OBJECT_ENCLOSURE_START);
            int imax = propSchemata.length;
            for (int i = 0; i < imax; ++i) {
                String key = propSchemata[i].getName();
                Object val = record.getProperty(key);
                if (isOutput) {
                    buf.append(ARRAY_SEPARATOR);
                }
                if (val == null && !this.isOutputNullProperty) continue;
                this.appendName(buf, key == null ? key : key.toString());
                buf.append(PROPERTY_SEPARATOR);
                Object formatProp = val;
                if (propSchemata[i] instanceof DefaultPropertySchema && ((DefaultPropertySchema)propSchemata[i]).getFormatConverter() != null) {
                    formatProp = record.getFormatProperty(i);
                }
                if (formatProp == null) {
                    this.appendValue(buf, propSchemata[i].getType(), null, instanceSet);
                } else {
                    Class<?> propType = propSchemata[i].getType();
                    if (propType == null) {
                        propType = val.getClass();
                    }
                    if (propType.isArray() || (class$java$util$Collection == null ? BeanJSONConverter.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(propType)) {
                        this.appendArray(buf, formatProp, instanceSet);
                    } else if ((class$java$lang$Number == null ? BeanJSONConverter.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(propType) || propType.isPrimitive() && (Byte.TYPE.equals(propType) || Short.TYPE.equals(propType) || Integer.TYPE.equals(propType) || Long.TYPE.equals(propType) || Float.TYPE.equals(propType) || Double.TYPE.equals(propType) || Boolean.TYPE.equals(propType)) || (class$java$lang$Boolean == null ? BeanJSONConverter.class$("java.lang.Boolean") : class$java$lang$Boolean).equals(propType)) {
                        this.appendValue(buf, propType, formatProp, instanceSet);
                    } else {
                        this.appendValue(buf, null, formatProp, instanceSet);
                    }
                }
                isOutput = true;
            }
            buf.append(OBJECT_ENCLOSURE_END);
            instanceSet.remove(value);
        } else if (Map.class.isAssignableFrom(type)) {
            if (instanceSet.contains(value)) {
                return buf;
            }
            instanceSet.add(value);
            Map map = (Map)value;
            Object[] keys = map.keySet().toArray();
            boolean isOutput = false;
            buf.append(OBJECT_ENCLOSURE_START);
            int imax = keys.length;
            for (int i = 0; i < imax; ++i) {
                Object key = keys[i];
                Object val = map.get(key);
                if (val != null && this.disableClassNameSet.contains(val.getClass().getName()) || val == null && !this.isOutputNullProperty) continue;
                if (isOutput) {
                    buf.append(ARRAY_SEPARATOR);
                }
                this.appendName(buf, key == null ? (String)key : key.toString());
                buf.append(PROPERTY_SEPARATOR);
                if (val == null) {
                    this.appendValue(buf, null, null, instanceSet);
                } else {
                    Class<?> propType = val.getClass();
                    if (propType.isArray() || (class$java$util$Collection == null ? BeanJSONConverter.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(propType)) {
                        this.appendArray(buf, val, instanceSet);
                    } else if ((class$java$lang$Number == null ? BeanJSONConverter.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(propType) || propType.isPrimitive() && (Byte.TYPE.equals(propType) || Short.TYPE.equals(propType) || Integer.TYPE.equals(propType) || Long.TYPE.equals(propType) || Float.TYPE.equals(propType) || Double.TYPE.equals(propType) || Boolean.TYPE.equals(propType)) || (class$java$lang$Boolean == null ? BeanJSONConverter.class$("java.lang.Boolean") : class$java$lang$Boolean).equals(propType)) {
                        this.appendValue(buf, propType, val, instanceSet);
                    } else {
                        this.appendValue(buf, null, val, instanceSet);
                    }
                }
                isOutput = true;
            }
            buf.append(OBJECT_ENCLOSURE_END);
            instanceSet.remove(value);
        } else if (String.class.isAssignableFrom(type)) {
            buf.append(STRING_ENCLOSURE);
            buf.append(this.escape(value.toString()));
            buf.append(STRING_ENCLOSURE);
        } else {
            if (instanceSet.contains(value)) {
                return buf;
            }
            instanceSet.add(value);
            buf.append(OBJECT_ENCLOSURE_START);
            SimpleProperty[] props = SimpleProperty.getProperties(value);
            try {
                boolean isOutput = false;
                int imax = props.length;
                for (int i = 0; i < imax; ++i) {
                    Object propValue;
                    if (!props[i].isReadable(value) || (propValue = props[i].getProperty(value)) == value || propValue != null && this.disableClassNameSet.contains(propValue.getClass().getName()) || propValue == null && !this.isOutputNullProperty) continue;
                    if (isOutput) {
                        buf.append(ARRAY_SEPARATOR);
                    }
                    if (this.isCapitalizeBeanProperty) {
                        char uppercaseChar;
                        char firstChar;
                        String propName = props[i].getPropertyName();
                        if (propName.length() != 0 && Character.isLowerCase(propName.charAt(0)) && (firstChar = propName.charAt(0)) != (uppercaseChar = Character.toUpperCase(firstChar))) {
                            propName = uppercaseChar + propName.substring(1);
                        }
                        this.appendName(buf, propName);
                    } else {
                        this.appendName(buf, props[i].getPropertyName());
                    }
                    buf.append(PROPERTY_SEPARATOR);
                    Class<?> propType = props[i].getPropertyType(value);
                    this.appendValue(buf, (Class)(propType == null ? (propValue == null ? null : propValue.getClass()) : propType), propValue, instanceSet);
                    isOutput = true;
                }
            }
            catch (NoSuchPropertyException e) {
                throw new ConvertException(e);
            }
            catch (InvocationTargetException e) {
                throw new ConvertException(e);
            }
            buf.append(OBJECT_ENCLOSURE_END);
            instanceSet.remove(value);
        }
        return buf;
    }

    private StringBuffer appendArray(StringBuffer buf, Object array, Set instanceSet) {
        if (instanceSet.contains(array)) {
            return buf;
        }
        instanceSet.add(array);
        buf.append(ARRAY_ENCLOSURE_START);
        if (array.getClass().isArray()) {
            if (this.disableClassNameSet.contains(array.getClass().getComponentType().getName())) {
                return buf;
            }
            int imax = Array.getLength(array);
            for (int i = 0; i < imax; ++i) {
                Object element = Array.get(array, i);
                this.appendValue(buf, element == null ? array.getClass().getComponentType() : element.getClass(), element, instanceSet);
                if (i == imax - 1) continue;
                buf.append(ARRAY_SEPARATOR);
            }
        } else if (List.class.isAssignableFrom(array.getClass())) {
            List list = (List)array;
            boolean isOutput = false;
            int imax = list.size();
            for (int i = 0; i < imax; ++i) {
                Object val = list.get(i);
                if (val != null && this.disableClassNameSet.contains(val.getClass().getName())) continue;
                if (isOutput) {
                    buf.append(ARRAY_SEPARATOR);
                }
                this.appendValue(buf, null, val, instanceSet);
                isOutput = true;
            }
        } else if (Collection.class.isAssignableFrom(array.getClass())) {
            Iterator itr = ((Collection)array).iterator();
            boolean isOutput = false;
            while (itr.hasNext()) {
                Object val = itr.next();
                if (val != null && this.disableClassNameSet.contains(val.getClass().getName())) continue;
                if (isOutput) {
                    buf.append(ARRAY_SEPARATOR);
                }
                this.appendValue(buf, null, val, instanceSet);
                isOutput = true;
            }
        }
        buf.append(ARRAY_ENCLOSURE_END);
        instanceSet.remove(array);
        return buf;
    }

    private String escape(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        boolean isEscape = false;
        StringBuffer buf = new StringBuffer();
        int imax = str.length();
        block10: for (int i = 0; i < imax; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append(ESCAPE_QUOTE);
                    isEscape = true;
                    continue block10;
                }
                case '\\': {
                    buf.append(ESCAPE_BACK_SLASH);
                    isEscape = true;
                    continue block10;
                }
                case '/': {
                    buf.append(ESCAPE_SLASH);
                    isEscape = true;
                    continue block10;
                }
                case '\b': {
                    buf.append(ESCAPE_BACK_SPACE);
                    isEscape = true;
                    continue block10;
                }
                case '\f': {
                    buf.append(ESCAPE_CHANGE_PAGE);
                    isEscape = true;
                    continue block10;
                }
                case '\n': {
                    buf.append(ESCAPE_LF);
                    isEscape = true;
                    continue block10;
                }
                case '\r': {
                    buf.append(ESCAPE_CR);
                    isEscape = true;
                    continue block10;
                }
                case '\t': {
                    buf.append(ESCAPE_TAB);
                    isEscape = true;
                    continue block10;
                }
                default: {
                    if (!(c == ' ' || c == '!' || '#' <= c && c <= '[' || ']' <= c && c <= '~')) {
                        isEscape = true;
                        this.toUnicode(c, buf);
                        continue block10;
                    }
                    buf.append(c);
                }
            }
        }
        return isEscape ? buf.toString() : str;
    }

    private StringBuffer toUnicode(char c, StringBuffer buf) {
        buf.append('\\');
        buf.append('u');
        int mask = 61440;
        block18: for (int i = 0; i < 4; ++i) {
            mask = 61440 >> i * 4;
            int val = c & mask;
            switch (val <<= i * 4) {
                case 0: {
                    buf.append('0');
                    continue block18;
                }
                case 4096: {
                    buf.append('1');
                    continue block18;
                }
                case 8192: {
                    buf.append('2');
                    continue block18;
                }
                case 12288: {
                    buf.append('3');
                    continue block18;
                }
                case 16384: {
                    buf.append('4');
                    continue block18;
                }
                case 20480: {
                    buf.append('5');
                    continue block18;
                }
                case 24576: {
                    buf.append('6');
                    continue block18;
                }
                case 28672: {
                    buf.append('7');
                    continue block18;
                }
                case 32768: {
                    buf.append('8');
                    continue block18;
                }
                case 36864: {
                    buf.append('9');
                    continue block18;
                }
                case 40960: {
                    buf.append('a');
                    continue block18;
                }
                case 45056: {
                    buf.append('b');
                    continue block18;
                }
                case 49152: {
                    buf.append('c');
                    continue block18;
                }
                case 53248: {
                    buf.append('d');
                    continue block18;
                }
                case 57344: {
                    buf.append('e');
                    continue block18;
                }
                case 61440: {
                    buf.append('f');
                    continue block18;
                }
            }
        }
        return buf;
    }

    protected Object toObject(File file) throws ConvertException {
        try {
            return this.toObject(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
    }

    protected Object toObject(InputStream is) throws ConvertException {
        return this.toObject(is, null);
    }

    protected Object toObject(InputStream is, Object returnType) throws ConvertException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Object[] jsonObj = null;
        try {
            StringReader reader;
            int c;
            int length = 0;
            byte[] buf = new byte[1024];
            while ((length = is.read(buf)) != -1) {
                baos.write(buf, 0, length);
            }
            String dataStr = this.characterEncodingToObject == null ? new String(baos.toByteArray()) : new String(baos.toByteArray(), this.characterEncodingToObject);
            dataStr = this.removeBOM(dataStr);
            dataStr = this.fromUnicode(dataStr);
            if (this.isJSONP) {
                int startIndex = dataStr.indexOf(40);
                int endIndex = dataStr.lastIndexOf(41);
                if (startIndex != -1 && endIndex != -1 && startIndex < endIndex) {
                    dataStr = dataStr.substring(startIndex + 1, endIndex);
                }
            }
            Class<?> componentType = null;
            if (returnType != null) {
                if (returnType instanceof Class) {
                    Class returnClass = (Class)((Object)returnType);
                    if (returnClass.isArray()) {
                        jsonObj = new ArrayList();
                        componentType = returnClass.getComponentType();
                    } else {
                        try {
                            jsonObj = returnClass.newInstance();
                        }
                        catch (InstantiationException e) {
                            throw new ConvertException(e);
                        }
                        catch (IllegalAccessException e) {
                            throw new ConvertException(e);
                        }
                    }
                } else {
                    jsonObj = returnType;
                    if (this.isCloneBindingObject) {
                        if (jsonObj instanceof DataSet) {
                            jsonObj = ((DataSet)jsonObj).cloneSchema();
                        } else if (jsonObj instanceof RecordList) {
                            jsonObj = ((RecordList)jsonObj).cloneSchema();
                        } else if (jsonObj instanceof Record) {
                            jsonObj = ((Record)jsonObj).cloneSchema();
                        } else if (jsonObj instanceof Cloneable) {
                            try {
                                jsonObj = jsonObj.getClass().getMethod("clone", null).invoke((Object)jsonObj, (Object[])null);
                            }
                            catch (NoSuchMethodException e) {
                                throw new ConvertException(e);
                            }
                            catch (IllegalAccessException e) {
                                throw new ConvertException(e);
                            }
                            catch (InvocationTargetException e) {
                                throw new ConvertException(e);
                            }
                        }
                    }
                }
            }
            if ((c = this.skipWhitespace(reader = new StringReader(dataStr))) == -1) {
                throw new ConvertException("It reached EOF on the way.");
            }
            switch (c) {
                case 123: {
                    if (jsonObj == null) {
                        jsonObj = new HashMap();
                    }
                    this.readJSONObject(reader, new StringBuffer(), jsonObj instanceof DataSet && this.isWrappedDataSet ? ((DataSet)jsonObj).getHeader() : jsonObj, null, jsonObj instanceof DataSet ? (DataSet)jsonObj : null);
                    break;
                }
                case 91: {
                    if (jsonObj == null) {
                        jsonObj = new ArrayList();
                    }
                    this.readJSONArray(reader, new StringBuffer(), componentType, jsonObj instanceof DataSet && this.isWrappedDataSet ? ((DataSet)jsonObj).getRecordList() : (List)jsonObj, jsonObj instanceof DataSet ? (DataSet)jsonObj : null);
                    if (componentType != null) {
                        jsonObj = ((List)jsonObj).toArray((Object[])Array.newInstance(componentType, ((List)jsonObj).size()));
                    }
                    break;
                }
                default: {
                    throw new ConvertException("Not json." + dataStr);
                }
            }
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        return jsonObj;
    }

    private int readJSONObject(Reader reader, StringBuffer buf, Object jsonObj, MappedProperty mappedProp, DataSet dataSet) throws ConvertException, IOException {
        int c = 0;
        do {
            if ((c = this.readJSONProperty(reader, buf, jsonObj, mappedProp, dataSet)) != -1) continue;
            throw new ConvertException("It reached EOF on the way.");
        } while (c == 44);
        return c;
    }

    private int readJSONArray(Reader reader, StringBuffer buf, Class componentType, List array, DataSet dataSet) throws ConvertException, IOException {
        buf.setLength(0);
        int c = 0;
        block8: do {
            c = this.skipWhitespace(reader);
            Object[] value = null;
            switch (c) {
                case 34: {
                    while ((c = reader.read()) != -1 && c != 34) {
                        if (c == 92) {
                            buf.append((char)c);
                            c = reader.read();
                            if (c == -1) break;
                        }
                        buf.append((char)c);
                    }
                    if (((String)(value = this.unescape(buf.toString()))).length() != 0 && componentType != null && !(class$java$lang$String == null ? BeanJSONConverter.class$("java.lang.String") : class$java$lang$String).equals(componentType)) {
                        value = this.toPrimitive((String)value, componentType);
                    }
                    if (c == -1) {
                        throw new ConvertException("It reached EOF on the way.");
                    }
                    c = this.skipWhitespace(reader);
                    break;
                }
                case 123: {
                    if (array instanceof RecordList) {
                        value = ((RecordList)array).createRecord();
                    } else if (componentType == null) {
                        value = new HashMap();
                    } else {
                        try {
                            value = componentType.newInstance();
                        }
                        catch (InstantiationException e) {
                            throw new ConvertException(e);
                        }
                        catch (IllegalAccessException e) {
                            throw new ConvertException(e);
                        }
                    }
                    c = this.readJSONObject(reader, buf, value, null, dataSet);
                    if (c == -1) {
                        throw new ConvertException("It reached EOF on the way.");
                    }
                    c = this.skipWhitespace(reader);
                    break;
                }
                case 91: {
                    value = new ArrayList();
                    Class<?> nestComponentType = null;
                    if (componentType != null) {
                        if (componentType.isArray()) {
                            nestComponentType = componentType.getComponentType();
                        } else {
                            throw new ConvertException("ComponentType is not multidimentional array. " + componentType);
                        }
                    }
                    c = this.readJSONArray(reader, buf, nestComponentType, (List)value, dataSet);
                    if (nestComponentType != null) {
                        value = ((List)value).toArray((Object[])Array.newInstance(nestComponentType, ((List)value).size()));
                    }
                    if (c == -1) {
                        throw new ConvertException("It reached EOF on the way.");
                    }
                    c = this.skipWhitespace(reader);
                    break;
                }
                default: {
                    while (c != -1 && c != 44 && c != 93 && c != 125 && !Character.isWhitespace((char)c)) {
                        buf.append((char)c);
                        c = reader.read();
                    }
                    if (c == -1) {
                        throw new ConvertException("It reached EOF on the way.");
                    }
                    String str = this.unescape(buf.toString());
                    if (NULL_VALUE.equals(str)) {
                        value = null;
                        break;
                    }
                    if (str.length() != 0) {
                        value = this.toPrimitive(str, componentType);
                        break;
                    }
                    buf.setLength(0);
                    continue block8;
                }
            }
            array.add(value);
            buf.setLength(0);
        } while (c == 44);
        return c;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readJSONProperty(Reader reader, StringBuffer buf, Object jsonObj, MappedProperty mappedProp, DataSet dataSet) throws ConvertException, IOException {
        void var10_35;
        RecordSchema schema;
        buf.setLength(0);
        int c = this.skipWhitespace(reader);
        if (c == 34) {
            while ((c = reader.read()) != -1 && c != 34) {
                if (c == 92) {
                    buf.append((char)c);
                    c = reader.read();
                    if (c == -1) break;
                }
                buf.append((char)c);
            }
        } else {
            if (c != 125) throw new ConvertException("JSON name must be enclosed '\"'.");
            return c;
        }
        String name = this.unescape(buf.toString());
        buf.setLength(0);
        c = reader.read();
        if (c != 58) {
            throw new ConvertException("JSON name and value must be separated ':'.");
        }
        c = reader.read();
        Class propType = null;
        boolean isUnknownProperty = false;
        Object var10_10 = null;
        switch (c) {
            case 34: {
                if (jsonObj instanceof DataSet || jsonObj instanceof RecordList) {
                    if (!this.isIgnoreUnknownProperty) {
                        throw new ConvertException("Unknown property : " + name);
                    }
                    isUnknownProperty = true;
                }
                while ((c = reader.read()) != -1 && c != 34) {
                    if (c == 92) {
                        buf.append((char)c);
                        c = reader.read();
                        if (c == -1) break;
                    }
                    buf.append((char)c);
                }
                String string = this.unescape(buf.toString());
                if (jsonObj instanceof Record) {
                    Record record = (Record)jsonObj;
                    schema = record.getRecordSchema();
                    PropertySchema propSchema = schema.getPropertySchema(name);
                    if (propSchema == null) {
                        if (!this.isIgnoreUnknownProperty) {
                            throw new ConvertException("Unknown property : " + name);
                        }
                        isUnknownProperty = true;
                    } else {
                        propType = propSchema.getType();
                    }
                } else if (!(jsonObj instanceof Map)) {
                    MappedProperty property = mappedProp != null ? mappedProp : this.propertyAccess.getProperty(name);
                    try {
                        propType = property.getPropertyType(jsonObj);
                    }
                    catch (NoSuchPropertyException e) {
                        if (!this.isIgnoreUnknownProperty) {
                            throw new ConvertException(e);
                        }
                        isUnknownProperty = true;
                    }
                    catch (InvocationTargetException e) {
                        throw new ConvertException(e);
                    }
                }
                if (!isUnknownProperty && propType != null) {
                    Converter converter = (Converter)parseConverterMap.getValue(propType);
                    if (converter != null) {
                        Object object = converter.convert(string);
                    } else if (!(jsonObj instanceof Record) && string.length() != 0 && !String.class.equals(propType)) {
                        Object object = this.toPrimitive(string, propType);
                    }
                }
                if (c == -1) {
                    throw new ConvertException("It reached EOF on the way.");
                }
                c = this.skipWhitespace(reader);
                break;
            }
            case 123: {
                Object objectValue = null;
                MappedProperty mappedProperty = null;
                if (jsonObj instanceof DataSet) {
                    DataSet ds = (DataSet)jsonObj;
                    objectValue = ds.getHeader(name);
                    if (objectValue == null) {
                        if (!this.isIgnoreUnknownProperty) {
                            throw new ConvertException("Unknown header : " + name);
                        }
                        isUnknownProperty = true;
                    }
                } else if (jsonObj instanceof Record) {
                    Record record = (Record)jsonObj;
                    RecordSchema schema2 = record.getRecordSchema();
                    PropertySchema propSchema = schema2.getPropertySchema(name);
                    if (propSchema == null) {
                        if (!this.isIgnoreUnknownProperty) {
                            throw new ConvertException("Unknown nested record : " + name);
                        }
                        isUnknownProperty = true;
                    } else if (propSchema instanceof RecordPropertySchema) {
                        RecordPropertySchema recPropSchema = (RecordPropertySchema)propSchema;
                        if (dataSet != null) {
                            Object object = objectValue = dataSet.createNestedRecord(recPropSchema.getRecordName());
                        } else {
                            objectValue = record.getProperty(name);
                        }
                    } else {
                        propType = propSchema.getType();
                    }
                } else if (!(jsonObj instanceof Map)) {
                    MappedProperty property = mappedProp != null ? mappedProp : this.propertyAccess.getProperty(name);
                    try {
                        propType = property.getPropertyType(jsonObj);
                    }
                    catch (NoSuchPropertyException e) {
                        MappedProperty[] props = MappedProperty.getMappedProperties(jsonObj.getClass(), name);
                        if (props != null) {
                            for (int i = 0; i < props.length; ++i) {
                                if (!props[i].isWritable(jsonObj, null)) continue;
                                mappedProperty = props[i];
                                Object object = objectValue = jsonObj;
                                break;
                            }
                        }
                        if (mappedProperty == null) {
                            if (!this.isIgnoreUnknownProperty) {
                                throw new ConvertException(e);
                            }
                            isUnknownProperty = true;
                        }
                    }
                    catch (InvocationTargetException e) {
                        throw new ConvertException(e);
                    }
                }
                if (propType != null) {
                    try {
                        objectValue = propType.newInstance();
                        Header header = objectValue;
                    }
                    catch (InstantiationException e) {
                        throw new ConvertException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ConvertException(e);
                    }
                }
                if (objectValue == null) {
                    objectValue = new HashMap();
                    Map map = objectValue;
                }
                if ((c = this.readJSONObject(reader, buf, objectValue, mappedProperty, dataSet)) == -1) {
                    throw new ConvertException("It reached EOF on the way.");
                }
                c = this.skipWhitespace(reader);
                if (mappedProperty == null) break;
                return c;
            }
            case 91: {
                Object arrayValue = null;
                Class<?> componentType = null;
                if (jsonObj instanceof DataSet) {
                    DataSet ds = (DataSet)jsonObj;
                    arrayValue = ds.getRecordList(name);
                    if (arrayValue == null) {
                        if (!this.isIgnoreUnknownProperty) {
                            throw new ConvertException("Unknown recordList : " + name);
                        }
                        isUnknownProperty = true;
                    }
                } else if (jsonObj instanceof Record) {
                    Record record = (Record)jsonObj;
                    RecordSchema schema3 = record.getRecordSchema();
                    PropertySchema propSchema = schema3.getPropertySchema(name);
                    if (propSchema == null) {
                        if (!this.isIgnoreUnknownProperty) {
                            throw new ConvertException("Unknown nested recordList : " + name);
                        }
                        isUnknownProperty = true;
                    } else if (propSchema instanceof RecordListPropertySchema) {
                        RecordListPropertySchema recListPropSchema = (RecordListPropertySchema)propSchema;
                        if (dataSet != null) {
                            Object object = arrayValue = dataSet.createNestedRecordList(recListPropSchema.getRecordListName());
                        } else {
                            arrayValue = record.getProperty(name);
                        }
                    } else {
                        propType = propSchema.getType();
                    }
                } else if (!(jsonObj instanceof Map)) {
                    MappedProperty property = mappedProp != null ? mappedProp : this.propertyAccess.getProperty(name);
                    try {
                        propType = property.getPropertyType(jsonObj);
                    }
                    catch (NoSuchPropertyException e) {
                        if (!this.isIgnoreUnknownProperty) {
                            throw new ConvertException(e);
                        }
                        isUnknownProperty = true;
                    }
                    catch (InvocationTargetException e) {
                        throw new ConvertException(e);
                    }
                }
                if (propType != null) {
                    if (!propType.isArray() && !List.class.isAssignableFrom(propType)) {
                        if (!this.isIgnoreUnknownProperty) {
                            throw new ConvertException("Unknown property : " + name);
                        }
                        isUnknownProperty = true;
                    } else if (propType.isArray()) {
                        componentType = propType.getComponentType();
                    }
                }
                if (arrayValue == null) {
                    arrayValue = new ArrayList();
                    List list = arrayValue;
                }
                c = this.readJSONArray(reader, buf, componentType, (List)arrayValue, dataSet);
                if (!isUnknownProperty && componentType != null) {
                    if (componentType.isPrimitive()) {
                        List list = (List)arrayValue;
                        Object object = Array.newInstance(componentType, list.size());
                        IndexedProperty indexdProp = new IndexedProperty("");
                        try {
                            int imax = list.size();
                            for (int i = 0; i < imax; ++i) {
                                indexdProp.setIndex(i);
                                indexdProp.setProperty(object, list.get(i));
                            }
                        }
                        catch (NoSuchPropertyException e) {
                            throw new ConvertException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new ConvertException(e);
                        }
                    } else {
                        Object[] objectArray = ((List)arrayValue).toArray((Object[])Array.newInstance(componentType, ((List)arrayValue).size()));
                    }
                }
                if (c == -1) {
                    throw new ConvertException("It reached EOF on the way.");
                }
                c = this.skipWhitespace(reader);
                break;
            }
            default: {
                String string;
                if (jsonObj instanceof DataSet || jsonObj instanceof RecordList) {
                    if (!this.isIgnoreUnknownProperty) {
                        throw new ConvertException("Unknown property : " + name);
                    }
                    isUnknownProperty = true;
                }
                while (c != -1 && c != 44 && c != 93 && c != 125 && !Character.isWhitespace((char)c)) {
                    buf.append((char)c);
                    c = reader.read();
                }
                if (c == -1) {
                    throw new ConvertException("It reached EOF on the way.");
                }
                String str = this.unescape(buf.toString());
                if (str.length() == 0) {
                    return c;
                }
                if (jsonObj instanceof Record) {
                    Record record = (Record)jsonObj;
                    RecordSchema schema4 = record.getRecordSchema();
                    PropertySchema propSchema = schema4.getPropertySchema(name);
                    if (propSchema == null) {
                        if (!this.isIgnoreUnknownProperty) {
                            throw new ConvertException("Unknown property : " + name);
                        }
                        isUnknownProperty = true;
                    } else {
                        propType = propSchema.getType();
                    }
                } else if (!(jsonObj instanceof Map)) {
                    MappedProperty property = mappedProp != null ? mappedProp : this.propertyAccess.getProperty(name);
                    try {
                        propType = property.getPropertyType(jsonObj);
                    }
                    catch (NoSuchPropertyException e) {
                        if (!this.isIgnoreUnknownProperty) {
                            throw new ConvertException(e);
                        }
                        isUnknownProperty = true;
                    }
                    catch (InvocationTargetException e) {
                        throw new ConvertException(e);
                    }
                }
                if (isUnknownProperty) break;
                Converter converter = null;
                if (propType != null) {
                    converter = (Converter)parseConverterMap.getValue(propType);
                }
                if (NULL_VALUE.equals(str)) {
                    Object var10_31 = null;
                    if (converter == null) break;
                    Object object = converter.convert(var10_31);
                    break;
                }
                if (converter != null) {
                    Object object = converter.convert(str);
                    break;
                }
                String string2 = string = jsonObj instanceof Record ? str : this.toPrimitive(str, propType);
            }
        }
        if (isUnknownProperty || var10_35 == null) return c;
        if (mappedProp != null) {
            try {
                mappedProp.setKey(name);
                mappedProp.setProperty(jsonObj, var10_35);
                return c;
            }
            catch (NoSuchPropertyException e) {
                if (this.isIgnoreUnknownProperty) return c;
                throw new ConvertException(e);
            }
            catch (InvocationTargetException e) {
                throw new ConvertException(e);
            }
        }
        if (jsonObj instanceof Record) {
            Record rec = (Record)jsonObj;
            if (this.isIgnoreUnknownProperty && (schema = rec.getRecordSchema()) != null && schema.getPropertyIndex(name) == -1) {
                return c;
            }
            rec.setParseProperty(name, (Object)var10_35);
            return c;
        }
        if (jsonObj instanceof Map) {
            ((Map)jsonObj).put(name, var10_35);
            return c;
        }
        if (isUnknownProperty) return c;
        try {
            this.propertyAccess.set(jsonObj, name, var10_35);
            return c;
        }
        catch (NoSuchPropertyException e) {
            if (this.isIgnoreUnknownProperty) return c;
            throw new ConvertException(e);
        }
        catch (InvocationTargetException e) {
            throw new ConvertException(e);
        }
    }

    private Object toPrimitive(String str, Class propType) throws ConvertException {
        if (propType == null) {
            if (str.toLowerCase().equals(BOOLEAN_VALUE_TRUE) || str.toLowerCase().equals(BOOLEAN_VALUE_FALSE)) {
                return new Boolean(str);
            }
            if (str.indexOf(46) == -1) {
                try {
                    return new BigInteger(str);
                }
                catch (NumberFormatException e) {
                    throw new ConvertException(e);
                }
            }
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException e) {
                throw new ConvertException(e);
            }
        }
        if (propType.isPrimitive() || Number.class.isAssignableFrom(propType) || Boolean.class.isAssignableFrom(propType)) {
            PropertyEditor editor = NimbusPropertyEditorManager.findEditor(propType);
            if (editor == null) {
                throw new ConvertException("PropertyEditor not found : " + propType);
            }
            try {
                editor.setAsText(str);
                return editor.getValue();
            }
            catch (Exception e) {
                throw new ConvertException(e);
            }
        }
        throw new ConvertException("Not number type : " + propType);
    }

    private String removeBOM(String str) {
        if (this.characterEncodingToObject != null) {
            if (UTF8.equals(this.characterEncodingToObject)) {
                if (UTF8_BOM != null && str.startsWith(UTF8_BOM)) {
                    str = str.substring(UTF8_BOM.length());
                }
            } else if (UTF16.equals(this.characterEncodingToObject)) {
                if (UTF16_BOM_LE != null && str.startsWith(UTF16_BOM_LE)) {
                    str = str.substring(UTF16_BOM_LE.length());
                } else if (UTF16_BOM_BE != null && str.startsWith(UTF16_BOM_BE)) {
                    str = str.substring(UTF16_BOM_BE.length());
                }
            } else if (UTF16LE.equals(this.characterEncodingToObject)) {
                if (UTF16_BOM_LE != null && str.startsWith(UTF16_BOM_LE)) {
                    str = str.substring(UTF16_BOM_LE.length());
                }
            } else if (UTF16BE.equals(this.characterEncodingToObject) && UTF16_BOM_BE != null && str.startsWith(UTF16_BOM_BE)) {
                str = str.substring(UTF16_BOM_BE.length());
            }
        }
        return str;
    }

    private String fromUnicode(String unicodeStr) {
        String str = null;
        if (unicodeStr != null) {
            int length = unicodeStr.length();
            StringBuffer buf = new StringBuffer(length);
            int i = 0;
            while (i < length) {
                char c;
                if ((c = unicodeStr.charAt(i++)) == '\\' && length - 1 > i) {
                    if ((c = unicodeStr.charAt(i++)) == 'u') {
                        int value = 0;
                        block6: for (int j = 0; j < 4; ++j) {
                            c = unicodeStr.charAt(i++);
                            switch (c) {
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    value = (value << 4) + (c - 48);
                                    continue block6;
                                }
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': {
                                    value = (value << 4) + 10 + (c - 97);
                                    continue block6;
                                }
                                case 'A': 
                                case 'B': 
                                case 'C': 
                                case 'D': 
                                case 'E': 
                                case 'F': {
                                    value = (value << 4) + 10 + (c - 65);
                                    continue block6;
                                }
                                default: {
                                    throw new IllegalArgumentException("Failed to convert unicode char is " + c);
                                }
                            }
                        }
                        buf.append((char)value);
                        continue;
                    }
                    buf.append('\\');
                    buf.append(c);
                    continue;
                }
                buf.append(c);
            }
            str = buf.toString();
        }
        return str;
    }

    private String unescape(String str) {
        if (str != null) {
            int length = str.length();
            StringBuffer buf = new StringBuffer(length);
            boolean isUnescape = false;
            int i = 0;
            while (i < length) {
                int c;
                if ((c = str.charAt(i++)) == 92 && length > i) {
                    isUnescape = true;
                    c = str.charAt(i++);
                    switch (c) {
                        case 98: {
                            c = 8;
                            break;
                        }
                        case 102: {
                            c = 12;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                    }
                }
                buf.append((char)c);
            }
            if (isUnescape) {
                str = buf.toString();
            }
        }
        return str;
    }

    private int skipWhitespace(Reader reader) throws IOException {
        int c = 0;
        while ((c = reader.read()) != -1 && Character.isWhitespace((char)c)) {
        }
        return c;
    }

    static {
        try {
            UTF8_BOM = new String(new byte[]{-17, -69, -65}, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            UTF16_BOM_LE = new String(new byte[]{-1, -2}, UTF16);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            UTF16_BOM_BE = new String(new byte[]{-2, -1}, UTF16);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        parseConverterMap = new ClassMappingTree();
        formatConverterMap = new ClassMappingTree();
    }
}

