/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.servlet;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.servlet.BeanFlowSelector;
import jp.ossc.nimbus.servlet.MappingBeanFlowSelectorServiceMBean;

public class MappingBeanFlowSelectorService
extends ServiceBase
implements BeanFlowSelector,
MappingBeanFlowSelectorServiceMBean {
    private static final long serialVersionUID = -6425793191507205445L;
    protected Properties mapping;
    protected boolean isRegexEnabled;
    protected int regexMatchFlag;
    protected Map regexMapping;

    public void setMapping(Properties mapping) {
        this.mapping = mapping;
    }

    public Properties getMapping() {
        return this.mapping;
    }

    public void setRegexEnabled(boolean isEnable) {
        this.isRegexEnabled = isEnable;
    }

    public boolean isRegexEnabled() {
        return this.isRegexEnabled;
    }

    public void setRegexMatchFlag(int flag) {
        this.regexMatchFlag = flag;
    }

    public int getRegexMatchFlag() {
        return this.regexMatchFlag;
    }

    public void startService() throws Exception {
        if (this.mapping != null && this.isRegexEnabled) {
            Iterator<Object> paths = this.mapping.keySet().iterator();
            while (paths.hasNext()) {
                String path = (String)paths.next();
                Pattern pattern = Pattern.compile(path, this.regexMatchFlag);
                if (this.regexMapping == null) {
                    this.regexMapping = new LinkedHashMap();
                }
                this.regexMapping.put(pattern, this.mapping.get(path));
            }
        }
    }

    public String selectBeanFlow(HttpServletRequest req) {
        String flowName;
        String path = req.getPathInfo();
        if (path == null) {
            path = req.getServletPath();
        }
        if (path == null) {
            return null;
        }
        String string = flowName = this.mapping == null ? null : this.mapping.getProperty(path);
        if (flowName == null && this.isRegexEnabled && this.regexMapping != null && this.regexMapping.size() != 0) {
            Iterator patterns = this.regexMapping.keySet().iterator();
            while (patterns.hasNext()) {
                Pattern pattern = (Pattern)patterns.next();
                if (!pattern.matcher(path).matches()) continue;
                flowName = (String)this.regexMapping.get(pattern);
                break;
            }
        }
        return flowName;
    }
}

