/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnableAdaptor;
import jp.ossc.nimbus.service.queue.QueueHandlerContainer;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.service.server.DefaultServerServiceMBean;
import jp.ossc.nimbus.service.server.Request;
import jp.ossc.nimbus.service.server.RequestContext;
import jp.ossc.nimbus.service.server.Response;

public class DefaultServerService
extends ServiceBase
implements DefaultServerServiceMBean {
    private static final long serialVersionUID = 3768227629065502757L;
    private String hostName;
    private int port = 10000;
    private boolean isReuseAddress = true;
    private int receiveBufferSize;
    private int soTimeout;
    private ServiceName queueHandlerContainerServiceName;
    private QueueHandlerContainer queueHandlerContainer;
    private ServiceName sequenceServiceName;
    private Sequence sequence;
    private ServerSocketChannel serverSocketChannel;
    private Selector selector;
    private Daemon dispatchDaemon;

    public void setHostName(String name) {
        this.hostName = name;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setReuseAddress(boolean isReuse) {
        this.isReuseAddress = isReuse;
    }

    public boolean isReuseAddress() {
        return this.isReuseAddress;
    }

    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setQueueHandlerContainerServiceName(ServiceName name) {
        this.queueHandlerContainerServiceName = name;
    }

    public ServiceName getQueueHandlerContainerServiceName() {
        return this.queueHandlerContainerServiceName;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    public void startService() throws Exception {
        if (this.queueHandlerContainerServiceName == null) {
            throw new IllegalArgumentException("QueueHandlerContainerServiceName is null.");
        }
        this.queueHandlerContainer = (QueueHandlerContainer)ServiceManagerFactory.getServiceObject(this.queueHandlerContainerServiceName);
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
        this.dispatchDaemon = new Daemon(new DispatchDaemonRunnable());
        this.dispatchDaemon.setName("Nimbus TCP Server dispatch daemon " + this.getServiceNameObject());
        this.connect();
        this.dispatchDaemon.start();
    }

    private void connect() throws Exception {
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.socket().setReuseAddress(this.isReuseAddress);
        if (this.receiveBufferSize > 0) {
            this.serverSocketChannel.socket().setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.soTimeout > 0) {
            this.serverSocketChannel.socket().setSoTimeout(this.soTimeout);
        }
        this.serverSocketChannel.socket().bind(this.hostName == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.hostName, this.port));
        this.serverSocketChannel.configureBlocking(false);
        this.selector = Selector.open();
        this.serverSocketChannel.register(this.selector, 16);
    }

    private void close() {
        if (this.serverSocketChannel != null) {
            try {
                this.serverSocketChannel.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.selector != null) {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void stopService() throws Exception {
        this.dispatchDaemon.stop();
        this.close();
    }

    private static class ResponseImpl
    implements Response {
        private final Client client;
        private final SelectionKey key;
        private int status;

        protected ResponseImpl(Client client, SelectionKey key) {
            this.client = client;
            this.key = key;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void response() throws IOException {
            this.client.addResponse(this.key, this.status, null);
        }

        public void response(InputStream is) throws IOException {
            this.client.addResponse(this.key, this.status, is);
        }

        public void response(byte[] bytes) throws IOException {
            this.client.addResponse(this.key, this.status, bytes == null ? new ByteArrayInputStream(new byte[0]) : new ByteArrayInputStream(bytes));
        }

        public OutputStream getOutputStream() {
            return new ResponseOutputStream();
        }

        private class ResponseOutputStream
        extends ByteArrayOutputStream {
            private ResponseOutputStream() {
            }

            public void flush() throws IOException {
                super.flush();
                ResponseImpl.this.client.addResponse(ResponseImpl.this.key, ResponseImpl.this.status, new ByteArrayInputStream(this.toByteArray()));
            }
        }
    }

    private static class RequestImpl
    implements Request {
        private final String action;
        private final InputStream requestInputStream;
        private final String requestId;
        private final Date date;
        private final String remoteHost;
        private final int remotePort;

        protected RequestImpl(Client client, String action, String id, InputStream is) {
            this.action = action;
            this.requestId = id;
            this.date = new Date();
            this.requestInputStream = is;
            this.remoteHost = client.socketChannel.socket().getInetAddress().getHostAddress();
            this.remotePort = client.socketChannel.socket().getPort();
        }

        public String getAction() {
            return this.action;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Date getDate() {
            return this.date;
        }

        public String getRemoteHost() {
            return this.remoteHost;
        }

        public int getRemotePort() {
            return this.remotePort;
        }

        public InputStream getInputStream() {
            return this.requestInputStream;
        }
    }

    private static class RequestContextImpl
    implements RequestContext {
        private final RequestImpl request;
        private final ResponseImpl response;

        public RequestContextImpl(RequestImpl req, ResponseImpl res) {
            this.request = req;
            this.response = res;
        }

        public Request getRequest() {
            return this.request;
        }

        public Response getResponse() {
            return this.response;
        }
    }

    private class Client {
        protected SocketChannel socketChannel;
        protected List writeBuffers;

        protected Client(SocketChannel channel) {
            this.socketChannel = channel;
            this.writeBuffers = new ArrayList();
        }

        protected void read(SelectionKey key) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            byte[] bytes = new byte[1024];
            int readLen = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            do {
                if ((readLen = this.socketChannel.read(buffer)) == -1) {
                    return;
                }
                if (readLen <= 0) continue;
                buffer.flip();
                buffer.get(bytes, 0, readLen);
                baos.write(bytes, 0, readLen);
                buffer.flip();
            } while (readLen > 0 && readLen != bytes.length);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            StringBuffer action = new StringBuffer();
            int c = 0;
            while ((c = bais.read()) != -1 && c != 10) {
                if (c == 13) continue;
                action.append((char)c);
            }
            String requestId = null;
            if (DefaultServerService.this.sequence != null) {
                requestId = DefaultServerService.this.sequence.increment();
            }
            DefaultServerService.this.queueHandlerContainer.push(new RequestContextImpl(new RequestImpl(this, action.toString(), requestId, bais), new ResponseImpl(this, key)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void write(SelectionKey key) throws IOException {
            List list = this.writeBuffers;
            synchronized (list) {
                while (this.writeBuffers.size() > 0) {
                    this.socketChannel.write((ByteBuffer)this.writeBuffers.remove(0));
                }
            }
            key.interestOps(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addResponse(SelectionKey key, int status, InputStream is) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            if (is != null) {
                int readLen = 0;
                while ((readLen = is.read(bytes)) > 0) {
                    baos.write(bytes, 0, readLen);
                }
            }
            bytes = baos.toByteArray();
            baos.reset();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(status);
            dos.writeInt(bytes.length);
            dos.write(bytes);
            dos.flush();
            bytes = baos.toByteArray();
            ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
            buffer.put(bytes);
            buffer.flip();
            List list = this.writeBuffers;
            synchronized (list) {
                this.writeBuffers.add(buffer);
            }
            if (key.interestOps() != 5) {
                key.interestOps(5);
            }
        }
    }

    private class DispatchDaemonRunnable
    extends DaemonRunnableAdaptor {
        private DispatchDaemonRunnable() {
        }

        public Object provide(DaemonControl ctrl) throws Throwable {
            try {
                int count = DefaultServerService.this.selector.select(1000L);
                if (count > 0) {
                    return DefaultServerService.this.selector.selectedKeys();
                }
                return null;
            }
            catch (Throwable e) {
                DefaultServerService.this.getLogger().write("DSS__00001", DefaultServerService.this.getServiceNameObject(), e);
                DefaultServerService.this.close();
                try {
                    DefaultServerService.this.connect();
                }
                catch (IOException e2) {
                    DefaultServerService.this.close();
                    DefaultServerService.this.getLogger().write("DSS__00002", DefaultServerService.this.getServiceNameObject(), (Throwable)e2);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
            if (paramObj == null) {
                return;
            }
            SelectionKey key = null;
            Set selectedKeys = (Set)paramObj;
            try {
                Iterator keyIterator = selectedKeys.iterator();
                while (keyIterator.hasNext()) {
                    try {
                        Client client;
                        key = (SelectionKey)keyIterator.next();
                        if (!key.isValid()) {
                            key.cancel();
                            continue;
                        }
                        if (key.isAcceptable()) {
                            ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
                            SocketChannel socketChannel = serverSocketChannel.accept();
                            socketChannel.configureBlocking(false);
                            socketChannel.register(key.selector(), 1, new Client(socketChannel));
                            continue;
                        }
                        if (key.isWritable()) {
                            client = (Client)key.attachment();
                            client.write(key);
                        }
                        if (!key.isReadable()) continue;
                        client = (Client)key.attachment();
                        client.read(key);
                    }
                    catch (CancelledKeyException e) {
                    }
                    catch (IOException e) {
                        key.cancel();
                    }
                    finally {
                        keyIterator.remove();
                    }
                }
                return;
            }
            catch (Throwable e) {
                DefaultServerService.this.getLogger().write("ERROR", (Object)"SelectionKey handle error.", e);
            }
        }
    }
}

