/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.scheduler2.DefaultSchedule;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleMakerServiceMBean;
import jp.ossc.nimbus.service.scheduler2.IllegalScheduleMasterException;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleMakeException;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaker;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaster;

public class DefaultScheduleMakerService
extends ServiceBase
implements ScheduleMaker,
DefaultScheduleMakerServiceMBean {
    private static final long serialVersionUID = -8603198587673383956L;

    public Schedule[] makeSchedule(Date date, ScheduleMaster master) throws ScheduleMakeException {
        if (!master.isEnabled()) {
            return new Schedule[0];
        }
        if (!this.isNecessaryMake(date, master)) {
            return new Schedule[0];
        }
        master.applyDate(date);
        this.checkScheduleMaster(master);
        if (master.getEndTime() == null || master.getStartTime().equals(master.getEndTime()) || master.getRepeatInterval() <= 0L && master.getRetryInterval() > 0L) {
            return new Schedule[]{this.makeSingleSchedule(master)};
        }
        return this.makeRepeatSchedule(master);
    }

    public boolean isMakeSchedule(Date date, ScheduleMaster master) throws ScheduleMakeException {
        return this.isNecessaryMake(date, master);
    }

    protected void checkScheduleMaster(ScheduleMaster master) throws IllegalScheduleMasterException {
        if (master.getId() == null) {
            throw new IllegalScheduleMasterException("Id is null.");
        }
        if (master.getTaskName() == null) {
            throw new IllegalScheduleMasterException("TaskName is null. id=" + master.getId());
        }
        if (master.getStartTime() == null) {
            throw new IllegalScheduleMasterException("StartTime is null. id=" + master.getId());
        }
        if (master.getEndTime() != null && master.getEndTime().before(master.getStartTime())) {
            throw new IllegalScheduleMasterException("EndTime is before StartTime. id=" + master.getId());
        }
        if (master.getEndTime() != null && master.getEndTime().after(master.getStartTime()) && master.getRepeatInterval() <= 0L) {
            throw new IllegalScheduleMasterException("RepeatInterval <= 0. id=" + master.getId());
        }
        if (master.getRetryEndTime() != null && !master.getRetryEndTime().after(master.getStartTime())) {
            throw new IllegalScheduleMasterException("RetryEndTime is before StartTime. id=" + master.getId());
        }
        if (master.getRetryInterval() <= 0L && master.getRetryEndTime() != null) {
            throw new IllegalScheduleMasterException("RetryInterval <= 0. id=" + master.getId());
        }
        if (master.getRetryInterval() > 0L && master.getRetryEndTime() != null) {
            Calendar offset = Calendar.getInstance();
            offset.setTime(master.getStartTime());
            Calendar end = Calendar.getInstance();
            end.setTime(master.getRetryEndTime());
            Date firstRetryTime = this.calculateNextDate(offset, master.getRetryInterval(), end);
            if (firstRetryTime == null) {
                throw new IllegalScheduleMasterException("First RetryTime is after RetryEndTime. id=" + master.getId());
            }
        }
    }

    protected boolean isNecessaryMake(Date date, ScheduleMaster master) throws ScheduleMakeException {
        return true;
    }

    protected Schedule makeSingleSchedule(ScheduleMaster master) throws ScheduleMakeException {
        return new DefaultSchedule(master.getId(), master.getStartTime(), master.getTaskName(), master.getInput(), master.getDepends(), master.getExecutorKey(), master.getExecutorType(), master.getRetryInterval(), master.getRetryEndTime(), master.getMaxDelayTime());
    }

    protected Schedule[] makeRepeatSchedule(ScheduleMaster master) throws ScheduleMakeException {
        ArrayList<DefaultSchedule> result = new ArrayList<DefaultSchedule>();
        Date time = master.getStartTime();
        Calendar offset = Calendar.getInstance();
        offset.setTime(master.getStartTime());
        Calendar end = Calendar.getInstance();
        end.setTime(master.getEndTime());
        do {
            result.add(new DefaultSchedule(master.getId(), time, master.getTaskName(), master.getInput(), master.getDepends(), master.getExecutorKey(), master.getExecutorType(), master.getRetryInterval(), master.getRetryEndTime(), master.getMaxDelayTime()));
        } while ((time = this.calculateNextDate(offset, master.getRepeatInterval(), end)) != null);
        return result.toArray(new Schedule[result.size()]);
    }

    protected Date calculateNextDate(Calendar offset, long interval, Calendar end) {
        if (interval > Integer.MAX_VALUE) {
            long offsetInterval = interval;
            int tmpInterval = 0;
            do {
                tmpInterval = offsetInterval >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)offsetInterval;
                offset.add(14, tmpInterval);
            } while ((offsetInterval -= Integer.MAX_VALUE) > 0L);
        } else {
            offset.add(14, (int)interval);
        }
        if (offset.after(end)) {
            return null;
        }
        return offset.getTime();
    }
}

